
/**
 * Synchronous and asynchronous client classes for accessing AmazonElasticLoadBalancing.
 *
 * Elastic Load Balancing <p>
 * Elastic Load Balancing is a cost-effective and easy to use web
 * service to help you improve the availability and scalability of your
 * application running on Amazon Elastic Cloud Compute (Amazon EC2). It
 * makes it easy for you to distribute application loads between two or
 * more EC2 instances. Elastic Load Balancing supports the growth in
 * traffic of your application by enabling availability through
 * redundancy.
 * </p>
 * <p>
 * This guide provides detailed information about Elastic Load Balancing
 * actions, data types, and parameters that can be used for sending a
 * query request. Query requests are HTTP or HTTPS requests that use the
 * HTTP verb GET or POST and a query parameter named Action or Operation.
 * Action is used throughout this documentation, although Operation is
 * supported for backward compatibility with other AWS Query APIs.
 * </p>
 * <p>
 * For detailed information on constructing a query request using the
 * actions, data types, and parameters mentioned in this guide, go to
 * <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/using-query-api.html"> Using the Query API </a>
 * in the <i>Elastic Load Balancing Developer Guide</i> .
 * </p>
 * <p>
 * For detailed information about Elastic Load Balancing features and
 * their associated actions, go to
 * <a href="http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/UserScenarios.html"> Using Elastic Load Balancing </a>
 * in the <i>Elastic Load Balancing Developer Guide</i> .
 * </p>
 * <p>
 * This reference guide is based on the current WSDL, which is available
 * at:
 * <a href="http://ec2-downloads.s3.amazonaws.com/ElasticLoadBalancing.wsdl"> </a>
 * 
 * </p>
 * <p>
 * <b>Endpoints</b>
 * </p>
 * <p>
 * The examples in this guide assume that your load balancers are created
 * in the US East (Northern Virginia) region and use us-east-1 as the
 * endpoint.
 * </p>
 * <p>
 * You can create your load balancers in other AWS regions. For
 * information about regions and endpoints supported by Elastic Load
 * Balancing, see
 * <a href="http://docs.aws.amazon.com/general/latest/gr/index.html?rande.html"> Regions and Endpoints </a>
 * in the Amazon Web Services General Reference.
 * </p>
 */
 package com.amazonaws.services.elasticloadbalancing;
        