/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobile.auth.core.IdentityManager;
import com.amazonaws.mobile.auth.core.IdentityProvider;
import com.amazonaws.mobile.auth.core.SignInStateChangeListener;
import com.amazonaws.mobile.auth.core.StartupAuthResult;
import com.amazonaws.mobile.auth.core.StartupAuthResultHandler;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.facebook.FacebookButton;
import com.amazonaws.mobile.auth.facebook.FacebookSignInProvider;
import com.amazonaws.mobile.auth.google.GoogleButton;
import com.amazonaws.mobile.auth.google.GoogleSignInProvider;
import com.amazonaws.mobile.auth.ui.AuthUIConfiguration;
import com.amazonaws.mobile.auth.ui.SignInUI;
import com.amazonaws.mobile.auth.userpools.CognitoUserPoolsSignInProvider;
import com.amazonaws.mobile.client.AWSMobileClientStore;
import com.amazonaws.mobile.client.AWSStartupHandler;
import com.amazonaws.mobile.client.AWSStartupResult;
import com.amazonaws.mobile.client.Callback;
import com.amazonaws.mobile.client.SignInUIOptions;
import com.amazonaws.mobile.client.UserState;
import com.amazonaws.mobile.client.UserStateDetails;
import com.amazonaws.mobile.client.UserStateListener;
import com.amazonaws.mobile.client.internal.InternalCallback;
import com.amazonaws.mobile.client.results.ForgotPasswordResult;
import com.amazonaws.mobile.client.results.ForgotPasswordState;
import com.amazonaws.mobile.client.results.SignInResult;
import com.amazonaws.mobile.client.results.SignInState;
import com.amazonaws.mobile.client.results.SignUpResult;
import com.amazonaws.mobile.client.results.Tokens;
import com.amazonaws.mobile.client.results.UserCodeDeliveryDetails;
import com.amazonaws.mobile.config.AWSConfigurable;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoDevice;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserPool;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSession;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ForgotPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.MultiFactorAuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.NewPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.ForgotPasswordHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GenericHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GetDetailsHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.SignUpHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.UpdateAttributesHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.VerificationHandler;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public final class AWSMobileClient
implements AWSCredentialsProvider {
    private static final String TAG = AWSMobileClient.class.getSimpleName();
    static final String SHARED_PREFERENCES_KEY = "com.amazonaws.mobile.client";
    static final String PROVIDER_KEY = "provider";
    static final String TOKEN_KEY = "token";
    static final String IDENTITY_ID_KEY = "identityId";
    private static final String USER_POOLS = "CognitoUserPool";
    private static final String FACEBOOK = "FacebookSignIn";
    private static final String GOOGLE = "GoogleSignIn";
    private static final String GOOGLE_WEBAPP_CONFIG_KEY = "ClientId-WebApp";
    private static volatile AWSMobileClient singleton = null;
    private final LinkedHashMap<Class<? extends AWSConfigurable>, AWSConfigurable> clientMap;
    private AWSConfiguration awsConfiguration;
    CognitoCachingCredentialsProvider cognitoIdentity;
    private CognitoUserPool userpool;
    private String userpoolsLoginKey;
    Context mContext;
    Map<String, String> mFederatedLoginsMap;
    private UserStateDetails userStateDetails;
    private Lock mWaitForSignInLock;
    private volatile CountDownLatch mSignedOutWaitLatch;
    CognitoUserSession mCognitoUserSession;
    private Callback<SignInResult> signInCallback;
    private MultiFactorAuthenticationContinuation signInMfaContinuation;
    private ChallengeContinuation signInChallengeContinuation;
    private SignInState signInState;
    private Callback<ForgotPasswordResult> forgotPasswordCallback;
    private ForgotPasswordContinuation forgotPasswordContinuation;
    private CognitoUser signUpUser;
    private AWSCredentialsProvider awsCredentialsProvider;
    private SignInProviderConfig[] signInProviderConfig;
    private StartupAuthResultHandler startupAuthResultHandler;
    private AWSStartupHandler awsStartupHandler;
    private boolean mIsLegacyMode;
    List<UserStateListener> listeners;
    private Object showSignInLockObject;
    private volatile CountDownLatch showSignInWaitLatch;
    private Object federateWithCognitoIdentityLockObject;
    private Object initLockObject;
    AWSMobileClientStore mStore;

    private AWSMobileClient() {
        if (singleton != null) {
            throw new AssertionError();
        }
        this.clientMap = new LinkedHashMap();
        this.userpoolsLoginKey = "";
        this.mWaitForSignInLock = new ReentrantLock();
        this.mFederatedLoginsMap = new HashMap<String, String>();
        this.listeners = new ArrayList<UserStateListener>();
        this.showSignInLockObject = new Object();
        this.federateWithCognitoIdentityLockObject = new Object();
        this.showSignInWaitLatch = new CountDownLatch(1);
        this.initLockObject = new Object();
    }

    public static synchronized AWSMobileClient getInstance() {
        if (singleton == null) {
            singleton = new AWSMobileClient();
        }
        return singleton;
    }

    public AWSConfiguration getConfiguration() {
        return this.awsConfiguration;
    }

    public AWSCredentials getCredentials() {
        if (this.isLegacyMode()) {
            return IdentityManager.getDefaultIdentityManager().getCredentialsProvider().getCredentials();
        }
        if (this.cognitoIdentity == null) {
            throw new RuntimeException("Cognito Identity not configured");
        }
        try {
            if (this.waitForSignIn()) {
                Log.d((String)TAG, (String)"getCredentials: Validated user is signed-in");
            }
            AWSSessionCredentials credentials = this.cognitoIdentity.getCredentials();
            this.mStore.set(IDENTITY_ID_KEY, this.cognitoIdentity.getIdentityId());
            return credentials;
        }
        catch (NotAuthorizedException e) {
            Log.w((String)TAG, (String)"getCredentials: Failed to getCredentials from Cognito Identity", (Throwable)e);
            throw new RuntimeException("Failed to get credentials from Cognito Identity", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get credentials from Cognito Identity", e);
        }
    }

    public void refresh() {
        if (this.isLegacyMode()) {
            IdentityManager.getDefaultIdentityManager().getCredentialsProvider().refresh();
            return;
        }
        if (this.cognitoIdentity == null) {
            throw new RuntimeException("Cognito Identity not configured");
        }
        this.cognitoIdentity.refresh();
        this.mStore.set(IDENTITY_ID_KEY, this.cognitoIdentity.getIdentityId());
    }

    public AWSCredentials getAWSCredentials() throws Exception {
        InternalCallback<AWSCredentials> internalCallback = new InternalCallback<AWSCredentials>();
        return internalCallback.await(this._getAWSCredentials(internalCallback));
    }

    public void getAWSCredentials(Callback<AWSCredentials> callback) {
        InternalCallback<AWSCredentials> internalCallback = new InternalCallback<AWSCredentials>(callback);
        internalCallback.async(this._getAWSCredentials(internalCallback));
    }

    private Runnable _getAWSCredentials(final Callback<AWSCredentials> callback) {
        return new Runnable(){

            @Override
            public void run() {
                AWSCredentials credentials = null;
                try {
                    credentials = AWSMobileClient.this.getCredentials();
                }
                catch (Exception e) {
                    callback.onError(e);
                }
                callback.onResult(credentials);
            }
        };
    }

    public String getIdentityId() {
        if (this.isLegacyMode()) {
            return IdentityManager.getDefaultIdentityManager().getCachedUserID();
        }
        if (this.cognitoIdentity == null) {
            throw new RuntimeException("Cognito Identity not configured");
        }
        String cachedIdentityId = this.cognitoIdentity.getCachedIdentityId();
        if (cachedIdentityId == null) {
            return this.mStore.get(IDENTITY_ID_KEY);
        }
        return cachedIdentityId;
    }

    boolean isLegacyMode() {
        return this.mIsLegacyMode;
    }

    public void initialize(Context context, Callback<UserStateDetails> callback) {
        Context applicationContext = context.getApplicationContext();
        this.initialize(applicationContext, new AWSConfiguration(applicationContext), callback);
    }

    public void initialize(Context context, AWSConfiguration awsConfig, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._initialize(context, awsConfig, internalCallback));
    }

    protected Runnable _initialize(final Context context, final AWSConfiguration awsConfig, final Callback<UserStateDetails> callback) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = AWSMobileClient.this.initLockObject;
                    synchronized (object) {
                        JSONObject userPoolJSON;
                        if (AWSMobileClient.this.mContext != null) {
                            callback.onResult(AWSMobileClient.this.getUserStateDetails(true));
                            return;
                        }
                        AWSMobileClient.this.mContext = context.getApplicationContext();
                        AWSMobileClient.this.mStore = new AWSMobileClientStore(AWSMobileClient.this);
                        AWSMobileClient.this.awsConfiguration = awsConfig;
                        final IdentityManager identityManager = new IdentityManager(AWSMobileClient.this.mContext);
                        identityManager.enableFederation(false);
                        identityManager.setConfiguration(AWSMobileClient.this.awsConfiguration);
                        IdentityManager.setDefaultIdentityManager((IdentityManager)identityManager);
                        AWSMobileClient.this.registerConfigSignInProviders();
                        identityManager.addSignInStateChangeListener(new SignInStateChangeListener(){

                            public void onUserSignedIn() {
                                Log.d((String)TAG, (String)"onUserSignedIn: Updating user state from drop-in UI");
                                AWSMobileClient.this.signInState = SignInState.DONE;
                                IdentityProvider currentIdentityProvider = identityManager.getCurrentIdentityProvider();
                                String token = currentIdentityProvider.getToken();
                                String providerKey = currentIdentityProvider.getCognitoLoginKey();
                                AWSMobileClient.this.federatedSignInWithoutAssigningState(providerKey, token, new Callback<UserStateDetails>(){

                                    @Override
                                    public void onResult(UserStateDetails result) {
                                        AWSMobileClient.this.setUserState(AWSMobileClient.this.getUserStateDetails(false));
                                        AWSMobileClient.this.showSignInWaitLatch.countDown();
                                    }

                                    @Override
                                    public void onError(Exception e) {
                                        Log.w((String)TAG, (String)"onError: User sign-in had errors from drop-in UI", (Throwable)e);
                                        AWSMobileClient.this.setUserState(AWSMobileClient.this.getUserStateDetails(false));
                                        AWSMobileClient.this.showSignInWaitLatch.countDown();
                                    }
                                });
                            }

                            public void onUserSignedOut() {
                                Log.d((String)TAG, (String)"onUserSignedOut: Updating user state from drop-in UI");
                                AWSMobileClient.this.setUserState(AWSMobileClient.this.getUserStateDetails(false));
                                AWSMobileClient.this.showSignInWaitLatch.countDown();
                            }
                        });
                        if (AWSMobileClient.this.awsConfiguration.optJsonObject("CredentialsProvider") != null && awsConfig.optJsonObject("CredentialsProvider").optJSONObject("CognitoIdentity") != null) {
                            try {
                                AWSMobileClient.this.cognitoIdentity = new CognitoCachingCredentialsProvider(AWSMobileClient.this.mContext, AWSMobileClient.this.awsConfiguration);
                            }
                            catch (Exception e) {
                                callback.onError(new RuntimeException("Failed to initialize Cognito Identity; please check your awsconfiguration.json", e));
                                return;
                            }
                        }
                        if ((userPoolJSON = AWSMobileClient.this.awsConfiguration.optJsonObject(AWSMobileClient.USER_POOLS)) != null) {
                            try {
                                AWSMobileClient.this.userpoolsLoginKey = String.format("cognito-idp.%s.amazonaws.com/%s", userPoolJSON.getString("Region"), userPoolJSON.getString("PoolId"));
                                AWSMobileClient.this.userpool = new CognitoUserPool(AWSMobileClient.this.mContext, AWSMobileClient.this.awsConfiguration);
                            }
                            catch (Exception e) {
                                callback.onError(new RuntimeException("Failed to initialize Cognito Userpool; please check your awsconfiguration.json", e));
                                return;
                            }
                        }
                        if (AWSMobileClient.this.cognitoIdentity == null && AWSMobileClient.this.userpool == null) {
                            callback.onError(new RuntimeException("Neither Cognito Identity or Cognito UserPool was used. At least one must be present to use AWSMobileClient."));
                            return;
                        }
                        UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(true);
                        callback.onResult(userStateDetails);
                        AWSMobileClient.this.setUserState(userStateDetails);
                    }
                }
                catch (RuntimeException e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void releaseSignInWait() {
        if (this.mSignedOutWaitLatch != null) {
            this.mSignedOutWaitLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserState(final UserStateDetails details) {
        boolean hasChanged = !details.equals(this.userStateDetails);
        this.userStateDetails = details;
        if (hasChanged) {
            List<UserStateListener> list = this.listeners;
            synchronized (list) {
                for (final UserStateListener listener : this.listeners) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onUserStateChanged(details);
                        }
                    }).start();
                }
            }
        }
    }

    protected boolean isNetworkAvailable(Context context) {
        try {
            Class.forName("android.support.v4.content.ContextCompat");
            int hasReadExternalStoragePermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE");
            if (hasReadExternalStoragePermission != 0) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            Log.w((String)TAG, (String)"Could not check if ACCESS_NETWORK_STATE permission is available.", (Throwable)e);
        }
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                return true;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not access network state", (Throwable)e);
        }
        return false;
    }

    boolean isUserpoolsSignedIn() {
        return this.userpoolsLoginKey.equals(this.mStore.get(PROVIDER_KEY));
    }

    public String getUsername() {
        try {
            if (this.userpoolsLoginKey.equals(this.mStore.get(PROVIDER_KEY))) {
                return this.userpool.getCurrentUser().getUserId();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public UserStateDetails currentUserState() {
        return this.getUserStateDetails(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserStateListener(UserStateListener listener) {
        List<UserStateListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUserStateListener(UserStateListener listener) {
        List<UserStateListener> list = this.listeners;
        synchronized (list) {
            int index = this.listeners.indexOf(listener);
            if (index != -1) {
                this.listeners.remove(index);
                return true;
            }
            return false;
        }
    }

    String getLoginKey() {
        return this.userpoolsLoginKey;
    }

    public boolean isSignedIn() {
        UserStateDetails userStateDetails = this.getUserStateDetails(false);
        switch (userStateDetails.getUserState()) {
            case SIGNED_IN: 
            case SIGNED_OUT_USER_POOLS_TOKENS_INVALID: 
            case SIGNED_OUT_FEDERATED_TOKENS_INVALID: {
                return true;
            }
            case GUEST: 
            case SIGNED_OUT: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown user state, please report this exception");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean waitForSignIn() {
        try {
            this.mWaitForSignInLock.lock();
            this.mSignedOutWaitLatch = new CountDownLatch(1);
            UserStateDetails userStateDetails = this.getUserStateDetails(false);
            Log.d((String)TAG, (String)("waitForSignIn: userState:" + (Object)((Object)userStateDetails.getUserState())));
            this.setUserState(userStateDetails);
            switch (userStateDetails.getUserState()) {
                case SIGNED_IN: {
                    boolean bl = true;
                    return bl;
                }
                case GUEST: 
                case SIGNED_OUT: {
                    boolean bl = false;
                    return bl;
                }
                case SIGNED_OUT_USER_POOLS_TOKENS_INVALID: 
                case SIGNED_OUT_FEDERATED_TOKENS_INVALID: {
                    this.mSignedOutWaitLatch.await();
                    boolean bl = this.getUserStateDetails(false).getUserState().equals((Object)UserState.SIGNED_IN);
                    return bl;
                }
            }
            return false;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Exception when waiting for sign-in", (Throwable)e);
            return false;
        }
        finally {
            this.mWaitForSignInLock.unlock();
        }
    }

    Map<String, String> getSignInDetailsMap() {
        return this.mStore.get(PROVIDER_KEY, TOKEN_KEY);
    }

    String _getCachedIdentityId() {
        return this.mStore.get(IDENTITY_ID_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UserStateDetails getUserStateDetails(boolean offlineCheck) {
        boolean hasUsefulToken;
        Map<String, String> details = this.getSignInDetailsMap();
        String providerKey = details.get(PROVIDER_KEY);
        String token = details.get(TOKEN_KEY);
        String identityId = this._getCachedIdentityId();
        Log.d((String)TAG, (String)"Inspecting user state details");
        boolean bl = hasUsefulToken = providerKey != null && token != null;
        if (offlineCheck || !this.isNetworkAvailable(this.mContext)) {
            if (hasUsefulToken) {
                return new UserStateDetails(UserState.SIGNED_IN, details);
            }
            if (identityId == null) return new UserStateDetails(UserState.SIGNED_OUT, null);
            return new UserStateDetails(UserState.GUEST, details);
        }
        if (hasUsefulToken && !this.userpoolsLoginKey.equals(providerKey)) {
            try {
                if (this.hasFederatedToken(providerKey, token)) {
                    Log.d((String)TAG, (String)"getUserStateDetails: token already federated just fetch credentials");
                    if (this.cognitoIdentity == null) return new UserStateDetails(UserState.SIGNED_IN, details);
                    this.cognitoIdentity.getCredentials();
                    return new UserStateDetails(UserState.SIGNED_IN, details);
                }
                this.federateWithCognitoIdentity(providerKey, token);
                return new UserStateDetails(UserState.SIGNED_IN, details);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Failed to federate the tokens.", (Throwable)e);
                if (!(e instanceof NotAuthorizedException)) return new UserStateDetails(UserState.SIGNED_IN, details);
                return new UserStateDetails(UserState.SIGNED_OUT_FEDERATED_TOKENS_INVALID, details);
            }
        }
        if (hasUsefulToken && this.userpool != null) {
            Tokens tokens = null;
            String idToken = null;
            try {
                block18: {
                    tokens = this.getTokens(false);
                    idToken = tokens.getIdToken().getTokenString();
                    details.put(TOKEN_KEY, idToken);
                    if (this.hasFederatedToken(providerKey, idToken)) {
                        try {
                            if (this.cognitoIdentity != null) {
                                this.cognitoIdentity.getCredentials();
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (String)"Failed to get or refresh credentials from Cognito Identity", (Throwable)e);
                        }
                    }
                    if (this.cognitoIdentity != null) {
                        this.federateWithCognitoIdentity(providerKey, idToken);
                    }
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)(tokens == null ? "Tokens are invalid, please sign-in again." : "Failed to federate the tokens"), (Throwable)e);
            }
            finally {
                if (tokens == null) return new UserStateDetails(UserState.SIGNED_OUT_USER_POOLS_TOKENS_INVALID, details);
                if (idToken == null) return new UserStateDetails(UserState.SIGNED_OUT_USER_POOLS_TOKENS_INVALID, details);
                return new UserStateDetails(UserState.SIGNED_IN, details);
            }
        }
        if (this.cognitoIdentity == null) {
            return new UserStateDetails(UserState.SIGNED_OUT, details);
        }
        if (identityId == null) return new UserStateDetails(UserState.SIGNED_OUT, null);
        return new UserStateDetails(UserState.GUEST, details);
    }

    private boolean hasFederatedToken(String providerKey, String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        boolean hasFederatedToken = token.equals(this.mFederatedLoginsMap.get(providerKey));
        Log.d((String)TAG, (String)("hasFederatedToken: " + hasFederatedToken + " provider: " + providerKey));
        return hasFederatedToken;
    }

    public void signIn(String username, String password, Map<String, String> validationData, Callback<SignInResult> callback) {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>(callback);
        internalCallback.async(this._signIn(username, password, validationData, internalCallback));
    }

    public SignInResult signIn(String username, String password, Map<String, String> validationData) throws Exception {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>();
        return internalCallback.await(this._signIn(username, password, validationData, internalCallback));
    }

    private Runnable _signIn(final String username, final String password, final Map<String, String> validationData, final Callback<SignInResult> callback) {
        this.signInCallback = callback;
        this.signInState = null;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AWSMobileClient.this.userpool.getUser(username).getSession(new AuthenticationHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
                            try {
                                AWSMobileClient.this.mCognitoUserSession = userSession;
                                AWSMobileClient.this.signInState = SignInState.DONE;
                            }
                            catch (Exception e) {
                                AWSMobileClient.this.signInCallback.onError(e);
                                AWSMobileClient.this.signInCallback = null;
                            }
                            try {
                                AWSMobileClient.this.federatedSignInWithoutAssigningState(AWSMobileClient.this.userpoolsLoginKey, AWSMobileClient.this.mCognitoUserSession.getIdToken().getJWTToken(), new Callback<UserStateDetails>(){

                                    @Override
                                    public void onResult(UserStateDetails result) {
                                    }

                                    @Override
                                    public void onError(Exception e) {
                                    }
                                });
                                AWSMobileClient.this.releaseSignInWait();
                            }
                            catch (Exception e) {
                                Log.w((String)TAG, (String)"Failed to federate tokens during sign-in", (Throwable)e);
                            }
                            finally {
                                AWSMobileClient.this.setUserState(new UserStateDetails(UserState.SIGNED_IN, AWSMobileClient.this.getSignInDetailsMap()));
                            }
                            AWSMobileClient.this.signInCallback.onResult(SignInResult.DONE);
                        }

                        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String userId) {
                            Log.d((String)TAG, (String)"Sending password.");
                            authenticationContinuation.setAuthenticationDetails(new AuthenticationDetails(username, password, validationData));
                            authenticationContinuation.continueTask();
                        }

                        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
                            AWSMobileClient.this.signInMfaContinuation = continuation;
                            CognitoUserCodeDeliveryDetails parameters = continuation.getParameters();
                            AWSMobileClient.this.signInState = SignInState.SMS_MFA;
                            AWSMobileClient.this.signInCallback.onResult(new SignInResult(SignInState.SMS_MFA, new UserCodeDeliveryDetails(parameters.getDestination(), parameters.getDeliveryMedium(), parameters.getAttributeName())));
                        }

                        public void authenticationChallenge(ChallengeContinuation continuation) {
                            try {
                                AWSMobileClient.this.signInState = SignInState.valueOf(continuation.getChallengeName());
                                AWSMobileClient.this.signInChallengeContinuation = continuation;
                                AWSMobileClient.this.signInCallback.onResult(new SignInResult(AWSMobileClient.this.signInState, continuation.getParameters()));
                            }
                            catch (IllegalArgumentException e) {
                                AWSMobileClient.this.signInCallback.onError(e);
                            }
                        }

                        public void onFailure(Exception exception) {
                            AWSMobileClient.this.signInCallback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void signOut() {
        this.mCognitoUserSession = null;
        if (this.userpool != null) {
            this.userpool.getCurrentUser().signOut();
        }
        if (this.cognitoIdentity != null) {
            this.cognitoIdentity.clear();
        }
        if (IdentityManager.getDefaultIdentityManager() != null) {
            IdentityManager.getDefaultIdentityManager().signOut();
        }
        this.mStore.clear();
        this.setUserState(this.getUserStateDetails(false));
        this.releaseSignInWait();
    }

    public void federatedSignIn(String providerKey, String token, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._federatedSignIn(providerKey, token, internalCallback, true));
    }

    public void federatedSignIn(String providerKey, String token) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        internalCallback.await(this._federatedSignIn(providerKey, token, internalCallback, true));
    }

    protected void federatedSignInWithoutAssigningState(String providerKey, String token) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        internalCallback.await(this._federatedSignIn(providerKey, token, internalCallback, false));
    }

    protected void federatedSignInWithoutAssigningState(String providerKey, String token, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._federatedSignIn(providerKey, token, internalCallback, false));
    }

    private Runnable _federatedSignIn(final String providerKey, final String token, final Callback<UserStateDetails> callback, final boolean assignState) {
        final HashMap<String, String> loginsMap = new HashMap<String, String>();
        loginsMap.put(providerKey, token);
        Log.d((String)TAG, (String)String.format("_federatedSignIn: Putting provider and token in store", new Object[0]));
        HashMap<String, String> details = new HashMap<String, String>();
        details.put(PROVIDER_KEY, providerKey);
        details.put(TOKEN_KEY, token);
        this.mStore.set(details);
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (AWSMobileClient.this.cognitoIdentity == null) {
                        callback.onError(new Exception("Federation is not enabled, please check if you have CognitoIdentity configured."));
                        return;
                    }
                    if (!token.equals(AWSMobileClient.this.mFederatedLoginsMap.get(providerKey))) {
                        AWSMobileClient.this.cognitoIdentity.clear();
                        AWSMobileClient.this.cognitoIdentity.setLogins(loginsMap);
                    }
                    UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(true);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AWSMobileClient.this.federateWithCognitoIdentity(providerKey, token);
                            }
                            catch (Exception e) {
                                Log.w((String)TAG, (String)"Failed to federate with Cognito Identity in the background", (Throwable)e);
                            }
                        }
                    }).start();
                    callback.onResult(userStateDetails);
                    this.end(userStateDetails);
                }
                catch (Exception exception) {
                    callback.onError(new RuntimeException("Error in federating the token.", exception));
                    return;
                }
            }

            private void end(UserStateDetails details) {
                if (assignState) {
                    AWSMobileClient.this.setUserState(details);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void federateWithCognitoIdentity(String providerKey, String token) {
        Object object = this.federateWithCognitoIdentityLockObject;
        synchronized (object) {
            if (!this.hasFederatedToken(providerKey, token)) {
                HashMap<String, String> logins = new HashMap<String, String>();
                logins.put(providerKey, token);
                this.cognitoIdentity.setLogins(logins);
                this.cognitoIdentity.refresh();
                this.mStore.set(IDENTITY_ID_KEY, this.cognitoIdentity.getIdentityId());
                this.mFederatedLoginsMap = this.cognitoIdentity.getLogins();
            }
        }
    }

    public Tokens getTokens() throws Exception {
        InternalCallback<Tokens> internalCallback = new InternalCallback<Tokens>();
        return internalCallback.await(this._getTokens(internalCallback, true));
    }

    public void getTokens(Callback<Tokens> callback) {
        InternalCallback<Tokens> internalCallback = new InternalCallback<Tokens>(callback);
        internalCallback.async(this._getTokens(internalCallback, true));
    }

    protected Tokens getTokens(boolean waitForSignIn) throws Exception {
        InternalCallback<Tokens> internalCallback = new InternalCallback<Tokens>();
        return internalCallback.await(this._getTokens(internalCallback, waitForSignIn));
    }

    private Runnable _getTokens(final Callback<Tokens> callback, final boolean waitForSignIn) {
        return new Runnable(){

            @Override
            public void run() {
                String providerKey = AWSMobileClient.this.getSignInDetailsMap().get(AWSMobileClient.PROVIDER_KEY);
                if (providerKey != null && !AWSMobileClient.this.userpoolsLoginKey.equals(providerKey)) {
                    callback.onError(new Exception("getTokens does not support retrieving tokens for federated sign-in"));
                    return;
                }
                if (waitForSignIn && !AWSMobileClient.this.waitForSignIn()) {
                    callback.onError(new Exception("getTokens does not support retrieving tokens while signed-out"));
                    return;
                }
                if (!AWSMobileClient.this.isUserpoolsSignedIn()) {
                    callback.onError(new Exception("You must be signed-in with Cognito Userpools to be able to use getTokens"));
                }
                try {
                    AWSMobileClient.this.userpool.getCurrentUser().getSession(new AuthenticationHandler(){

                        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
                            try {
                                AWSMobileClient.this.mCognitoUserSession = userSession;
                                callback.onResult(new Tokens(userSession.getAccessToken().getJWTToken(), userSession.getIdToken().getJWTToken(), userSession.getRefreshToken().getToken()));
                            }
                            catch (Exception e) {
                                callback.onError(e);
                            }
                        }

                        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String userId) {
                            this.signalTokensNotAvailable(null);
                        }

                        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
                            this.signalTokensNotAvailable(null);
                        }

                        public void authenticationChallenge(ChallengeContinuation continuation) {
                            this.signalTokensNotAvailable(null);
                        }

                        public void onFailure(Exception exception) {
                            this.signalTokensNotAvailable(exception);
                        }

                        private void signalTokensNotAvailable(Exception e) {
                            Log.w((String)TAG, (String)"signalTokensNotAvailable");
                            callback.onError(new Exception("No cached session.", e));
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void signUp(String username, String password, Map<String, String> userAttributes, Map<String, String> validationData, Callback<SignUpResult> callback) {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>(callback);
        internalCallback.async(this._signUp(username, password, userAttributes, validationData, internalCallback));
    }

    public SignUpResult signUp(String username, String password, Map<String, String> userAttributes, Map<String, String> validationData) throws Exception {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>();
        return internalCallback.await(this._signUp(username, password, userAttributes, validationData, internalCallback));
    }

    private Runnable _signUp(final String username, final String password, final Map<String, String> userAttributes, final Map<String, String> validationData, final Callback<SignUpResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                CognitoUserAttributes cognitoUserAttr = new CognitoUserAttributes();
                for (String key : userAttributes.keySet()) {
                    cognitoUserAttr.addAttribute(key, (String)userAttributes.get(key));
                }
                try {
                    AWSMobileClient.this.userpool.signUp(username, password, cognitoUserAttr, validationData, new SignUpHandler(){

                        public void onSuccess(CognitoUser user, boolean signUpConfirmationState, CognitoUserCodeDeliveryDetails cognitoUserCodeDeliveryDetails) {
                            AWSMobileClient.this.signUpUser = user;
                            UserCodeDeliveryDetails userCodeDeliveryDetails = new UserCodeDeliveryDetails(cognitoUserCodeDeliveryDetails.getDestination(), cognitoUserCodeDeliveryDetails.getDeliveryMedium(), cognitoUserCodeDeliveryDetails.getAttributeName());
                            callback.onResult(new SignUpResult(signUpConfirmationState, userCodeDeliveryDetails));
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void confirmSignUp(String username, String signUpChallengeResponse, Callback<SignUpResult> callback) {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>(callback);
        internalCallback.async(this._confirmSignUp(username, signUpChallengeResponse, internalCallback));
    }

    public SignUpResult confirmSignUp(String username, String signUpChallengeResponse) throws Exception {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>();
        return internalCallback.await(this._confirmSignUp(username, signUpChallengeResponse, internalCallback));
    }

    private Runnable _confirmSignUp(final String username, final String signUpChallengeResponse, final Callback<SignUpResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AWSMobileClient.this.userpool.getUser(username).confirmSignUp(signUpChallengeResponse, true, new GenericHandler(){

                        public void onSuccess() {
                            callback.onResult(new SignUpResult(true, null));
                            AWSMobileClient.this.signUpUser = null;
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void resendSignUp(String username, Callback<SignUpResult> callback) {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>(callback);
        internalCallback.async(this._resendSignUp(username, internalCallback));
    }

    public SignUpResult resendSignUp(String username) throws Exception {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>();
        return internalCallback.await(this._resendSignUp(username, internalCallback));
    }

    private Runnable _resendSignUp(final String username, final Callback<SignUpResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AWSMobileClient.this.userpool.getUser(username).resendConfirmationCodeInBackground(new VerificationHandler(){

                        public void onSuccess(CognitoUserCodeDeliveryDetails verificationCodeDeliveryMedium) {
                            UserCodeDeliveryDetails userCodeDeliveryDetails = new UserCodeDeliveryDetails(verificationCodeDeliveryMedium.getDestination(), verificationCodeDeliveryMedium.getDeliveryMedium(), verificationCodeDeliveryMedium.getAttributeName());
                            callback.onResult(new SignUpResult(false, userCodeDeliveryDetails));
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void forgotPassword(String username, Callback<ForgotPasswordResult> callback) {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>(callback);
        internalCallback.async(this._forgotPassword(username, internalCallback));
    }

    public ForgotPasswordResult forgotPassword(String username) throws Exception {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>();
        return internalCallback.await(this._forgotPassword(username, internalCallback));
    }

    private Runnable _forgotPassword(final String username, final Callback<ForgotPasswordResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AWSMobileClient.this.forgotPasswordCallback = new InternalCallback(callback);
                    AWSMobileClient.this.userpool.getUser(username).forgotPasswordInBackground(new ForgotPasswordHandler(){

                        public void onSuccess() {
                            AWSMobileClient.this.forgotPasswordCallback.onResult(new ForgotPasswordResult(ForgotPasswordState.DONE));
                        }

                        public void getResetCode(ForgotPasswordContinuation continuation) {
                            AWSMobileClient.this.forgotPasswordContinuation = continuation;
                            ForgotPasswordResult result = new ForgotPasswordResult(ForgotPasswordState.CONFIRMATION_CODE);
                            CognitoUserCodeDeliveryDetails parameters = continuation.getParameters();
                            result.setParameters(new UserCodeDeliveryDetails(parameters.getDestination(), parameters.getDeliveryMedium(), parameters.getAttributeName()));
                            AWSMobileClient.this.forgotPasswordCallback.onResult(result);
                        }

                        public void onFailure(Exception exception) {
                            AWSMobileClient.this.forgotPasswordCallback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void confirmForgotPassword(String password, String forgotPasswordChallengeResponse, Callback<ForgotPasswordResult> callback) {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>(callback);
        internalCallback.async(this._confirmForgotPassword(password, forgotPasswordChallengeResponse, internalCallback));
    }

    public ForgotPasswordResult confirmForgotPassword(String password, String forgotPasswordChallengeResponse) throws Exception {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>();
        return internalCallback.await(this._confirmForgotPassword(password, forgotPasswordChallengeResponse, internalCallback));
    }

    private Runnable _confirmForgotPassword(final String password, final String forgotPasswordChallengeResponse, final Callback<ForgotPasswordResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (AWSMobileClient.this.forgotPasswordContinuation == null) {
                    callback.onError(new IllegalStateException("confirmForgotPassword called before initiating forgotPassword"));
                    return;
                }
                try {
                    AWSMobileClient.this.forgotPasswordContinuation.setPassword(password);
                    AWSMobileClient.this.forgotPasswordContinuation.setVerificationCode(forgotPasswordChallengeResponse);
                    AWSMobileClient.this.forgotPasswordCallback = new InternalCallback(callback);
                    AWSMobileClient.this.forgotPasswordContinuation.continueTask();
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void changePassword(String oldPassword, String newPassword, Callback<Void> callback) {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>(callback);
        internalCallback.async(this._changePassword(oldPassword, newPassword, internalCallback));
    }

    public void changePassword(String oldPassword, String newPassword) throws Exception {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>();
        internalCallback.await(this._changePassword(oldPassword, newPassword, internalCallback));
    }

    private Runnable _changePassword(final String oldPassword, final String newPassword, final Callback<Void> callback) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AWSMobileClient.this.userpool.getCurrentUser().changePassword(oldPassword, newPassword, new GenericHandler(){

                        public void onSuccess() {
                            callback.onResult(null);
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void confirmSignIn(String signInChallengeResponse, Callback<SignInResult> callback) {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>(callback);
        internalCallback.async(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    public SignInResult confirmSignIn(String signInChallengeResponse) throws Exception {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>();
        return internalCallback.await(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    private Runnable _confirmSignIn(final String signInChallengeResponse, final Callback<SignInResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (AWSMobileClient.this.signInState == null) {
                    callback.onError(new IllegalStateException("Cannot call confirmMFA(String, Callback) without initiating sign-in. This call is used for SMS_MFA and NEW_PASSWORD_REQUIREDsign-in state."));
                    return;
                }
                try {
                    MultiFactorAuthenticationContinuation detectedContinuation;
                    switch (AWSMobileClient.this.signInState) {
                        case SMS_MFA: {
                            AWSMobileClient.this.signInMfaContinuation.setMfaCode(signInChallengeResponse);
                            detectedContinuation = AWSMobileClient.this.signInMfaContinuation;
                            AWSMobileClient.this.signInCallback = new InternalCallback(callback);
                            break;
                        }
                        case NEW_PASSWORD_REQUIRED: {
                            ((NewPasswordContinuation)AWSMobileClient.this.signInChallengeContinuation).setPassword(signInChallengeResponse);
                            detectedContinuation = AWSMobileClient.this.signInChallengeContinuation;
                            AWSMobileClient.this.signInCallback = new InternalCallback(callback);
                            break;
                        }
                        case DONE: {
                            callback.onError(new IllegalStateException("confirmSignIn called after signIn has succeeded"));
                            return;
                        }
                        default: {
                            callback.onError(new IllegalStateException("confirmSignIn called on unsupported operation, please file a feature request"));
                            return;
                        }
                    }
                    if (detectedContinuation != null) {
                        detectedContinuation.continueTask();
                    }
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void confirmSignIn(Map<String, String> signInChallengeResponse, Callback<SignInResult> callback) {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>(callback);
        internalCallback.async(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    public SignInResult confirmSignIn(Map<String, String> signInChallengeResponse) throws Exception {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>();
        return internalCallback.await(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    private Runnable _confirmSignIn(final Map<String, String> signInChallengeResponse, final Callback<SignInResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (AWSMobileClient.this.signInState == null) {
                    callback.onError(new IllegalStateException("Cannot call confirmMFA(Map<String, String>, Callback) without initiating sign-in. This call is used for CUSTOM_CHALLENGE sign-in state."));
                    return;
                }
                try {
                    ChallengeContinuation detectedContinuation;
                    switch (AWSMobileClient.this.signInState) {
                        case SMS_MFA: 
                        case NEW_PASSWORD_REQUIRED: {
                            callback.onError(new IllegalStateException("Please use confirmSignIn(String, Callback) for SMS_MFA and NEW_PASSWORD_REQUIRED challenges"));
                        }
                        case CUSTOM_CHALLENGE: {
                            for (String key : signInChallengeResponse.keySet()) {
                                AWSMobileClient.this.signInChallengeContinuation.setChallengeResponse(key, (String)signInChallengeResponse.get(key));
                            }
                            detectedContinuation = AWSMobileClient.this.signInChallengeContinuation;
                            AWSMobileClient.this.signInCallback = new InternalCallback(callback);
                            break;
                        }
                        case DONE: {
                            detectedContinuation = null;
                            Log.d((String)TAG, (String)"confirmSignIn called after signIn has succeeded");
                            break;
                        }
                        default: {
                            callback.onError(new IllegalStateException("confirmSignIn called on unsupported operation, please file a feature request"));
                            return;
                        }
                    }
                    if (detectedContinuation != null) {
                        detectedContinuation.continueTask();
                    }
                }
                catch (IllegalStateException e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void getUserAttributes(Callback<Map<String, String>> callback) {
        InternalCallback<Map<String, String>> internalCallback = new InternalCallback<Map<String, String>>(callback);
        internalCallback.async(this._getUserAttributes(internalCallback));
    }

    public Map<String, String> getUserAttributes() throws Exception {
        InternalCallback<Map<String, String>> internalCallback = new InternalCallback<Map<String, String>>();
        return internalCallback.await(this._getUserAttributes(internalCallback));
    }

    private Runnable _getUserAttributes(final Callback<Map<String, String>> callback) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!AWSMobileClient.this.waitForSignIn()) {
                        callback.onError(new Exception("Operation requires a signed-in state"));
                        return;
                    }
                    AWSMobileClient.this.userpool.getCurrentUser().getDetails(new GetDetailsHandler(){

                        public void onSuccess(CognitoUserDetails cognitoUserDetails) {
                            callback.onResult(cognitoUserDetails.getAttributes().getAttributes());
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void updateUserAttributes(Map<String, String> userAttributes, Callback<List<UserCodeDeliveryDetails>> callback) {
        InternalCallback<List<UserCodeDeliveryDetails>> internalCallback = new InternalCallback<List<UserCodeDeliveryDetails>>(callback);
        internalCallback.async(this._updateUserAttributes(userAttributes, internalCallback));
    }

    public List<UserCodeDeliveryDetails> updateUserAttributes(Map<String, String> userAttributes) throws Exception {
        InternalCallback<List<UserCodeDeliveryDetails>> internalCallback = new InternalCallback<List<UserCodeDeliveryDetails>>();
        return internalCallback.await(this._updateUserAttributes(userAttributes, internalCallback));
    }

    private Runnable _updateUserAttributes(final Map<String, String> userAttributes, final Callback<List<UserCodeDeliveryDetails>> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (!AWSMobileClient.this.waitForSignIn()) {
                    callback.onError(new Exception("Operation requires a signed-in state"));
                    return;
                }
                CognitoUserAttributes cognitoUserAttributes = new CognitoUserAttributes();
                if (userAttributes != null) {
                    for (String key : userAttributes.keySet()) {
                        cognitoUserAttributes.addAttribute(key, (String)userAttributes.get(key));
                    }
                }
                try {
                    AWSMobileClient.this.userpool.getCurrentUser().updateAttributes(cognitoUserAttributes, new UpdateAttributesHandler(){

                        public void onSuccess(List<CognitoUserCodeDeliveryDetails> attributesVerificationList) {
                            LinkedList<UserCodeDeliveryDetails> list = new LinkedList<UserCodeDeliveryDetails>();
                            for (CognitoUserCodeDeliveryDetails details : attributesVerificationList) {
                                list.add(new UserCodeDeliveryDetails(details.getDestination(), details.getDeliveryMedium(), details.getAttributeName()));
                            }
                            callback.onResult(list);
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void verifyUserAttribute(String attributeName, Callback<UserCodeDeliveryDetails> callback) {
        InternalCallback<UserCodeDeliveryDetails> internalCallback = new InternalCallback<UserCodeDeliveryDetails>(callback);
        internalCallback.async(this._verifyUserAttribute(attributeName, internalCallback));
    }

    public UserCodeDeliveryDetails verifyUserAttribute(String attributeName) throws Exception {
        InternalCallback<UserCodeDeliveryDetails> internalCallback = new InternalCallback<UserCodeDeliveryDetails>();
        return internalCallback.await(this._verifyUserAttribute(attributeName, internalCallback));
    }

    private Runnable _verifyUserAttribute(final String attributeName, final Callback<UserCodeDeliveryDetails> callback) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!AWSMobileClient.this.waitForSignIn()) {
                        callback.onError(new Exception("Operation requires a signed-in state"));
                        return;
                    }
                    AWSMobileClient.this.userpool.getCurrentUser().getAttributeVerificationCodeInBackground(attributeName, new VerificationHandler(){

                        public void onSuccess(CognitoUserCodeDeliveryDetails verificationCodeDeliveryMedium) {
                            callback.onResult(new UserCodeDeliveryDetails(verificationCodeDeliveryMedium.getDestination(), verificationCodeDeliveryMedium.getDeliveryMedium(), verificationCodeDeliveryMedium.getAttributeName()));
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void confirmUpdateUserAttribute(String attributeName, String updateUserAttributeChallengeResponse, Callback<Void> callback) {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>(callback);
        internalCallback.async(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    public void confirmUpdateUserAttribute(String attributeName, String updateUserAttributeChallengeResponse) throws Exception {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>();
        internalCallback.await(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    public void confirmVerifyUserAttribute(String attributeName, String updateUserAttributeChallengeResponse, Callback<Void> callback) {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>(callback);
        internalCallback.async(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    public void confirmVerifyUserAttribute(String attributeName, String updateUserAttributeChallengeResponse) throws Exception {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>();
        internalCallback.await(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    private Runnable _confirmUserAttribute(final String attributeName, final String updateUserAttributeChallengeResponse, final Callback<Void> callback) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (!AWSMobileClient.this.waitForSignIn()) {
                        callback.onError(new Exception("Operation requires a signed-in state"));
                        return;
                    }
                    AWSMobileClient.this.userpool.getCurrentUser().verifyAttribute(attributeName, updateUserAttributeChallengeResponse, new GenericHandler(){

                        public void onSuccess() {
                            callback.onResult(null);
                        }

                        public void onFailure(Exception exception) {
                            callback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    public void showSignIn(Activity callingActivity, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._showSignIn(callingActivity, SignInUIOptions.builder().build(), internalCallback));
    }

    public UserStateDetails showSignIn(Activity callingActivity) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        return internalCallback.await(this._showSignIn(callingActivity, SignInUIOptions.builder().build(), internalCallback));
    }

    public void showSignIn(Activity callingActivity, SignInUIOptions signInUIOptions, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._showSignIn(callingActivity, signInUIOptions, internalCallback));
    }

    public UserStateDetails showSignIn(Activity callingActivity, SignInUIOptions signInUIOptions) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        return internalCallback.await(this._showSignIn(callingActivity, signInUIOptions, internalCallback));
    }

    private Runnable _showSignIn(final Activity callingActivity, final SignInUIOptions signInUIOptions, final Callback<UserStateDetails> callback) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AWSMobileClient.this.showSignInLockObject;
                synchronized (object) {
                    UserState userState = AWSMobileClient.this.getUserStateDetails(false).getUserState();
                    if (UserState.SIGNED_IN.equals((Object)userState)) {
                        callback.onError(new RuntimeException("Called showSignIn while user is already signed-in"));
                        return;
                    }
                    AuthUIConfiguration.Builder authUIConfigBuilder = new AuthUIConfiguration.Builder().canCancel(signInUIOptions.canCancel()).isBackgroundColorFullScreen(false);
                    if (signInUIOptions.getLogo() != null) {
                        authUIConfigBuilder.logoResId(signInUIOptions.getLogo().intValue());
                    }
                    if (signInUIOptions.getBackgroundColor() != null) {
                        authUIConfigBuilder.backgroundColor(signInUIOptions.getBackgroundColor().intValue());
                    }
                    IdentityManager identityManager = IdentityManager.getDefaultIdentityManager();
                    if (AWSMobileClient.this.isConfigurationKeyPresent(AWSMobileClient.USER_POOLS)) {
                        authUIConfigBuilder.userPools(true);
                        identityManager.addSignInProvider(CognitoUserPoolsSignInProvider.class);
                    }
                    if (AWSMobileClient.this.isConfigurationKeyPresent(AWSMobileClient.FACEBOOK)) {
                        authUIConfigBuilder.signInButton(FacebookButton.class);
                        identityManager.addSignInProvider(FacebookSignInProvider.class);
                    }
                    if (AWSMobileClient.this.isConfigurationKeyPresent(AWSMobileClient.GOOGLE)) {
                        authUIConfigBuilder.signInButton(GoogleButton.class);
                        identityManager.addSignInProvider(GoogleSignInProvider.class);
                    }
                    Class<Object> nextActivityClass = signInUIOptions.nextActivity() == null ? callingActivity.getClass() : signInUIOptions.nextActivity();
                    SignInUI signin = (SignInUI)AWSMobileClient.this.getClient(AWSMobileClient.this.mContext, SignInUI.class);
                    signin.login(callingActivity, nextActivityClass).authUIConfiguration(authUIConfigBuilder.build()).enableFederation(false).execute();
                    AWSMobileClient.this.showSignInWaitLatch = new CountDownLatch(1);
                    try {
                        AWSMobileClient.this.showSignInWaitLatch.await();
                        Log.d((String)TAG, (String)"run: showSignIn completed");
                    }
                    catch (InterruptedException e) {
                        callback.onError(e);
                    }
                }
            }
        };
    }

    @Deprecated
    public InitializeBuilder initialize(Context context) {
        this.awsStartupHandler = new AWSStartupHandler(){

            @Override
            public void onComplete(AWSStartupResult awsStartupResult) {
                Log.d((String)TAG, (String)"AWSMobileClient Initialize succeeded.");
                Log.i((String)TAG, (String)"Welcome to AWS! You are connected successfully.");
            }
        };
        return this.initialize(context, this.awsStartupHandler);
    }

    @Deprecated
    public InitializeBuilder initialize(Context context, final AWSStartupHandler awsStartupHandler) {
        this.awsConfiguration = new AWSConfiguration(context.getApplicationContext());
        this.signInProviderConfig = null;
        this.startupAuthResultHandler = new StartupAuthResultHandler(){

            public void onComplete(StartupAuthResult startupAuthResult) {
                Log.i((String)TAG, (String)"Welcome to AWS! You are connected successfully.");
                if (startupAuthResult.isIdentityIdAvailable()) {
                    Log.i((String)TAG, (String)"Identity ID retrieved.");
                }
                awsStartupHandler.onComplete(new AWSStartupResult(IdentityManager.getDefaultIdentityManager()));
            }
        };
        this.awsStartupHandler = awsStartupHandler;
        this.mIsLegacyMode = true;
        return new InitializeBuilder(context);
    }

    private void initializeWithBuilder(InitializeBuilder initializeBuilder) {
        if (initializeBuilder.getAwsConfiguration() != null) {
            this.awsConfiguration = initializeBuilder.getAwsConfiguration();
        }
        if (initializeBuilder.getSignInProviderConfig() != null) {
            this.signInProviderConfig = initializeBuilder.getSignInProviderConfig();
        }
        try {
            this.fetchCognitoIdentity(initializeBuilder.getContext(), this.startupAuthResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error in initializing the AWSMobileClient. Check if AWS Cloud Config `awsconfiguration.json` is present in the application.");
        }
    }

    public AWSConfigurable getClient(Context context, Class<? extends AWSConfigurable> clientClass) {
        Log.d((String)TAG, (String)("Retrieving the client instance for class: " + clientClass));
        AWSConfigurable client = this.clientMap.get(clientClass);
        try {
            if (client == null) {
                client = clientClass.newInstance().initialize(context.getApplicationContext(), this.awsConfiguration);
                this.clientMap.put(clientClass, client);
                Log.d((String)TAG, (String)("Created the new client: " + client.toString()));
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error occurred in creating and initializing client. Check the context and the clientClass passed in: " + clientClass), (Throwable)exception);
        }
        return client;
    }

    @Deprecated
    public AWSCredentialsProvider getCredentialsProvider() {
        if (!this.isLegacyMode()) {
            return this;
        }
        if (this.awsCredentialsProvider != null) {
            return this.awsCredentialsProvider;
        }
        return IdentityManager.getDefaultIdentityManager().getUnderlyingProvider();
    }

    @Deprecated
    public void setCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    private void fetchCognitoIdentity(Context context, StartupAuthResultHandler startupAuthResultHandler) {
        try {
            Log.d((String)TAG, (String)"Fetching the Cognito Identity.");
            IdentityManager identityManager = new IdentityManager(context, this.awsConfiguration);
            IdentityManager.setDefaultIdentityManager((IdentityManager)identityManager);
            if (this.signInProviderConfig == null) {
                this.registerConfigSignInProviders();
            } else {
                this.registerUserSignInProvidersWithPermissions();
            }
            this.resumeSession((Activity)context, startupAuthResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred in fetching the Cognito Identity and resuming the auth session", (Throwable)exception);
        }
    }

    private void registerUserSignInProvidersWithPermissions() {
        Log.d((String)TAG, (String)"Using the SignInProviderConfig supplied by the user.");
        IdentityManager identityManager = IdentityManager.getDefaultIdentityManager();
        for (SignInProviderConfig config : this.signInProviderConfig) {
            identityManager.addSignInProvider(config.getSignInProviderClass());
            if (config.getProviderPermissions() == null) continue;
            if (FacebookSignInProvider.class.isInstance(config.getSignInProviderClass())) {
                FacebookSignInProvider.setPermissions((String[])config.getProviderPermissions());
            }
            if (!GoogleSignInProvider.class.isInstance(config.getSignInProviderClass())) continue;
            GoogleSignInProvider.setPermissions((String[])config.getProviderPermissions());
        }
    }

    private void registerConfigSignInProviders() {
        Log.d((String)TAG, (String)"Using the SignInProviderConfig from `awsconfiguration.json`.");
        IdentityManager identityManager = IdentityManager.getDefaultIdentityManager();
        if (this.isConfigurationKeyPresent(USER_POOLS)) {
            identityManager.addSignInProvider(CognitoUserPoolsSignInProvider.class);
        }
        if (this.isConfigurationKeyPresent(FACEBOOK)) {
            identityManager.addSignInProvider(FacebookSignInProvider.class);
        }
        if (this.isConfigurationKeyPresent(GOOGLE)) {
            identityManager.addSignInProvider(GoogleSignInProvider.class);
        }
    }

    private boolean isConfigurationKeyPresent(String configurationKey) {
        try {
            JSONObject jsonObject = this.awsConfiguration.optJsonObject(configurationKey);
            if (configurationKey.equals(GOOGLE)) {
                return jsonObject != null && jsonObject.getString(GOOGLE_WEBAPP_CONFIG_KEY) != null;
            }
            return jsonObject != null;
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)(configurationKey + " not found in `awsconfiguration.json`"));
            return false;
        }
    }

    private void resumeSession(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler) {
        IdentityManager.getDefaultIdentityManager().resumeSession(callingActivity, startupAuthResultHandler);
    }

    @Deprecated
    public class SignInProviderConfig {
        @Deprecated
        private Class<? extends SignInProvider> signInProvider;
        @Deprecated
        private String[] providerPermissions;

        @Deprecated
        public SignInProviderConfig(Class<? extends SignInProvider> signInProvider, String ... providerPermissions) {
            this.signInProvider = signInProvider;
            this.providerPermissions = providerPermissions;
        }

        @Deprecated
        public Class<? extends SignInProvider> getSignInProviderClass() {
            return this.signInProvider;
        }

        @Deprecated
        public String[] getProviderPermissions() {
            return this.providerPermissions;
        }
    }

    @Deprecated
    public class InitializeBuilder {
        private Context context;
        private AWSConfiguration awsConfiguration;
        private SignInProviderConfig[] signInProviderConfig;

        @Deprecated
        public InitializeBuilder() {
            this.context = null;
            this.awsConfiguration = null;
            this.signInProviderConfig = null;
        }

        @Deprecated
        public InitializeBuilder(Context context) {
            this.context = context;
            this.awsConfiguration = null;
            this.signInProviderConfig = null;
        }

        @Deprecated
        public InitializeBuilder awsConfiguration(AWSConfiguration awsConfiguration) {
            this.awsConfiguration = awsConfiguration;
            return this;
        }

        @Deprecated
        public InitializeBuilder signInProviders(SignInProviderConfig ... providersConfig) {
            this.signInProviderConfig = providersConfig;
            return this;
        }

        @Deprecated
        public AWSConfiguration getAwsConfiguration() {
            return this.awsConfiguration;
        }

        @Deprecated
        public SignInProviderConfig[] getSignInProviderConfig() {
            return this.signInProviderConfig;
        }

        @Deprecated
        public Context getContext() {
            return this.context;
        }

        @Deprecated
        public void execute() {
            AWSMobileClient.this.initializeWithBuilder(this);
        }
    }
}

