/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client.internal;

import android.util.Log;
import com.amazonaws.mobile.client.Callback;
import java.util.concurrent.CountDownLatch;

public class InternalCallback<R>
implements Callback<R> {
    private static final String TAG = InternalCallback.class.getSimpleName();
    private Callback<R> userCallback;
    private Mode mode;
    private CountDownLatch lock;
    private Runnable runnable;
    private R result;
    private Exception e;

    public InternalCallback() {
        this(null);
    }

    public InternalCallback(Callback<R> userCallback) {
        this.userCallback = userCallback;
        this.mode = Mode.Callback;
        this.lock = new CountDownLatch(1);
    }

    @Override
    public void onResult(R result) {
        this.call(result, null);
    }

    @Override
    public void onError(Exception e) {
        this.call(null, e);
    }

    private void call(R result, Exception e) {
        switch (this.mode) {
            case Callback: 
            case Async: {
                if (result != null) {
                    this.userCallback.onResult(result);
                    break;
                }
                this.userCallback.onError(e);
                break;
            }
            case Sync: {
                this.result = result;
                this.e = e;
                this.lock.countDown();
                break;
            }
            case Done: {
                Log.w((String)TAG, (String)"Library attempted to call user callback twice, expected only once");
            }
        }
        this.mode = Mode.Done;
        this.userCallback = null;
    }

    public void async(Runnable runnable) {
        if (this.mode == Mode.Done) {
            Log.e((String)TAG, (String)"Duplicate call to execute code.", (Throwable)new RuntimeException("Internal error, duplicate call"));
        }
        this.mode = Mode.Async;
        this.lock = null;
        new Thread(runnable).start();
    }

    public R await(Runnable runnable) throws Exception {
        if (this.mode == Mode.Done) {
            Log.e((String)TAG, (String)"Duplicate call to execute code.", (Throwable)new RuntimeException("Internal error, duplicate call"));
        }
        this.mode = Mode.Sync;
        try {
            runnable.run();
            this.lock.await();
        }
        catch (Exception e) {
            this.e = e;
        }
        Exception localE = this.e;
        R localResult = this.result;
        this.e = null;
        this.result = null;
        if (localE != null) {
            throw localE;
        }
        return localResult;
    }

    private static enum Mode {
        Callback,
        Async,
        Sync,
        Done;

    }
}

