/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client.internal.oauth2;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.amazonaws.mobile.client.AWSMobileClient;
import com.amazonaws.mobile.client.Callback;
import com.amazonaws.mobile.client.internal.oauth2.AuthorizeResponse;
import com.amazonaws.mobile.client.internal.oauth2.HTTPUtil;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2ClientStore;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Constants;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Exception;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Tokens;
import com.amazonaws.mobileconnectors.cognitoauth.util.Pkce;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class OAuth2Client {
    public static final String TAG = OAuth2Client.class.getSimpleName();
    public static final String CUSTOM_TABS_PACKAGE_NAME = "com.android.chrome";
    public static final String SHARED_PREFERENCES_KEY = "com.amazonaws.mobile.client.oauth2";
    private static final long REFRESH_THRESHOLD = 60000L;
    public static final String TOKEN_URI_KEY = "tokenUri";
    public static final String CREATE_DATE = "createDate";
    public static final String SIGN_OUT_REDIRECT_URI_KEY = "signOutRedirectUri";
    public static final String SIGN_IN_REDIRECT_URI_KEY = "signInRedirectUri";
    final AWSMobileClient mMobileClient;
    final CustomTabsServiceConnection mCustomTabsServiceConnection;
    final Context mContext;
    private final OAuth2ClientStore mStore;
    boolean mIsPersistenceEnabled = true;
    CustomTabsClient mCustomTabsClient;
    CustomTabsSession mCustomTabsSession;
    CustomTabsCallback mCustomTabsCallback;
    PKCEMode mPKCEMode;
    Callback<AuthorizeResponse> mAuthorizeCallback;
    String mState;
    private String mClientId;
    private String mError;
    private String mErrorDescription;
    private String mErrorUriString;
    private Callback<Void> mSignOutCallback;
    private boolean mAuthorizeOrSignOutRedirectReceived;

    public OAuth2Client(Context context, AWSMobileClient mobileClient) {
        this.mMobileClient = mobileClient;
        this.mContext = context;
        this.mPKCEMode = PKCEMode.S256;
        this.mStore = new OAuth2ClientStore(this);
        this.mCustomTabsCallback = new CustomTabsCallback(){

            public void onNavigationEvent(int navigationEvent, Bundle extras) {
                super.onNavigationEvent(navigationEvent, extras);
                if (navigationEvent == 6 && !OAuth2Client.this.mAuthorizeOrSignOutRedirectReceived) {
                    if (OAuth2Client.this.mSignOutCallback != null) {
                        OAuth2Client.this.mSignOutCallback.onError(new Exception("User cancelled flow or flow interrupted."));
                        OAuth2Client.this.mSignOutCallback = null;
                    } else if (OAuth2Client.this.mAuthorizeCallback != null) {
                        OAuth2Client.this.mAuthorizeCallback.onError(new Exception("User cancelled flow or flow interrupted."));
                        OAuth2Client.this.mAuthorizeCallback = null;
                    }
                }
            }
        };
        this.mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                OAuth2Client.this.mCustomTabsClient = client;
                OAuth2Client.this.mCustomTabsClient.warmup(0L);
                OAuth2Client.this.mCustomTabsSession = OAuth2Client.this.mCustomTabsClient.newSession(OAuth2Client.this.mCustomTabsCallback);
            }

            public void onServiceDisconnected(ComponentName name) {
                OAuth2Client.this.mCustomTabsClient = null;
            }
        };
        if (!CustomTabsClient.bindCustomTabsService((Context)this.mContext, (String)CUSTOM_TABS_PACKAGE_NAME, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection)) {
            Log.d((String)TAG, (String)"OAuth2Client: Failed to pre-warm custom tab, first page load may be slower");
        }
    }

    public void setPersistenceEnabled(boolean isPersistenceEnabled) {
        this.mIsPersistenceEnabled = isPersistenceEnabled;
        this.mStore.setPersistenceEnabled(isPersistenceEnabled);
    }

    public void signOut(Uri signOutUri, Callback<Void> callback) {
        this.mSignOutCallback = callback;
        String redirectUri = signOutUri.getQueryParameter("redirect_uri");
        if (redirectUri == null) {
            throw new IllegalArgumentException("The sign-out URI must contain a redirect_uri");
        }
        this.mStore.set(SIGN_OUT_REDIRECT_URI_KEY, redirectUri);
        Uri.parse((String)redirectUri);
        this.open(signOutUri);
    }

    public void signOut() {
        this.mStore.clear();
        this.mSignOutCallback = null;
        this.mAuthorizeCallback = null;
        this.mPKCEMode = PKCEMode.S256;
        this.mState = null;
        this.mClientId = null;
        this.mError = null;
        this.mErrorDescription = null;
        this.mErrorUriString = null;
    }

    public void setPKCEMode(PKCEMode pkceMode) {
        this.mPKCEMode = pkceMode;
    }

    public void authorize(Uri authorizeUri, Callback<AuthorizeResponse> callback) {
        this.mAuthorizeCallback = callback;
        try {
            Uri.Builder authorizeUriBuilder = authorizeUri.buildUpon();
            switch (this.mPKCEMode) {
                case S256: {
                    String proofKey = Pkce.generateRandom();
                    String proofKeyHash = Pkce.generateHash((String)proofKey);
                    this.mStore.set("proofKey", proofKey);
                    this.mStore.set("proofKeyHash", proofKeyHash);
                    authorizeUriBuilder.appendQueryParameter("code_challenge_method", this.mPKCEMode.toString()).appendQueryParameter("code_challenge", proofKeyHash).build();
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported PKCE mode was chosen, please choose another");
                }
            }
            Uri validating = authorizeUriBuilder.build();
            this.mClientId = validating.getQueryParameter("client_id");
            if (this.mClientId == null) {
                throw new IllegalArgumentException("The authorize URI must contain a client_id");
            }
            String redirectUri = validating.getQueryParameter("redirect_uri");
            if (redirectUri == null) {
                throw new IllegalArgumentException("The authorize URI must contain a redirect_uri");
            }
            this.mStore.set(SIGN_IN_REDIRECT_URI_KEY, redirectUri);
            Uri.parse((String)redirectUri);
            if (validating.getQueryParameter("response_type") == null) {
                authorizeUriBuilder.appendQueryParameter("response_type", "code").build();
            }
            this.mState = validating.getQueryParameter("state");
            if (this.mState == null) {
                this.mState = Pkce.generateRandom();
                authorizeUriBuilder.appendQueryParameter("state", this.mState).build();
            }
            this.mStore.set("state", this.mState);
            this.open(authorizeUriBuilder.build());
        }
        catch (Exception e) {
            callback.onError(e);
        }
    }

    public void open(Uri uri) {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(this.mCustomTabsSession).build();
        customTabsIntent.intent.setPackage(CUSTOM_TABS_PACKAGE_NAME);
        customTabsIntent.intent.addFlags(0x40000000);
        customTabsIntent.intent.addFlags(0x10000000);
        this.mAuthorizeOrSignOutRedirectReceived = false;
        customTabsIntent.launchUrl(this.mContext, uri);
    }

    public boolean handleRedirect(Uri uri) {
        if (uri == null) {
            return false;
        }
        String signInRedirectUriString = this.mStore.get(SIGN_IN_REDIRECT_URI_KEY);
        String signOutRedirectUriString = this.mStore.get(SIGN_OUT_REDIRECT_URI_KEY);
        if (signInRedirectUriString != null) {
            Uri signInRedirectUri = Uri.parse((String)signInRedirectUriString);
            if (uri.getScheme().equals(signInRedirectUri.getScheme()) && uri.getAuthority().equals(signInRedirectUri.getAuthority()) && uri.getPath().equals(signInRedirectUri.getPath()) && uri.getQueryParameterNames().containsAll(signInRedirectUri.getQueryParameterNames())) {
                String code = uri.getQueryParameter("code");
                String state = uri.getQueryParameter("state");
                if (!this.mStore.get("state").equals(state)) {
                    return false;
                }
                this.mError = uri.getQueryParameter("error");
                this.mErrorDescription = uri.getQueryParameter("error_description");
                this.mErrorUriString = uri.getQueryParameter("error_uri");
                this.mAuthorizeOrSignOutRedirectReceived = true;
                if (this.mError != null) {
                    if (this.mAuthorizeCallback != null) {
                        this.mAuthorizeCallback.onError(new OAuth2Exception("Authorization call failed with response from authorization server", this.mError, this.mErrorDescription, this.mErrorUriString));
                        this.mAuthorizeCallback = null;
                    }
                    return true;
                }
                if (code != null) {
                    if (this.mAuthorizeCallback != null) {
                        AuthorizeResponse result = new AuthorizeResponse();
                        result.code = code;
                        result.responseUri = uri;
                        this.mAuthorizeCallback.onResult(result);
                        this.mAuthorizeCallback = null;
                    }
                    return true;
                }
                return false;
            }
        }
        if (signOutRedirectUriString != null) {
            Uri signOutRedirectUri = Uri.parse((String)signOutRedirectUriString);
            if (uri.getScheme().equals(signOutRedirectUri.getScheme()) && uri.getAuthority().equals(signOutRedirectUri.getAuthority()) && uri.getPath().equals(signOutRedirectUri.getPath()) && uri.getQueryParameterNames().containsAll(signOutRedirectUri.getQueryParameterNames())) {
                this.mAuthorizeOrSignOutRedirectReceived = true;
                if (this.mSignOutCallback != null) {
                    this.mSignOutCallback.onResult(null);
                    this.mSignOutCallback = null;
                }
                return true;
            }
        }
        return false;
    }

    public void requestTokens(Uri tokenUri, Map<String, String> headers, Map<String, String> body, String code, Callback<OAuth2Tokens> callback) {
        String proofKey = this.mStore.get("proofKey");
        if (proofKey == null && !this.mPKCEMode.equals(PKCEMode.NONE)) {
            callback.onError(new Exception("Proof key could not be found from current session."));
        }
        try {
            if (body.get("client_id") == null) {
                throw new IllegalArgumentException("The token exchange must contain a client_id");
            }
            if (body.get("redirect_uri") == null) {
                throw new IllegalArgumentException("The token exchange must contain a redirect_uri");
            }
            if (body.get("code") == null) {
                if (code == null) {
                    throw new IllegalArgumentException("The token exchange must contain a code");
                }
                body.put("code", code);
            }
            if (body.get("code_verifier") == null) {
                if (proofKey == null) {
                    throw new IllegalStateException("The token exchange must contain a code verifier");
                }
                body.put("code_verifier", proofKey);
            }
            if (body.get("grant_type") == null) {
                body.put("grant_type", OAuth2Constants.GrantTypes.AUTHORIZATION_CODE.toString());
            }
            this.mStore.set(TOKEN_URI_KEY, tokenUri.toString());
            String response = HTTPUtil.httpPost(new URL(tokenUri.toString()), headers, body);
            OAuth2Tokens tokens = HTTPUtil.parseHttpResponse(response);
            this.mStore.set(tokens);
            callback.onResult(tokens);
        }
        catch (Exception e) {
            callback.onError(new Exception("Failed to exchange code for tokens", e));
        }
    }

    public void refresh(Uri tokenUri, Map<String, String> headers, Map<String, String> body, Callback<OAuth2Tokens> callback) {
        String refreshToken = this.mStore.get(OAuth2Constants.TokenResponseFields.REFRESH_TOKEN.toString());
        if (refreshToken == null) {
            callback.onError(new IllegalStateException("Refresh called without refresh token available"));
        }
        try {
            if (body.get("grant_type") == null) {
                body.put("grant_type", OAuth2Constants.GrantTypes.REFRESH_TOKEN.toString());
            }
            if (body.get("refresh_token") == null) {
                if (refreshToken == null) {
                    throw new IllegalArgumentException("The refresh flow must contain a refresh_token");
                }
                body.put("refresh_token", refreshToken);
            }
            String response = HTTPUtil.httpPost(new URL(tokenUri.toString()), headers, body);
            OAuth2Tokens tokens = HTTPUtil.parseHttpResponse(response);
            this.mStore.set(tokens);
            callback.onResult(tokens);
        }
        catch (Exception e) {
            callback.onError(new Exception("Failed to refresh tokens with service", e));
        }
    }

    public void getTokens(Callback<OAuth2Tokens> callback) {
        try {
            long timeToExpiry;
            OAuth2Tokens tokens = this.mStore.getTokens();
            if (tokens.expiresIn != null && (timeToExpiry = tokens.createDate + tokens.expiresIn - System.currentTimeMillis()) < 60000L) {
                String tokenUriString;
                if (tokens.refreshToken != null && (tokenUriString = this.mStore.get(TOKEN_URI_KEY)) != null) {
                    this.refresh(Uri.parse((String)tokenUriString), new HashMap<String, String>(), new HashMap<String, String>(), callback);
                } else {
                    callback.onError(new Exception("No cached tokens available, refresh not available."));
                }
            }
            callback.onResult(tokens);
        }
        catch (Exception e) {
            callback.onError(e);
        }
    }

    public static enum PKCEMode {
        NONE(""),
        S256("S256");

        private String encode;

        private PKCEMode(String encode) {
            this.encode = encode;
        }

        public String toString() {
            return this.encode;
        }

        public boolean equals(PKCEMode other) {
            return other.encode.equals(this.encode);
        }
    }
}

