/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.support.annotation.AnyThread;
import android.support.annotation.WorkerThread;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.CognitoCachingCredentialsProvider;
import com.amazonaws.mobile.auth.core.IdentityManager;
import com.amazonaws.mobile.auth.core.SignInStateChangeListener;
import com.amazonaws.mobile.auth.core.StartupAuthResult;
import com.amazonaws.mobile.auth.core.StartupAuthResultHandler;
import com.amazonaws.mobile.auth.core.signin.SignInManager;
import com.amazonaws.mobile.auth.core.signin.SignInProvider;
import com.amazonaws.mobile.auth.facebook.FacebookButton;
import com.amazonaws.mobile.auth.facebook.FacebookSignInProvider;
import com.amazonaws.mobile.auth.google.GoogleButton;
import com.amazonaws.mobile.auth.google.GoogleSignInProvider;
import com.amazonaws.mobile.auth.ui.AuthUIConfiguration;
import com.amazonaws.mobile.auth.ui.SignInUI;
import com.amazonaws.mobile.auth.userpools.CognitoUserPoolsSignInProvider;
import com.amazonaws.mobile.client.AWSMobileClientCognitoIdentityProvider;
import com.amazonaws.mobile.client.AWSMobileClientStore;
import com.amazonaws.mobile.client.AWSStartupHandler;
import com.amazonaws.mobile.client.AWSStartupResult;
import com.amazonaws.mobile.client.Callback;
import com.amazonaws.mobile.client.DeviceOperations;
import com.amazonaws.mobile.client.FederatedSignInOptions;
import com.amazonaws.mobile.client.HostedUIOptions;
import com.amazonaws.mobile.client.IdentityProvider;
import com.amazonaws.mobile.client.SignInUIOptions;
import com.amazonaws.mobile.client.SignOutOptions;
import com.amazonaws.mobile.client.UserState;
import com.amazonaws.mobile.client.UserStateDetails;
import com.amazonaws.mobile.client.UserStateListener;
import com.amazonaws.mobile.client.internal.InternalCallback;
import com.amazonaws.mobile.client.internal.ReturningRunnable;
import com.amazonaws.mobile.client.internal.oauth2.AuthorizeResponse;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Client;
import com.amazonaws.mobile.client.internal.oauth2.OAuth2Tokens;
import com.amazonaws.mobile.client.results.ForgotPasswordResult;
import com.amazonaws.mobile.client.results.ForgotPasswordState;
import com.amazonaws.mobile.client.results.SignInResult;
import com.amazonaws.mobile.client.results.SignInState;
import com.amazonaws.mobile.client.results.SignUpResult;
import com.amazonaws.mobile.client.results.Tokens;
import com.amazonaws.mobile.client.results.UserCodeDeliveryDetails;
import com.amazonaws.mobile.config.AWSConfigurable;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognitoauth.Auth;
import com.amazonaws.mobileconnectors.cognitoauth.AuthUserSession;
import com.amazonaws.mobileconnectors.cognitoauth.handlers.AuthHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoDevice;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUser;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserAttributes;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserCodeDeliveryDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserPool;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.CognitoUserSession;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.AuthenticationDetails;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ChallengeContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.ForgotPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.MultiFactorAuthenticationContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.continuations.NewPasswordContinuation;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.AuthenticationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.ForgotPasswordHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GenericHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.GetDetailsHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.SignUpHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.UpdateAttributesHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.handlers.VerificationHandler;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoPinpointSharedContext;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentity;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.NotAuthorizedException;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProvider;
import com.amazonaws.services.cognitoidentityprovider.AmazonCognitoIdentityProviderClient;
import com.amazonaws.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import com.amazonaws.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AWSMobileClient
implements AWSCredentialsProvider {
    private static final String TAG = AWSMobileClient.class.getSimpleName();
    public static final String USER_AGENT = "AWSMobileClient";
    static final String SHARED_PREFERENCES_KEY = "com.amazonaws.mobile.client";
    static final String PROVIDER_KEY = "provider";
    static final String TOKEN_KEY = "token";
    static final String IDENTITY_ID_KEY = "cognitoIdentityId";
    static final String SIGN_IN_MODE = "signInMode";
    public static final String HOSTED_UI_KEY = "hostedUI";
    static final String FEDERATION_ENABLED_KEY = "isFederationEnabled";
    private static final String CUSTOM_ROLE_ARN_KEY = "customRoleArn";
    private static final String USER_POOLS = "CognitoUserPool";
    private static final String FACEBOOK = "FacebookSignIn";
    private static final String GOOGLE = "GoogleSignIn";
    private static final String GOOGLE_WEBAPP_CONFIG_KEY = "ClientId-WebApp";
    private static volatile AWSMobileClient singleton = null;
    private final LinkedHashMap<Class<? extends AWSConfigurable>, AWSConfigurable> clientMap;
    AWSConfiguration awsConfiguration;
    CognitoCachingCredentialsProvider cognitoIdentity;
    CognitoUserPool userpool;
    String userpoolsLoginKey;
    Context mContext;
    Map<String, String> mFederatedLoginsMap;
    private UserStateDetails userStateDetails;
    private Lock mWaitForSignInLock;
    private volatile CountDownLatch mSignedOutWaitLatch;
    CognitoUserSession mCognitoUserSession;
    private Callback<SignInResult> signInCallback;
    private MultiFactorAuthenticationContinuation signInMfaContinuation;
    private ChallengeContinuation signInChallengeContinuation;
    private SignInState signInState;
    private Callback<ForgotPasswordResult> forgotPasswordCallback;
    private ForgotPasswordContinuation forgotPasswordContinuation;
    private CognitoUser signUpUser;
    private AWSCredentialsProvider awsCredentialsProvider;
    private SignInProviderConfig[] signInProviderConfig;
    private StartupAuthResultHandler startupAuthResultHandler;
    private AWSStartupHandler awsStartupHandler;
    private boolean mIsLegacyMode;
    List<UserStateListener> listeners;
    private Object showSignInLockObject;
    private volatile CountDownLatch showSignInWaitLatch;
    private Object federateWithCognitoIdentityLockObject;
    private Object initLockObject;
    AWSMobileClientStore mStore;
    AWSMobileClientCognitoIdentityProvider provider;
    DeviceOperations mDeviceOperations;
    AmazonCognitoIdentityProvider userpoolLL;
    Auth hostedUI;
    OAuth2Client mOAuth2Client;
    String mUserPoolPoolId;
    boolean mIsPersistenceEnabled = true;

    private AWSMobileClient() {
        if (singleton != null) {
            throw new AssertionError();
        }
        this.clientMap = new LinkedHashMap();
        this.userpoolsLoginKey = "";
        this.mWaitForSignInLock = new ReentrantLock();
        this.mFederatedLoginsMap = new HashMap<String, String>();
        this.listeners = new ArrayList<UserStateListener>();
        this.showSignInLockObject = new Object();
        this.federateWithCognitoIdentityLockObject = new Object();
        this.showSignInWaitLatch = new CountDownLatch(1);
        this.initLockObject = new Object();
    }

    public static synchronized AWSMobileClient getInstance() {
        if (singleton == null) {
            singleton = new AWSMobileClient();
        }
        return singleton;
    }

    public AWSConfiguration getConfiguration() {
        return this.awsConfiguration;
    }

    public AWSCredentials getCredentials() {
        if (this.isLegacyMode()) {
            return IdentityManager.getDefaultIdentityManager().getCredentialsProvider().getCredentials();
        }
        if (this.cognitoIdentity == null) {
            throw new AmazonClientException("Cognito Identity not configured");
        }
        try {
            if (this.waitForSignIn()) {
                Log.d((String)TAG, (String)"getCredentials: Validated user is signed-in");
            }
            AWSSessionCredentials credentials = this.cognitoIdentity.getCredentials();
            this.mStore.set(IDENTITY_ID_KEY, this.cognitoIdentity.getIdentityId());
            return credentials;
        }
        catch (NotAuthorizedException e) {
            Log.w((String)TAG, (String)"getCredentials: Failed to getCredentials from Cognito Identity", (Throwable)e);
            throw new AmazonClientException("Failed to get credentials from Cognito Identity", (Throwable)e);
        }
        catch (Exception e) {
            throw new AmazonClientException("Failed to get credentials from Cognito Identity", (Throwable)e);
        }
    }

    public void refresh() {
        if (this.isLegacyMode()) {
            IdentityManager.getDefaultIdentityManager().getCredentialsProvider().refresh();
            return;
        }
        if (this.cognitoIdentity == null) {
            throw new AmazonClientException("Cognito Identity not configured");
        }
        this.cognitoIdentity.refresh();
        this.mStore.set(IDENTITY_ID_KEY, this.cognitoIdentity.getIdentityId());
    }

    @WorkerThread
    public AWSCredentials getAWSCredentials() throws Exception {
        return this._getAWSCredentials().await();
    }

    @AnyThread
    public void getAWSCredentials(Callback<AWSCredentials> callback) {
        this._getAWSCredentials().async(callback);
    }

    private ReturningRunnable<AWSCredentials> _getAWSCredentials() {
        return new ReturningRunnable<AWSCredentials>(){

            @Override
            public AWSCredentials run() {
                return AWSMobileClient.this.getCredentials();
            }
        };
    }

    @AnyThread
    public String getIdentityId() {
        if (this.isLegacyMode()) {
            return IdentityManager.getDefaultIdentityManager().getCachedUserID();
        }
        if (this.cognitoIdentity == null) {
            throw new RuntimeException("Cognito Identity not configured");
        }
        String cachedIdentityId = this.cognitoIdentity.getCachedIdentityId();
        if (cachedIdentityId == null) {
            return this.mStore.get(IDENTITY_ID_KEY);
        }
        return cachedIdentityId;
    }

    boolean isLegacyMode() {
        return this.mIsLegacyMode;
    }

    @AnyThread
    public void initialize(Context context, Callback<UserStateDetails> callback) {
        Context applicationContext = context.getApplicationContext();
        this.initialize(applicationContext, new AWSConfiguration(applicationContext), callback);
    }

    @AnyThread
    public void initialize(Context context, AWSConfiguration awsConfig, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._initialize(context, awsConfig, internalCallback));
    }

    CountDownLatch getSignInUILatch() {
        return this.showSignInWaitLatch;
    }

    protected Runnable _initialize(final Context context, final AWSConfiguration awsConfiguration, final Callback<UserStateDetails> callback) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AWSMobileClient.this.initLockObject;
                synchronized (object) {
                    JSONObject hostedUIJSON;
                    JSONObject userPoolJSON;
                    if (AWSMobileClient.this.awsConfiguration != null) {
                        callback.onResult(AWSMobileClient.this.getUserStateDetails(true));
                        return;
                    }
                    AWSMobileClient.this.mIsPersistenceEnabled = true;
                    try {
                        if (awsConfiguration.optJsonObject("Auth") != null && awsConfiguration.optJsonObject("Auth").has("Persistence")) {
                            AWSMobileClient.this.mIsPersistenceEnabled = awsConfiguration.optJsonObject("Auth").getBoolean("Persistence");
                        }
                    }
                    catch (Exception ex) {
                        callback.onError(new RuntimeException("Failed to initialize AWSMobileClient; please check your awsconfiguration.json", ex));
                        return;
                    }
                    AWSMobileClient.this.mContext = context.getApplicationContext();
                    AWSMobileClient.this.mStore = new AWSMobileClientStore(AWSMobileClient.this);
                    final IdentityManager identityManager = new IdentityManager(AWSMobileClient.this.mContext);
                    identityManager.enableFederation(false);
                    identityManager.setConfiguration(awsConfiguration);
                    identityManager.setPersistenceEnabled(AWSMobileClient.this.mIsPersistenceEnabled);
                    IdentityManager.setDefaultIdentityManager((IdentityManager)identityManager);
                    identityManager.addSignInStateChangeListener(new SignInStateChangeListener(){

                        public void onUserSignedIn() {
                            Log.d((String)TAG, (String)"onUserSignedIn: Updating user state from drop-in UI");
                            AWSMobileClient.this.signInState = SignInState.DONE;
                            com.amazonaws.mobile.auth.core.IdentityProvider currentIdentityProvider = identityManager.getCurrentIdentityProvider();
                            String token = currentIdentityProvider.getToken();
                            String providerKey = currentIdentityProvider.getCognitoLoginKey();
                            AWSMobileClient.this.federatedSignInWithoutAssigningState(providerKey, token, new Callback<UserStateDetails>(){

                                @Override
                                public void onResult(UserStateDetails result) {
                                    Log.d((String)TAG, (String)"onResult: showSignIn federated");
                                    AWSMobileClient.this.setUserState(AWSMobileClient.this.getUserStateDetails(false));
                                    AWSMobileClient.this.getSignInUILatch().countDown();
                                }

                                @Override
                                public void onError(Exception e) {
                                    Log.w((String)TAG, (String)"onError: User sign-in had errors from drop-in UI", (Throwable)e);
                                    AWSMobileClient.this.setUserState(AWSMobileClient.this.getUserStateDetails(false));
                                    AWSMobileClient.this.getSignInUILatch().countDown();
                                }
                            });
                        }

                        public void onUserSignedOut() {
                            Log.d((String)TAG, (String)"onUserSignedOut: Updating user state from drop-in UI");
                            AWSMobileClient.this.setUserState(AWSMobileClient.this.getUserStateDetails(false));
                            AWSMobileClient.this.showSignInWaitLatch.countDown();
                        }
                    });
                    if (awsConfiguration.optJsonObject("CredentialsProvider") != null && awsConfiguration.optJsonObject("CredentialsProvider").optJSONObject("CognitoIdentity") != null) {
                        try {
                            JSONObject identityPoolJSON = awsConfiguration.optJsonObject("CredentialsProvider").getJSONObject("CognitoIdentity").getJSONObject(awsConfiguration.getConfiguration());
                            String poolId = identityPoolJSON.getString("PoolId");
                            String regionStr = identityPoolJSON.getString("Region");
                            ClientConfiguration clientConfig = new ClientConfiguration();
                            clientConfig.setUserAgent("AWSMobileClient " + awsConfiguration.getUserAgent());
                            AmazonCognitoIdentityClient cibClient = new AmazonCognitoIdentityClient((AWSCredentials)new AnonymousAWSCredentials());
                            cibClient.setRegion(Region.getRegion((String)regionStr));
                            AWSMobileClient.this.provider = new AWSMobileClientCognitoIdentityProvider(null, poolId, (AmazonCognitoIdentity)cibClient);
                            AWSMobileClient.this.cognitoIdentity = new CognitoCachingCredentialsProvider(AWSMobileClient.this.mContext, (AWSCognitoIdentityProvider)AWSMobileClient.this.provider, Regions.fromName((String)regionStr));
                            AWSMobileClient.this.cognitoIdentity.setPersistenceEnabled(AWSMobileClient.this.mIsPersistenceEnabled);
                        }
                        catch (Exception e) {
                            callback.onError(new RuntimeException("Failed to initialize Cognito Identity; please check your awsconfiguration.json", e));
                            return;
                        }
                    }
                    if ((userPoolJSON = awsConfiguration.optJsonObject(AWSMobileClient.USER_POOLS)) != null) {
                        try {
                            AWSMobileClient.this.mUserPoolPoolId = userPoolJSON.getString("PoolId");
                            String clientId = userPoolJSON.getString("AppClientId");
                            String clientSecret = userPoolJSON.optString("AppClientSecret");
                            String pinpointEndpointId = CognitoPinpointSharedContext.getPinpointEndpoint((Context)context, (String)userPoolJSON.optString("PinpointAppId"));
                            ClientConfiguration clientConfig = new ClientConfiguration();
                            clientConfig.setUserAgent("AWSMobileClient " + awsConfiguration.getUserAgent());
                            AWSMobileClient.this.userpoolLL = new AmazonCognitoIdentityProviderClient((AWSCredentials)new AnonymousAWSCredentials(), clientConfig);
                            AWSMobileClient.this.userpoolLL.setRegion(Region.getRegion((Regions)Regions.fromName((String)userPoolJSON.getString("Region"))));
                            AWSMobileClient.this.userpoolsLoginKey = String.format("cognito-idp.%s.amazonaws.com/%s", userPoolJSON.getString("Region"), userPoolJSON.getString("PoolId"));
                            AWSMobileClient.this.userpool = new CognitoUserPool(AWSMobileClient.this.mContext, AWSMobileClient.this.mUserPoolPoolId, clientId, clientSecret, AWSMobileClient.this.userpoolLL, pinpointEndpointId);
                            AWSMobileClient.this.userpool.setPersistenceEnabled(AWSMobileClient.this.mIsPersistenceEnabled);
                            AWSMobileClient.this.mDeviceOperations = new DeviceOperations(AWSMobileClient.this, AWSMobileClient.this.userpoolLL);
                        }
                        catch (Exception e) {
                            callback.onError(new RuntimeException("Failed to initialize Cognito Userpool; please check your awsconfiguration.json", e));
                            return;
                        }
                    }
                    if ((hostedUIJSON = AWSMobileClient.this.getHostedUIJSON(awsConfiguration)) != null) {
                        try {
                            if (hostedUIJSON.has("TokenURI")) {
                                Log.d((String)TAG, (String)"initialize: OAuth2 client detected");
                                AWSMobileClient.this.mOAuth2Client = new OAuth2Client(AWSMobileClient.this.mContext, AWSMobileClient.this);
                                AWSMobileClient.this.mOAuth2Client.setPersistenceEnabled(AWSMobileClient.this.mIsPersistenceEnabled);
                            } else {
                                AWSMobileClient.this._initializeHostedUI(hostedUIJSON);
                            }
                        }
                        catch (Exception e) {
                            callback.onError(new RuntimeException("Failed to initialize OAuth, please check your awsconfiguration.json", e));
                        }
                    }
                    if (AWSMobileClient.this.cognitoIdentity == null && AWSMobileClient.this.userpool == null) {
                        callback.onError(new RuntimeException("Neither Cognito Identity or Cognito UserPool was used. At least one must be present to use AWSMobileClient."));
                        return;
                    }
                    AWSMobileClient.this.awsConfiguration = awsConfiguration;
                    UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(true);
                    callback.onResult(userStateDetails);
                    AWSMobileClient.this.setUserState(userStateDetails);
                }
            }
        };
    }

    private void _initializeHostedUI(JSONObject hostedUIJSON) throws JSONException {
        Log.d((String)TAG, (String)"initialize: Cognito HostedUI client detected");
        JSONArray scopesJSONArray = hostedUIJSON.getJSONArray("Scopes");
        HashSet<String> scopes = new HashSet<String>();
        for (int i = 0; i < scopesJSONArray.length(); ++i) {
            scopes.add(scopesJSONArray.getString(i));
        }
        if (this.mUserPoolPoolId == null) {
            throw new IllegalStateException("User pool Id must be available through user pool setting");
        }
        this.hostedUI = this.getHostedUI(hostedUIJSON).setPersistenceEnabled(this.mIsPersistenceEnabled).setAuthHandler(new AuthHandler(){

            public void onSuccess(AuthUserSession session) {
            }

            public void onSignout() {
            }

            public void onFailure(Exception e) {
            }
        }).build();
    }

    JSONObject getHostedUIJSONFromJSON() {
        return this.getHostedUIJSONFromJSON(this.awsConfiguration);
    }

    JSONObject getHostedUIJSONFromJSON(AWSConfiguration awsConfig) {
        JSONObject mobileClientJSON = awsConfig.optJsonObject("Auth");
        if (mobileClientJSON != null && mobileClientJSON.has("OAuth")) {
            try {
                JSONObject hostedUIJSONFromJSON = mobileClientJSON.getJSONObject("OAuth");
                return hostedUIJSONFromJSON;
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"getHostedUIJSONFromJSON: Failed to read config", (Throwable)e);
            }
        }
        return null;
    }

    JSONObject getHostedUIJSON() {
        return this.getHostedUIJSON(this.awsConfiguration);
    }

    JSONObject getHostedUIJSON(AWSConfiguration awsConfig) {
        try {
            JSONObject hostedUIJSONFromJSON = this.getHostedUIJSONFromJSON(awsConfig);
            if (hostedUIJSONFromJSON == null) {
                return null;
            }
            String hostedUIString = this.mStore.get(HOSTED_UI_KEY);
            JSONObject hostedUIJSON = null;
            try {
                hostedUIJSON = new JSONObject(hostedUIString);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Failed to parse HostedUI settings from store. Defaulting to awsconfiguration.json", (Throwable)e);
            }
            if (hostedUIJSON == null && hostedUIJSONFromJSON != null) {
                hostedUIJSON = new JSONObject(hostedUIJSONFromJSON.toString());
                this.mStore.set(HOSTED_UI_KEY, hostedUIJSON.toString());
            }
            return hostedUIJSON;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"getHostedUIJSON: Failed to read config", (Throwable)e);
            return null;
        }
    }

    Auth.Builder getHostedUI(JSONObject hostedUIJSON) throws JSONException {
        JSONArray scopesJSONArray = hostedUIJSON.getJSONArray("Scopes");
        HashSet<String> scopes = new HashSet<String>();
        for (int i = 0; i < scopesJSONArray.length(); ++i) {
            scopes.add(scopesJSONArray.getString(i));
        }
        return new Auth.Builder().setApplicationContext(this.mContext).setUserPoolId(this.mUserPoolPoolId).setAppClientId(hostedUIJSON.getString("AppClientId")).setAppClientSecret(hostedUIJSON.optString("AppClientSecret", null)).setAppCognitoWebDomain(hostedUIJSON.getString("WebDomain")).setSignInRedirect(hostedUIJSON.getString("SignInRedirectURI")).setSignOutRedirect(hostedUIJSON.getString("SignOutRedirectURI")).setScopes(scopes).setAdvancedSecurityDataCollection(false).setIdentityProvider(hostedUIJSON.optString("IdentityProvider")).setIdpIdentifier(hostedUIJSON.optString("IdpIdentifier"));
    }

    @AnyThread
    public DeviceOperations getDeviceOperations() {
        if (this.mDeviceOperations == null) {
            throw new AmazonClientException("Please check if userpools is configured.");
        }
        return this.mDeviceOperations;
    }

    @AnyThread
    public void releaseSignInWait() {
        if (this.mSignedOutWaitLatch != null) {
            this.mSignedOutWaitLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserState(final UserStateDetails details) {
        boolean hasChanged = !details.equals(this.userStateDetails);
        this.userStateDetails = details;
        if (hasChanged) {
            List<UserStateListener> list = this.listeners;
            synchronized (list) {
                for (final UserStateListener listener : this.listeners) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onUserStateChanged(details);
                        }
                    }).start();
                }
            }
        }
    }

    protected boolean isNetworkAvailable(Context context) {
        try {
            Class.forName("android.support.v4.content.ContextCompat");
            int hasReadExternalStoragePermission = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE");
            if (hasReadExternalStoragePermission != 0) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            Log.w((String)TAG, (String)"Could not check if ACCESS_NETWORK_STATE permission is available.", (Throwable)e);
        }
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = manager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected()) {
                return true;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Could not access network state", (Throwable)e);
        }
        return false;
    }

    boolean isUserpoolsSignedIn() {
        return this.userpoolsLoginKey.equals(this.mStore.get(PROVIDER_KEY));
    }

    @AnyThread
    public String getUsername() {
        try {
            if (this.userpoolsLoginKey.equals(this.mStore.get(PROVIDER_KEY))) {
                return this.userpool.getCurrentUser().getUserId();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @WorkerThread
    public UserStateDetails currentUserState() {
        try {
            return this._currentUserState().await();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve user state.", e);
        }
    }

    @AnyThread
    public void currentUserState(Callback<UserStateDetails> callback) {
        this._currentUserState().async(callback);
    }

    ReturningRunnable<UserStateDetails> _currentUserState() {
        return new ReturningRunnable<UserStateDetails>(){

            @Override
            public UserStateDetails run() throws Exception {
                return AWSMobileClient.this.getUserStateDetails(false);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void addUserStateListener(UserStateListener listener) {
        List<UserStateListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public boolean removeUserStateListener(UserStateListener listener) {
        List<UserStateListener> list = this.listeners;
        synchronized (list) {
            int index = this.listeners.indexOf(listener);
            if (index != -1) {
                this.listeners.remove(index);
                return true;
            }
            return false;
        }
    }

    String getLoginKey() {
        return this.userpoolsLoginKey;
    }

    @AnyThread
    public boolean isSignedIn() {
        UserStateDetails userStateDetails = this.getUserStateDetails(true);
        switch (userStateDetails.getUserState()) {
            case SIGNED_IN: 
            case SIGNED_OUT_USER_POOLS_TOKENS_INVALID: 
            case SIGNED_OUT_FEDERATED_TOKENS_INVALID: {
                return true;
            }
            case GUEST: 
            case SIGNED_OUT: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown user state, please report this exception");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean waitForSignIn() {
        UserStateDetails userStateDetails = null;
        try {
            this.mWaitForSignInLock.lock();
            this.mSignedOutWaitLatch = new CountDownLatch(1);
            userStateDetails = this.getUserStateDetails(false);
            Log.d((String)TAG, (String)("waitForSignIn: userState:" + (Object)((Object)userStateDetails.getUserState())));
            switch (userStateDetails.getUserState()) {
                case SIGNED_IN: {
                    this.setUserState(userStateDetails);
                    boolean bl = true;
                    return bl;
                }
                case GUEST: 
                case SIGNED_OUT: {
                    this.setUserState(userStateDetails);
                    boolean bl = false;
                    return bl;
                }
                case SIGNED_OUT_USER_POOLS_TOKENS_INVALID: 
                case SIGNED_OUT_FEDERATED_TOKENS_INVALID: {
                    if (userStateDetails.getException() != null) {
                        if (!this.isSignedOutRelatedException(userStateDetails.getException())) throw userStateDetails.getException();
                    }
                    this.setUserState(userStateDetails);
                    this.mSignedOutWaitLatch.await();
                    boolean bl = this.getUserStateDetails(false).getUserState().equals((Object)UserState.SIGNED_IN);
                    return bl;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new AmazonClientException("Operation requires a signed-in state", (Throwable)e);
        }
        finally {
            this.mWaitForSignInLock.unlock();
        }
    }

    Map<String, String> getSignInDetailsMap() {
        return this.mStore.get(PROVIDER_KEY, TOKEN_KEY);
    }

    String _getCachedIdentityId() {
        return this.mStore.get(IDENTITY_ID_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UserStateDetails getUserStateDetails(boolean offlineCheck) {
        boolean hasUsefulToken;
        Map<String, String> details = this.getSignInDetailsMap();
        String providerKey = details.get(PROVIDER_KEY);
        String token = details.get(TOKEN_KEY);
        String identityId = this._getCachedIdentityId();
        boolean federationEnabled = this.isFederationEnabled();
        Log.d((String)TAG, (String)"Inspecting user state details");
        boolean bl = hasUsefulToken = providerKey != null && token != null;
        if (offlineCheck || !this.isNetworkAvailable(this.mContext)) {
            if (hasUsefulToken) {
                return new UserStateDetails(UserState.SIGNED_IN, details);
            }
            if (identityId == null) return new UserStateDetails(UserState.SIGNED_OUT, null);
            return new UserStateDetails(UserState.GUEST, details);
        }
        if (hasUsefulToken && !this.userpoolsLoginKey.equals(providerKey)) {
            try {
                if (!federationEnabled) {
                    return new UserStateDetails(UserState.SIGNED_IN, details);
                }
                String refreshedToken = token;
                SignInProvider previouslySignedInProvider = SignInManager.getInstance((Context)this.mContext).getPreviouslySignedInProvider();
                if (previouslySignedInProvider != null && providerKey.equals(previouslySignedInProvider.getCognitoLoginKey())) {
                    refreshedToken = previouslySignedInProvider.getToken();
                    Log.i((String)TAG, (String)"Token was refreshed using drop-in UI internal mechanism");
                }
                if (refreshedToken == null) {
                    Log.i((String)TAG, (String)"Token used for federation has become null");
                    return new UserStateDetails(UserState.SIGNED_OUT_FEDERATED_TOKENS_INVALID, details);
                }
                if (this.hasFederatedToken(providerKey, refreshedToken)) {
                    Log.d((String)TAG, (String)"getUserStateDetails: token already federated just fetch credentials");
                    if (this.cognitoIdentity == null) return new UserStateDetails(UserState.SIGNED_IN, details);
                    this.cognitoIdentity.getCredentials();
                    return new UserStateDetails(UserState.SIGNED_IN, details);
                }
                this.federateWithCognitoIdentity(providerKey, refreshedToken);
                return new UserStateDetails(UserState.SIGNED_IN, details);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Failed to federate the tokens.", (Throwable)e);
                UserState userState = UserState.SIGNED_IN;
                if (this.isSignedOutRelatedException(e)) {
                    userState = UserState.SIGNED_OUT_FEDERATED_TOKENS_INVALID;
                }
                UserStateDetails userStateDetails = new UserStateDetails(userState, details);
                userStateDetails.setException(e);
                return userStateDetails;
            }
        }
        if (hasUsefulToken && this.userpool != null) {
            Tokens tokens = null;
            String idToken = null;
            Exception userPoolsException = null;
            try {
                block24: {
                    tokens = this.getTokens(false);
                    idToken = tokens.getIdToken().getTokenString();
                    details.put(TOKEN_KEY, idToken);
                    if (!federationEnabled) {
                    }
                    if (this.hasFederatedToken(providerKey, idToken)) {
                        try {
                            if (this.cognitoIdentity != null) {
                                this.cognitoIdentity.getCredentials();
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            Log.w((String)TAG, (String)"Failed to get or refresh credentials from Cognito Identity", (Throwable)e);
                        }
                    }
                    if (this.cognitoIdentity != null) {
                        this.federateWithCognitoIdentity(providerKey, idToken);
                    }
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)(tokens == null ? "Tokens are invalid, please sign-in again." : "Failed to federate the tokens"), (Throwable)e);
                userPoolsException = e;
                return userPoolsException;
            }
            finally {
                UserState userState = UserState.SIGNED_IN;
                if (this.isSignedOutRelatedException(userPoolsException)) {
                    userState = UserState.SIGNED_OUT_USER_POOLS_TOKENS_INVALID;
                }
                UserStateDetails userStateDetails = new UserStateDetails(userState, details);
                userStateDetails.setException(userPoolsException);
                return userStateDetails;
            }
        }
        if (this.cognitoIdentity == null) {
            return new UserStateDetails(UserState.SIGNED_OUT, details);
        }
        if (identityId == null) return new UserStateDetails(UserState.SIGNED_OUT, null);
        return new UserStateDetails(UserState.GUEST, details);
    }

    boolean isSignedOutRelatedException(Exception e) {
        if (e == null) {
            return false;
        }
        if (e instanceof NotAuthorizedException) {
            return true;
        }
        return "No cached session.".equals(e.getMessage()) && e.getCause() == null;
    }

    boolean isFederationEnabled() {
        String federationEnabledString = this.mStore.get(FEDERATION_ENABLED_KEY);
        boolean federationEnabled = federationEnabledString != null ? federationEnabledString.equals("true") : true;
        return federationEnabled;
    }

    SignInMode getSignInMode() {
        return SignInMode.fromString(this.mStore.get(SIGN_IN_MODE));
    }

    private boolean hasFederatedToken(String providerKey, String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        boolean hasFederatedToken = token.equals(this.mFederatedLoginsMap.get(providerKey));
        Log.d((String)TAG, (String)("hasFederatedToken: " + hasFederatedToken + " provider: " + providerKey));
        return hasFederatedToken;
    }

    @AnyThread
    public void signIn(String username, String password, Map<String, String> validationData, Callback<SignInResult> callback) {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>(callback);
        internalCallback.async(this._signIn(username, password, validationData, internalCallback));
    }

    @WorkerThread
    public SignInResult signIn(String username, String password, Map<String, String> validationData) throws Exception {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>();
        return internalCallback.await(this._signIn(username, password, validationData, internalCallback));
    }

    private Runnable _signIn(final String username, final String password, final Map<String, String> validationData, final Callback<SignInResult> callback) {
        this.signInCallback = callback;
        this.signInState = null;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    AWSMobileClient.this.userpool.getUser(username).getSession(new AuthenticationHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
                            try {
                                AWSMobileClient.this.mCognitoUserSession = userSession;
                                AWSMobileClient.this.signInState = SignInState.DONE;
                            }
                            catch (Exception e) {
                                AWSMobileClient.this.signInCallback.onError(e);
                                AWSMobileClient.this.signInCallback = null;
                            }
                            try {
                                if (AWSMobileClient.this.isFederationEnabled()) {
                                    AWSMobileClient.this.federatedSignInWithoutAssigningState(AWSMobileClient.this.userpoolsLoginKey, AWSMobileClient.this.mCognitoUserSession.getIdToken().getJWTToken());
                                }
                                AWSMobileClient.this.releaseSignInWait();
                            }
                            catch (Exception e) {
                                Log.w((String)TAG, (String)"Failed to federate tokens during sign-in", (Throwable)e);
                            }
                            finally {
                                AWSMobileClient.this.setUserState(new UserStateDetails(UserState.SIGNED_IN, AWSMobileClient.this.getSignInDetailsMap()));
                            }
                            AWSMobileClient.this.signInCallback.onResult(SignInResult.DONE);
                        }

                        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String userId) {
                            Log.d((String)TAG, (String)"Sending password.");
                            authenticationContinuation.setAuthenticationDetails(new AuthenticationDetails(username, password, validationData));
                            authenticationContinuation.continueTask();
                        }

                        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
                            AWSMobileClient.this.signInMfaContinuation = continuation;
                            CognitoUserCodeDeliveryDetails parameters = continuation.getParameters();
                            AWSMobileClient.this.signInState = SignInState.SMS_MFA;
                            AWSMobileClient.this.signInCallback.onResult(new SignInResult(SignInState.SMS_MFA, new UserCodeDeliveryDetails(parameters.getDestination(), parameters.getDeliveryMedium(), parameters.getAttributeName())));
                        }

                        public void authenticationChallenge(ChallengeContinuation continuation) {
                            try {
                                AWSMobileClient.this.signInState = SignInState.valueOf(continuation.getChallengeName());
                                AWSMobileClient.this.signInChallengeContinuation = continuation;
                                AWSMobileClient.this.signInCallback.onResult(new SignInResult(AWSMobileClient.this.signInState, continuation.getParameters()));
                            }
                            catch (IllegalArgumentException e) {
                                AWSMobileClient.this.signInCallback.onError(e);
                            }
                        }

                        public void onFailure(Exception exception) {
                            AWSMobileClient.this.signInCallback.onError(exception);
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    @AnyThread
    public void signOut() {
        this.mCognitoUserSession = null;
        if (this.userpool != null) {
            this.userpool.getCurrentUser().signOut();
            this.userpool.getUser().signOut();
        }
        if (this.cognitoIdentity != null) {
            this.cognitoIdentity.clear();
        }
        if (IdentityManager.getDefaultIdentityManager() != null) {
            IdentityManager.getDefaultIdentityManager().signOut();
        }
        this.mFederatedLoginsMap.clear();
        this.mStore.clear();
        String hostedUIJSON = null;
        if (this.awsConfiguration.optJsonObject("Auth") != null && this.awsConfiguration.optJsonObject("Auth").has("OAuth")) {
            try {
                hostedUIJSON = this.awsConfiguration.optJsonObject("Auth").getJSONObject("OAuth").toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (this.hostedUI != null) {
                this.hostedUI.signOut(true);
            }
            if (this.mOAuth2Client != null) {
                this.mOAuth2Client.signOut();
            }
        }
        this.mStore.set(HOSTED_UI_KEY, hostedUIJSON);
        this.setUserState(this.getUserStateDetails(false));
        this.releaseSignInWait();
    }

    @WorkerThread
    public void signOut(SignOutOptions signOutOptions) throws Exception {
        this._signOut(signOutOptions).await();
    }

    @AnyThread
    public void signOut(SignOutOptions signOutOptions, Callback<Void> callback) {
        this._signOut(signOutOptions).async(callback);
    }

    private ReturningRunnable<Void> _signOut(final SignOutOptions signOutOptions) {
        return new ReturningRunnable<Void>(){

            @Override
            public Void run() throws Exception {
                if (signOutOptions.isSignOutGlobally()) {
                    GlobalSignOutRequest globalSignOutRequest = new GlobalSignOutRequest();
                    globalSignOutRequest.setAccessToken(AWSMobileClient.this.getTokens().getAccessToken().getTokenString());
                    AWSMobileClient.this.userpoolLL.globalSignOut(globalSignOutRequest);
                }
                if (signOutOptions.isInvalidateTokens()) {
                    if (AWSMobileClient.this.hostedUI != null) {
                        AWSMobileClient.this.hostedUI.signOut();
                    } else if (AWSMobileClient.this.mOAuth2Client != null) {
                        JSONObject signOutQueryParametersJSON;
                        final CountDownLatch latch = new CountDownLatch(1);
                        JSONObject hostedUIJSON = AWSMobileClient.this.getHostedUIJSON();
                        String signOutUriString = hostedUIJSON.getString("SignOutURI");
                        Uri.Builder uriBuilder = Uri.parse((String)signOutUriString).buildUpon();
                        if (AWSMobileClient.this.getHostedUIJSON().optString("SignOutRedirectURI", null) != null) {
                            uriBuilder.appendQueryParameter("redirect_uri", AWSMobileClient.this.getHostedUIJSON().getString("SignOutRedirectURI"));
                        }
                        if ((signOutQueryParametersJSON = hostedUIJSON.getJSONObject("SignOutQueryParameters")) != null) {
                            Iterator keysIterator = signOutQueryParametersJSON.keys();
                            while (keysIterator.hasNext()) {
                                String key = (String)keysIterator.next();
                                uriBuilder.appendQueryParameter(key, signOutQueryParametersJSON.getString(key));
                            }
                        }
                        final Exception[] signOutError = new Exception[1];
                        AWSMobileClient.this.mOAuth2Client.signOut(uriBuilder.build(), new Callback<Void>(){

                            @Override
                            public void onResult(Void result) {
                                latch.countDown();
                            }

                            @Override
                            public void onError(Exception e) {
                                signOutError[0] = e;
                                latch.countDown();
                            }
                        });
                        latch.await();
                        if (signOutError[0] != null) {
                            throw signOutError[0];
                        }
                    }
                }
                AWSMobileClient.this.signOut();
                return null;
            }
        };
    }

    @AnyThread
    public void federatedSignIn(String providerKey, String token, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._federatedSignIn(providerKey, token, null, internalCallback, true));
    }

    @WorkerThread
    public UserStateDetails federatedSignIn(String providerKey, String token) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        return internalCallback.await(this._federatedSignIn(providerKey, token, null, internalCallback, true));
    }

    @AnyThread
    public void federatedSignIn(String providerKey, String token, FederatedSignInOptions options, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._federatedSignIn(providerKey, token, options, internalCallback, true));
    }

    @WorkerThread
    public UserStateDetails federatedSignIn(String providerKey, String token, FederatedSignInOptions options) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        return internalCallback.await(this._federatedSignIn(providerKey, token, options, internalCallback, true));
    }

    protected void federatedSignInWithoutAssigningState(String providerKey, String token) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        internalCallback.await(this._federatedSignIn(providerKey, token, null, internalCallback, false));
    }

    protected void federatedSignInWithoutAssigningState(String providerKey, String token, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._federatedSignIn(providerKey, token, null, internalCallback, false));
    }

    private Runnable _federatedSignIn(final String providerKey, final String token, FederatedSignInOptions options, final Callback<UserStateDetails> callback, final boolean assignState) {
        final HashMap<String, String> loginsMap = new HashMap<String, String>();
        try {
            loginsMap.put(providerKey, token);
            Log.d((String)TAG, (String)String.format("_federatedSignIn: Putting provider and token in store", new Object[0]));
            HashMap<String, String> details = new HashMap<String, String>();
            details.put(PROVIDER_KEY, providerKey);
            details.put(TOKEN_KEY, token);
            details.put(FEDERATION_ENABLED_KEY, "true");
            if (IdentityProvider.DEVELOPER.equals(providerKey)) {
                if (options == null) {
                    callback.onError(new Exception("Developer authenticated identities require theidentity id to be specified in FederatedSignInOptions"));
                }
                details.put(IDENTITY_ID_KEY, options.getCognitoIdentityId());
            }
            if (options != null && !StringUtils.isBlank((CharSequence)options.getCustomRoleARN())) {
                details.put(CUSTOM_ROLE_ARN_KEY, options.getCustomRoleARN());
            }
            this.mStore.set(details);
        }
        catch (Exception e) {
            callback.onError(e);
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    if (AWSMobileClient.this.cognitoIdentity == null) {
                        callback.onError(new Exception("Federation is not enabled, please check if you have CognitoIdentity configured."));
                        return;
                    }
                    if (!token.equals(AWSMobileClient.this.mFederatedLoginsMap.get(providerKey))) {
                        AWSMobileClient.this.cognitoIdentity.clear();
                        AWSMobileClient.this.cognitoIdentity.setLogins(loginsMap);
                    }
                    UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(true);
                    AWSMobileClient.this.federateWithCognitoIdentity(providerKey, token);
                    callback.onResult(userStateDetails);
                    this.end(userStateDetails);
                }
                catch (Exception exception) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put(AWSMobileClient.PROVIDER_KEY, null);
                    details.put(AWSMobileClient.TOKEN_KEY, null);
                    details.put(AWSMobileClient.FEDERATION_ENABLED_KEY, null);
                    details.put(AWSMobileClient.IDENTITY_ID_KEY, null);
                    details.put(AWSMobileClient.CUSTOM_ROLE_ARN_KEY, null);
                    AWSMobileClient.this.mStore.set(details);
                    callback.onError(new RuntimeException("Error in federating the token.", exception));
                    return;
                }
            }

            private void end(UserStateDetails details) {
                if (assignState) {
                    AWSMobileClient.this.setUserState(details);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void federateWithCognitoIdentity(String providerKey, String token) {
        Object object = this.federateWithCognitoIdentityLockObject;
        synchronized (object) {
            if (!this.hasFederatedToken(providerKey, token)) {
                if (IdentityProvider.DEVELOPER.equals(providerKey)) {
                    this.provider.setDeveloperAuthenticated(this.mStore.get(IDENTITY_ID_KEY), token);
                } else {
                    this.provider.setNotDeveloperAuthenticated();
                }
                String customRoleArn = this.mStore.get(CUSTOM_ROLE_ARN_KEY);
                if (!StringUtils.isBlank((CharSequence)customRoleArn)) {
                    this.cognitoIdentity.setCustomRoleArn(customRoleArn);
                }
                HashMap<String, String> logins = new HashMap<String, String>();
                logins.put(providerKey, token);
                this.cognitoIdentity.setLogins(logins);
                this.cognitoIdentity.refresh();
                this.mStore.set(IDENTITY_ID_KEY, this.cognitoIdentity.getIdentityId());
                this.mFederatedLoginsMap = this.cognitoIdentity.getLogins();
            }
        }
    }

    @WorkerThread
    public Tokens getTokens() throws Exception {
        InternalCallback<Tokens> internalCallback = new InternalCallback<Tokens>();
        return internalCallback.await(this._getTokens(internalCallback, true));
    }

    @AnyThread
    public void getTokens(Callback<Tokens> callback) {
        InternalCallback<Tokens> internalCallback = new InternalCallback<Tokens>(callback);
        internalCallback.async(this._getTokens(internalCallback, true));
    }

    protected Tokens getTokens(boolean waitForSignIn) throws Exception {
        InternalCallback<Tokens> internalCallback = new InternalCallback<Tokens>();
        return internalCallback.await(this._getTokens(internalCallback, waitForSignIn));
    }

    private Runnable _getTokens(final Callback<Tokens> callback, final boolean waitForSignIn) {
        return new Runnable(){

            @Override
            public void run() {
                String providerKey = AWSMobileClient.this.getSignInDetailsMap().get(AWSMobileClient.PROVIDER_KEY);
                if (providerKey != null && !AWSMobileClient.this.userpoolsLoginKey.equals(providerKey)) {
                    callback.onError(new Exception("getTokens does not support retrieving tokens for federated sign-in"));
                    return;
                }
                if (waitForSignIn && !AWSMobileClient.this.waitForSignIn()) {
                    callback.onError(new Exception("getTokens does not support retrieving tokens while signed-out"));
                    return;
                }
                if (!AWSMobileClient.this.isUserpoolsSignedIn()) {
                    callback.onError(new Exception("You must be signed-in with Cognito Userpools to be able to use getTokens"));
                }
                if (AWSMobileClient.this.getSignInMode().equals((Object)SignInMode.HOSTED_UI)) {
                    AWSMobileClient.this._getHostedUITokens(callback);
                    return;
                }
                if (AWSMobileClient.this.getSignInMode().equals((Object)SignInMode.OAUTH2)) {
                    callback.onError(new Exception("Tokens are not supported for OAuth2"));
                    return;
                }
                try {
                    AWSMobileClient.this.userpool.getCurrentUser().getSession(new AuthenticationHandler(){

                        public void onSuccess(CognitoUserSession userSession, CognitoDevice newDevice) {
                            try {
                                AWSMobileClient.this.mCognitoUserSession = userSession;
                                callback.onResult(new Tokens(userSession.getAccessToken().getJWTToken(), userSession.getIdToken().getJWTToken(), userSession.getRefreshToken().getToken()));
                            }
                            catch (Exception e) {
                                callback.onError(e);
                            }
                        }

                        public void getAuthenticationDetails(AuthenticationContinuation authenticationContinuation, String userId) {
                            this.signalTokensNotAvailable(null);
                        }

                        public void getMFACode(MultiFactorAuthenticationContinuation continuation) {
                            this.signalTokensNotAvailable(null);
                        }

                        public void authenticationChallenge(ChallengeContinuation continuation) {
                            this.signalTokensNotAvailable(null);
                        }

                        public void onFailure(Exception exception) {
                            this.signalTokensNotAvailable(exception);
                        }

                        private void signalTokensNotAvailable(Exception e) {
                            Log.w((String)TAG, (String)"signalTokensNotAvailable");
                            callback.onError(new Exception("No cached session.", e));
                        }
                    });
                }
                catch (Exception e) {
                    callback.onError(e);
                }
            }
        };
    }

    private void _getHostedUITokens(final Callback<Tokens> callback) {
        this.hostedUI = this.hostedUI.getCurrentUser();
        this.hostedUI.setAuthHandler(new AuthHandler(){

            public void onSuccess(AuthUserSession session) {
                callback.onResult(new Tokens(session.getAccessToken().getJWTToken(), session.getIdToken().getJWTToken(), session.getRefreshToken().getToken()));
            }

            public void onSignout() {
                callback.onError(new Exception("No cached session."));
            }

            public void onFailure(Exception e) {
                callback.onError(new Exception("No cached session.", e));
            }
        });
        this.hostedUI.getSession(false);
    }

    @AnyThread
    public void signUp(String username, String password, Map<String, String> userAttributes, Map<String, String> validationData, Callback<SignUpResult> callback) {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>(callback);
        internalCallback.async(this._signUp(username, password, userAttributes, validationData, internalCallback));
    }

    @WorkerThread
    public SignUpResult signUp(String username, String password, Map<String, String> userAttributes, Map<String, String> validationData) throws Exception {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>();
        return internalCallback.await(this._signUp(username, password, userAttributes, validationData, internalCallback));
    }

    private Runnable _signUp(final String username, final String password, final Map<String, String> userAttributes, final Map<String, String> validationData, final Callback<SignUpResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                CognitoUserAttributes cognitoUserAttr = new CognitoUserAttributes();
                for (String key : userAttributes.keySet()) {
                    cognitoUserAttr.addAttribute(key, (String)userAttributes.get(key));
                }
                AWSMobileClient.this.userpool.signUp(username, password, cognitoUserAttr, validationData, new SignUpHandler(){

                    public void onSuccess(CognitoUser user, boolean signUpConfirmationState, CognitoUserCodeDeliveryDetails cognitoUserCodeDeliveryDetails) {
                        AWSMobileClient.this.signUpUser = user;
                        UserCodeDeliveryDetails userCodeDeliveryDetails = new UserCodeDeliveryDetails(cognitoUserCodeDeliveryDetails.getDestination(), cognitoUserCodeDeliveryDetails.getDeliveryMedium(), cognitoUserCodeDeliveryDetails.getAttributeName());
                        callback.onResult(new SignUpResult(signUpConfirmationState, userCodeDeliveryDetails));
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void confirmSignUp(String username, String signUpChallengeResponse, Callback<SignUpResult> callback) {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>(callback);
        internalCallback.async(this._confirmSignUp(username, signUpChallengeResponse, internalCallback));
    }

    @WorkerThread
    public SignUpResult confirmSignUp(String username, String signUpChallengeResponse) throws Exception {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>();
        return internalCallback.await(this._confirmSignUp(username, signUpChallengeResponse, internalCallback));
    }

    private Runnable _confirmSignUp(final String username, final String signUpChallengeResponse, final Callback<SignUpResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                AWSMobileClient.this.userpool.getUser(username).confirmSignUp(signUpChallengeResponse, true, new GenericHandler(){

                    public void onSuccess() {
                        callback.onResult(new SignUpResult(true, null));
                        AWSMobileClient.this.signUpUser = null;
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void resendSignUp(String username, Callback<SignUpResult> callback) {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>(callback);
        internalCallback.async(this._resendSignUp(username, internalCallback));
    }

    @WorkerThread
    public SignUpResult resendSignUp(String username) throws Exception {
        InternalCallback<SignUpResult> internalCallback = new InternalCallback<SignUpResult>();
        return internalCallback.await(this._resendSignUp(username, internalCallback));
    }

    private Runnable _resendSignUp(final String username, final Callback<SignUpResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                AWSMobileClient.this.userpool.getUser(username).resendConfirmationCodeInBackground(new VerificationHandler(){

                    public void onSuccess(CognitoUserCodeDeliveryDetails verificationCodeDeliveryMedium) {
                        UserCodeDeliveryDetails userCodeDeliveryDetails = new UserCodeDeliveryDetails(verificationCodeDeliveryMedium.getDestination(), verificationCodeDeliveryMedium.getDeliveryMedium(), verificationCodeDeliveryMedium.getAttributeName());
                        callback.onResult(new SignUpResult(false, userCodeDeliveryDetails));
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void forgotPassword(String username, Callback<ForgotPasswordResult> callback) {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>(callback);
        internalCallback.async(this._forgotPassword(username, internalCallback));
    }

    @WorkerThread
    public ForgotPasswordResult forgotPassword(String username) throws Exception {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>();
        return internalCallback.await(this._forgotPassword(username, internalCallback));
    }

    private Runnable _forgotPassword(final String username, final Callback<ForgotPasswordResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                AWSMobileClient.this.forgotPasswordCallback = new InternalCallback(callback);
                AWSMobileClient.this.userpool.getUser(username).forgotPasswordInBackground(new ForgotPasswordHandler(){

                    public void onSuccess() {
                        AWSMobileClient.this.forgotPasswordCallback.onResult(new ForgotPasswordResult(ForgotPasswordState.DONE));
                    }

                    public void getResetCode(ForgotPasswordContinuation continuation) {
                        AWSMobileClient.this.forgotPasswordContinuation = continuation;
                        ForgotPasswordResult result = new ForgotPasswordResult(ForgotPasswordState.CONFIRMATION_CODE);
                        CognitoUserCodeDeliveryDetails parameters = continuation.getParameters();
                        result.setParameters(new UserCodeDeliveryDetails(parameters.getDestination(), parameters.getDeliveryMedium(), parameters.getAttributeName()));
                        AWSMobileClient.this.forgotPasswordCallback.onResult(result);
                    }

                    public void onFailure(Exception exception) {
                        AWSMobileClient.this.forgotPasswordCallback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void confirmForgotPassword(String password, String forgotPasswordChallengeResponse, Callback<ForgotPasswordResult> callback) {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>(callback);
        internalCallback.async(this._confirmForgotPassword(password, forgotPasswordChallengeResponse, internalCallback));
    }

    @WorkerThread
    public ForgotPasswordResult confirmForgotPassword(String password, String forgotPasswordChallengeResponse) throws Exception {
        InternalCallback<ForgotPasswordResult> internalCallback = new InternalCallback<ForgotPasswordResult>();
        return internalCallback.await(this._confirmForgotPassword(password, forgotPasswordChallengeResponse, internalCallback));
    }

    private Runnable _confirmForgotPassword(final String password, final String forgotPasswordChallengeResponse, final Callback<ForgotPasswordResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (AWSMobileClient.this.forgotPasswordContinuation == null) {
                    callback.onError(new IllegalStateException("confirmForgotPassword called before initiating forgotPassword"));
                    return;
                }
                AWSMobileClient.this.forgotPasswordContinuation.setPassword(password);
                AWSMobileClient.this.forgotPasswordContinuation.setVerificationCode(forgotPasswordChallengeResponse);
                AWSMobileClient.this.forgotPasswordCallback = new InternalCallback(callback);
                AWSMobileClient.this.forgotPasswordContinuation.continueTask();
            }
        };
    }

    @AnyThread
    public void changePassword(String oldPassword, String newPassword, Callback<Void> callback) {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>(callback);
        internalCallback.async(this._changePassword(oldPassword, newPassword, internalCallback));
    }

    @WorkerThread
    public void changePassword(String oldPassword, String newPassword) throws Exception {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>();
        internalCallback.await(this._changePassword(oldPassword, newPassword, internalCallback));
    }

    private Runnable _changePassword(final String oldPassword, final String newPassword, final Callback<Void> callback) {
        return new Runnable(){

            @Override
            public void run() {
                AWSMobileClient.this.userpool.getCurrentUser().changePassword(oldPassword, newPassword, new GenericHandler(){

                    public void onSuccess() {
                        callback.onResult(null);
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void confirmSignIn(String signInChallengeResponse, Callback<SignInResult> callback) {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>(callback);
        internalCallback.async(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    @WorkerThread
    public SignInResult confirmSignIn(String signInChallengeResponse) throws Exception {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>();
        return internalCallback.await(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    private Runnable _confirmSignIn(final String signInChallengeResponse, final Callback<SignInResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                MultiFactorAuthenticationContinuation detectedContinuation;
                if (AWSMobileClient.this.signInState == null) {
                    callback.onError(new IllegalStateException("Cannot call confirmMFA(String, Callback) without initiating sign-in. This call is used for SMS_MFA and NEW_PASSWORD_REQUIREDsign-in state."));
                    return;
                }
                switch (AWSMobileClient.this.signInState) {
                    case SMS_MFA: {
                        AWSMobileClient.this.signInMfaContinuation.setMfaCode(signInChallengeResponse);
                        detectedContinuation = AWSMobileClient.this.signInMfaContinuation;
                        AWSMobileClient.this.signInCallback = new InternalCallback(callback);
                        break;
                    }
                    case NEW_PASSWORD_REQUIRED: {
                        ((NewPasswordContinuation)AWSMobileClient.this.signInChallengeContinuation).setPassword(signInChallengeResponse);
                        detectedContinuation = AWSMobileClient.this.signInChallengeContinuation;
                        AWSMobileClient.this.signInCallback = new InternalCallback(callback);
                        break;
                    }
                    case DONE: {
                        callback.onError(new IllegalStateException("confirmSignIn called after signIn has succeeded"));
                        return;
                    }
                    default: {
                        callback.onError(new IllegalStateException("confirmSignIn called on unsupported operation, please file a feature request"));
                        return;
                    }
                }
                if (detectedContinuation != null) {
                    detectedContinuation.continueTask();
                }
            }
        };
    }

    @AnyThread
    public void confirmSignIn(Map<String, String> signInChallengeResponse, Callback<SignInResult> callback) {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>(callback);
        internalCallback.async(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    @WorkerThread
    public SignInResult confirmSignIn(Map<String, String> signInChallengeResponse) throws Exception {
        InternalCallback<SignInResult> internalCallback = new InternalCallback<SignInResult>();
        return internalCallback.await(this._confirmSignIn(signInChallengeResponse, internalCallback));
    }

    private Runnable _confirmSignIn(final Map<String, String> signInChallengeResponse, final Callback<SignInResult> callback) {
        return new Runnable(){

            @Override
            public void run() {
                ChallengeContinuation detectedContinuation;
                if (AWSMobileClient.this.signInState == null) {
                    callback.onError(new IllegalStateException("Cannot call confirmMFA(Map<String, String>, Callback) without initiating sign-in. This call is used for CUSTOM_CHALLENGE sign-in state."));
                    return;
                }
                switch (AWSMobileClient.this.signInState) {
                    case SMS_MFA: 
                    case NEW_PASSWORD_REQUIRED: {
                        callback.onError(new IllegalStateException("Please use confirmSignIn(String, Callback) for SMS_MFA and NEW_PASSWORD_REQUIRED challenges"));
                    }
                    case CUSTOM_CHALLENGE: {
                        for (String key : signInChallengeResponse.keySet()) {
                            AWSMobileClient.this.signInChallengeContinuation.setChallengeResponse(key, (String)signInChallengeResponse.get(key));
                        }
                        detectedContinuation = AWSMobileClient.this.signInChallengeContinuation;
                        AWSMobileClient.this.signInCallback = new InternalCallback(callback);
                        break;
                    }
                    case DONE: {
                        detectedContinuation = null;
                        Log.d((String)TAG, (String)"confirmSignIn called after signIn has succeeded");
                        break;
                    }
                    default: {
                        callback.onError(new IllegalStateException("confirmSignIn called on unsupported operation, please file a feature request"));
                        return;
                    }
                }
                if (detectedContinuation != null) {
                    detectedContinuation.continueTask();
                }
            }
        };
    }

    @AnyThread
    public void getUserAttributes(Callback<Map<String, String>> callback) {
        InternalCallback<Map<String, String>> internalCallback = new InternalCallback<Map<String, String>>(callback);
        internalCallback.async(this._getUserAttributes(internalCallback));
    }

    @WorkerThread
    public Map<String, String> getUserAttributes() throws Exception {
        InternalCallback<Map<String, String>> internalCallback = new InternalCallback<Map<String, String>>();
        return internalCallback.await(this._getUserAttributes(internalCallback));
    }

    private Runnable _getUserAttributes(final Callback<Map<String, String>> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (!AWSMobileClient.this.waitForSignIn()) {
                    callback.onError(new Exception("Operation requires a signed-in state"));
                    return;
                }
                AWSMobileClient.this.userpool.getCurrentUser().getDetails(new GetDetailsHandler(){

                    public void onSuccess(CognitoUserDetails cognitoUserDetails) {
                        callback.onResult(cognitoUserDetails.getAttributes().getAttributes());
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void updateUserAttributes(Map<String, String> userAttributes, Callback<List<UserCodeDeliveryDetails>> callback) {
        InternalCallback<List<UserCodeDeliveryDetails>> internalCallback = new InternalCallback<List<UserCodeDeliveryDetails>>(callback);
        internalCallback.async(this._updateUserAttributes(userAttributes, internalCallback));
    }

    @WorkerThread
    public List<UserCodeDeliveryDetails> updateUserAttributes(Map<String, String> userAttributes) throws Exception {
        InternalCallback<List<UserCodeDeliveryDetails>> internalCallback = new InternalCallback<List<UserCodeDeliveryDetails>>();
        return internalCallback.await(this._updateUserAttributes(userAttributes, internalCallback));
    }

    private Runnable _updateUserAttributes(final Map<String, String> userAttributes, final Callback<List<UserCodeDeliveryDetails>> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (!AWSMobileClient.this.waitForSignIn()) {
                    callback.onError(new Exception("Operation requires a signed-in state"));
                    return;
                }
                CognitoUserAttributes cognitoUserAttributes = new CognitoUserAttributes();
                if (userAttributes != null) {
                    for (String key : userAttributes.keySet()) {
                        cognitoUserAttributes.addAttribute(key, (String)userAttributes.get(key));
                    }
                }
                AWSMobileClient.this.userpool.getCurrentUser().updateAttributes(cognitoUserAttributes, new UpdateAttributesHandler(){

                    public void onSuccess(List<CognitoUserCodeDeliveryDetails> attributesVerificationList) {
                        LinkedList<UserCodeDeliveryDetails> list = new LinkedList<UserCodeDeliveryDetails>();
                        for (CognitoUserCodeDeliveryDetails details : attributesVerificationList) {
                            list.add(new UserCodeDeliveryDetails(details.getDestination(), details.getDeliveryMedium(), details.getAttributeName()));
                        }
                        callback.onResult(list);
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void verifyUserAttribute(String attributeName, Callback<UserCodeDeliveryDetails> callback) {
        InternalCallback<UserCodeDeliveryDetails> internalCallback = new InternalCallback<UserCodeDeliveryDetails>(callback);
        internalCallback.async(this._verifyUserAttribute(attributeName, internalCallback));
    }

    @WorkerThread
    public UserCodeDeliveryDetails verifyUserAttribute(String attributeName) throws Exception {
        InternalCallback<UserCodeDeliveryDetails> internalCallback = new InternalCallback<UserCodeDeliveryDetails>();
        return internalCallback.await(this._verifyUserAttribute(attributeName, internalCallback));
    }

    private Runnable _verifyUserAttribute(final String attributeName, final Callback<UserCodeDeliveryDetails> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (!AWSMobileClient.this.waitForSignIn()) {
                    callback.onError(new Exception("Operation requires a signed-in state"));
                    return;
                }
                AWSMobileClient.this.userpool.getCurrentUser().getAttributeVerificationCodeInBackground(attributeName, new VerificationHandler(){

                    public void onSuccess(CognitoUserCodeDeliveryDetails verificationCodeDeliveryMedium) {
                        callback.onResult(new UserCodeDeliveryDetails(verificationCodeDeliveryMedium.getDestination(), verificationCodeDeliveryMedium.getDeliveryMedium(), verificationCodeDeliveryMedium.getAttributeName()));
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public void confirmUpdateUserAttribute(String attributeName, String updateUserAttributeChallengeResponse, Callback<Void> callback) {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>(callback);
        internalCallback.async(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    @WorkerThread
    public void confirmUpdateUserAttribute(String attributeName, String updateUserAttributeChallengeResponse) throws Exception {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>();
        internalCallback.await(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    @AnyThread
    public void confirmVerifyUserAttribute(String attributeName, String updateUserAttributeChallengeResponse, Callback<Void> callback) {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>(callback);
        internalCallback.async(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    @WorkerThread
    public void confirmVerifyUserAttribute(String attributeName, String updateUserAttributeChallengeResponse) throws Exception {
        InternalCallback<Void> internalCallback = new InternalCallback<Void>();
        internalCallback.await(this._confirmUserAttribute(attributeName, updateUserAttributeChallengeResponse, internalCallback));
    }

    private Runnable _confirmUserAttribute(final String attributeName, final String updateUserAttributeChallengeResponse, final Callback<Void> callback) {
        return new Runnable(){

            @Override
            public void run() {
                if (!AWSMobileClient.this.waitForSignIn()) {
                    callback.onError(new Exception("Operation requires a signed-in state"));
                    return;
                }
                AWSMobileClient.this.userpool.getCurrentUser().verifyAttribute(attributeName, updateUserAttributeChallengeResponse, new GenericHandler(){

                    public void onSuccess() {
                        callback.onResult(null);
                    }

                    public void onFailure(Exception exception) {
                        callback.onError(exception);
                    }
                });
            }
        };
    }

    @AnyThread
    public boolean handleAuthResponse(Intent intent) {
        if (this.hostedUI != null) {
            this.hostedUI.getTokens(intent.getData());
            return true;
        }
        return this.mOAuth2Client != null && this.mOAuth2Client.handleRedirect(intent.getData());
    }

    @AnyThread
    public void showSignIn(Activity callingActivity, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._showSignIn(callingActivity, SignInUIOptions.builder().build(), internalCallback));
    }

    @WorkerThread
    public UserStateDetails showSignIn(Activity callingActivity) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        return internalCallback.await(this._showSignIn(callingActivity, SignInUIOptions.builder().build(), internalCallback));
    }

    @AnyThread
    public void showSignIn(Activity callingActivity, SignInUIOptions signInUIOptions, Callback<UserStateDetails> callback) {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>(callback);
        internalCallback.async(this._showSignIn(callingActivity, signInUIOptions, internalCallback));
    }

    @WorkerThread
    public UserStateDetails showSignIn(Activity callingActivity, SignInUIOptions signInUIOptions) throws Exception {
        InternalCallback<UserStateDetails> internalCallback = new InternalCallback<UserStateDetails>();
        return internalCallback.await(this._showSignIn(callingActivity, signInUIOptions, internalCallback));
    }

    private Runnable _showSignIn(Activity callingActivity, SignInUIOptions signInUIOptions, final Callback<UserStateDetails> callback) {
        if (signInUIOptions.getHostedUIOptions() != null) {
            JSONObject hostedUIJSON = this.getHostedUIJSON();
            if (hostedUIJSON == null) {
                return new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(new Exception("showSignIn called with HostedUI options in awsconfiguration.json"));
                    }
                };
            }
            if (hostedUIJSON.optString("TokenURI", null) != null) {
                return this._showSignInOAuth2UI(callingActivity, signInUIOptions, callback);
            }
            return this._showSignInHostedUI(callingActivity, signInUIOptions, callback);
        }
        return this._showSignInDropInUI(callingActivity, signInUIOptions, callback);
    }

    private Runnable _showSignInOAuth2UI(Activity callingActivity, final SignInUIOptions signInUIOptions, final Callback<UserStateDetails> callback) {
        return new Runnable(){

            @Override
            public void run() {
                Uri.Builder tokensUriBuilder;
                Uri.Builder authorizeUriBuilder;
                final HostedUIOptions hostedUIOptions = signInUIOptions.getHostedUIOptions();
                JSONObject hostedUIJSON = AWSMobileClient.this.getHostedUIJSONFromJSON();
                if (hostedUIJSON == null) {
                    callback.onError(new Exception("Could not create OAuth configuration object"));
                }
                if (hostedUIOptions.getFederationEnabled() != null) {
                    AWSMobileClient.this.mStore.set(AWSMobileClient.FEDERATION_ENABLED_KEY, hostedUIOptions.getFederationEnabled() != false ? "true" : "false");
                } else {
                    AWSMobileClient.this.mStore.set(AWSMobileClient.FEDERATION_ENABLED_KEY, "true");
                }
                AWSMobileClient.this.mStore.set(AWSMobileClient.SIGN_IN_MODE, SignInMode.OAUTH2.toString());
                if (AWSMobileClient.this.isFederationEnabled() && hostedUIOptions.getFederationProviderName() == null) {
                    throw new IllegalArgumentException("OAuth flow requires a federation provider name if federation is enabled.");
                }
                if (hostedUIOptions.getSignOutQueryParameters() != null) {
                    try {
                        JSONObject signOutParams = new JSONObject();
                        for (Map.Entry<String, String> e : hostedUIOptions.getSignOutQueryParameters().entrySet()) {
                            signOutParams.put(e.getKey(), (Object)e.getValue());
                        }
                        hostedUIJSON.put("SignOutQueryParameters", (Object)signOutParams);
                    }
                    catch (JSONException e1) {
                        callback.onError(new Exception("Failed to construct sign-out query parameters", e1));
                        return;
                    }
                }
                if (hostedUIOptions.getTokenQueryParameters() != null) {
                    try {
                        JSONObject tokenParams = new JSONObject();
                        for (Map.Entry<String, String> e : hostedUIOptions.getTokenQueryParameters().entrySet()) {
                            tokenParams.put(e.getKey(), (Object)e.getValue());
                        }
                        hostedUIJSON.put("TokenQueryParameters", (Object)tokenParams);
                    }
                    catch (JSONException e1) {
                        callback.onError(new Exception("Failed to construct token query parameters", e1));
                        return;
                    }
                }
                AWSMobileClient.this.mStore.set(AWSMobileClient.HOSTED_UI_KEY, hostedUIJSON.toString());
                try {
                    authorizeUriBuilder = Uri.parse((String)hostedUIJSON.getString("SignInURI")).buildUpon();
                    if (hostedUIOptions.getSignInQueryParameters() != null) {
                        for (Map.Entry<String, String> e : hostedUIOptions.getSignInQueryParameters().entrySet()) {
                            authorizeUriBuilder.appendQueryParameter(e.getKey(), e.getValue());
                        }
                    }
                    authorizeUriBuilder.appendQueryParameter("redirect_uri", hostedUIJSON.getString("SignInRedirectURI"));
                    authorizeUriBuilder.appendQueryParameter("scopes", hostedUIJSON.getJSONArray("Scopes").join(" "));
                    authorizeUriBuilder.appendQueryParameter("client_id", hostedUIJSON.getString("AppClientId"));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to construct authorization url for OAuth", e);
                }
                final HashMap<String, String> tokensBody = new HashMap<String, String>();
                try {
                    tokensUriBuilder = Uri.parse((String)hostedUIJSON.getString("TokenURI")).buildUpon();
                    if (hostedUIOptions.getSignInQueryParameters() != null) {
                        for (Map.Entry<String, String> e : hostedUIOptions.getTokenQueryParameters().entrySet()) {
                            tokensUriBuilder.appendQueryParameter(e.getKey(), e.getValue());
                        }
                    }
                    tokensBody.put("client_id", hostedUIJSON.getString("AppClientId"));
                    tokensBody.put("redirect_uri", hostedUIJSON.getString("SignInRedirectURI"));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to construct tokens url for OAuth", e);
                }
                final Uri tokensUri = tokensUriBuilder.build();
                AWSMobileClient.this.mOAuth2Client.authorize(authorizeUriBuilder.build(), new Callback<AuthorizeResponse>(){

                    @Override
                    public void onResult(AuthorizeResponse result) {
                        Log.i((String)TAG, (String)"onResult: OAuth2 callback occurred, exchanging code for token");
                        AWSMobileClient.this.mOAuth2Client.requestTokens(tokensUri, new HashMap<String, String>(), tokensBody, result.getCode(), new Callback<OAuth2Tokens>(){

                            @Override
                            public void onResult(OAuth2Tokens result) {
                                if (AWSMobileClient.this.isFederationEnabled()) {
                                    AWSMobileClient.this.federatedSignInWithoutAssigningState(hostedUIOptions.getFederationProviderName(), result.getIdToken(), new Callback<UserStateDetails>(){

                                        @Override
                                        public void onResult(UserStateDetails result) {
                                            UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(false);
                                            callback.onResult(userStateDetails);
                                            AWSMobileClient.this.setUserState(userStateDetails);
                                        }

                                        @Override
                                        public void onError(Exception e) {
                                            UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(false);
                                            callback.onResult(userStateDetails);
                                            AWSMobileClient.this.setUserState(userStateDetails);
                                        }
                                    });
                                } else {
                                    UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(false);
                                    callback.onResult(userStateDetails);
                                    AWSMobileClient.this.setUserState(userStateDetails);
                                }
                            }

                            @Override
                            public void onError(Exception e) {
                                callback.onError(e);
                            }
                        });
                    }

                    @Override
                    public void onError(Exception e) {
                        callback.onError(e);
                    }
                });
            }
        };
    }

    private Runnable _showSignInHostedUI(Activity callingActivity, final SignInUIOptions signInUIOptions, final Callback<UserStateDetails> callback) {
        return new Runnable(){

            @Override
            public void run() {
                HashSet scopes;
                HostedUIOptions hostedUIOptions = signInUIOptions.getHostedUIOptions();
                JSONObject hostedUIJSON = null;
                try {
                    hostedUIJSON = new JSONObject(AWSMobileClient.this.getHostedUIJSONFromJSON().toString());
                }
                catch (JSONException e) {
                    callback.onError(new Exception("Could not create OAuth configuration object", e));
                }
                if (hostedUIOptions.getFederationEnabled() != null) {
                    AWSMobileClient.this.mStore.set(AWSMobileClient.FEDERATION_ENABLED_KEY, hostedUIOptions.getFederationEnabled() != false ? "true" : "false");
                } else {
                    AWSMobileClient.this.mStore.set(AWSMobileClient.FEDERATION_ENABLED_KEY, "true");
                }
                if (hostedUIOptions.getSignOutQueryParameters() != null) {
                    try {
                        JSONObject signOutParams = new JSONObject();
                        for (Map.Entry<String, String> e : hostedUIOptions.getSignOutQueryParameters().entrySet()) {
                            signOutParams.put(e.getKey(), (Object)e.getValue());
                        }
                        hostedUIJSON.put("SignOutQueryParameters", (Object)signOutParams);
                    }
                    catch (JSONException e1) {
                        callback.onError(new Exception("Failed to construct sign-out query parameters", e1));
                        return;
                    }
                }
                if (hostedUIOptions.getTokenQueryParameters() != null) {
                    try {
                        JSONObject tokenParams = new JSONObject();
                        for (Map.Entry<String, String> e : hostedUIOptions.getTokenQueryParameters().entrySet()) {
                            tokenParams.put(e.getKey(), (Object)e.getValue());
                        }
                        hostedUIJSON.put("TokenQueryParameters", (Object)tokenParams);
                    }
                    catch (JSONException e1) {
                        callback.onError(new Exception("Failed to construct token query parameters", e1));
                        return;
                    }
                }
                AWSMobileClient.this.mStore.set(AWSMobileClient.HOSTED_UI_KEY, hostedUIJSON.toString());
                if (hostedUIOptions.getScopes() != null) {
                    scopes = new HashSet();
                    Collections.addAll(scopes, hostedUIOptions.getScopes());
                } else {
                    scopes = null;
                }
                String identityProvider = hostedUIOptions.getIdentityProvider();
                String idpIdentifier = hostedUIOptions.getIdpIdentifier();
                AWSMobileClient.this.mStore.set(AWSMobileClient.SIGN_IN_MODE, SignInMode.HOSTED_UI.toString());
                Auth.Builder hostedUIBuilder = null;
                try {
                    hostedUIBuilder = AWSMobileClient.this.getHostedUI(hostedUIJSON);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Failed to construct HostedUI from awsconfiguration.json", e);
                }
                hostedUIBuilder.setPersistenceEnabled(AWSMobileClient.this.mIsPersistenceEnabled).setAuthHandler(new AuthHandler(){
                    boolean hasSucceededOnce = false;

                    public void onSuccess(AuthUserSession session) {
                        Log.d((String)TAG, (String)"onSuccess: HostedUI signed-in");
                        this.hasSucceededOnce = true;
                        if (AWSMobileClient.this.isFederationEnabled()) {
                            AWSMobileClient.this.federatedSignInWithoutAssigningState(AWSMobileClient.this.userpoolsLoginKey, session.getIdToken().getJWTToken(), new Callback<UserStateDetails>(){

                                @Override
                                public void onResult(UserStateDetails result) {
                                    Log.d((String)TAG, (String)"onResult: Federation from the Hosted UI succeeded");
                                }

                                @Override
                                public void onError(Exception e) {
                                    Log.e((String)TAG, (String)"onError: Federation from the Hosted UI failed", (Throwable)e);
                                }
                            });
                        }
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                UserStateDetails userStateDetails = AWSMobileClient.this.getUserStateDetails(false);
                                callback.onResult(userStateDetails);
                                AWSMobileClient.this.setUserState(userStateDetails);
                            }
                        }).start();
                    }

                    public void onSignout() {
                        Log.d((String)TAG, (String)"onSignout: HostedUI signed-out");
                    }

                    public void onFailure(final Exception e) {
                        if (this.hasSucceededOnce) {
                            Log.d((String)TAG, (String)"onFailure: Ignoring failure because HostedUI has signaled success at least once.");
                            return;
                        }
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                callback.onError(e);
                            }
                        }).start();
                    }
                });
                if (scopes != null) {
                    hostedUIBuilder.setScopes(scopes);
                }
                if (identityProvider != null) {
                    hostedUIBuilder.setIdentityProvider(identityProvider);
                }
                if (idpIdentifier != null) {
                    hostedUIBuilder.setIdpIdentifier(idpIdentifier);
                }
                AWSMobileClient.this.hostedUI = hostedUIBuilder.build();
                AWSMobileClient.this.hostedUI.getSession();
            }
        };
    }

    private Runnable _showSignInDropInUI(final Activity callingActivity, final SignInUIOptions signInUIOptions, final Callback<UserStateDetails> callback) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AWSMobileClient.this.showSignInLockObject;
                synchronized (object) {
                    UserState userState = AWSMobileClient.this.getUserStateDetails(false).getUserState();
                    if (UserState.SIGNED_IN.equals((Object)userState)) {
                        callback.onError(new RuntimeException("Called showSignIn while user is already signed-in"));
                        return;
                    }
                    AWSMobileClient.this.registerConfigSignInProviders();
                    AuthUIConfiguration.Builder authUIConfigBuilder = new AuthUIConfiguration.Builder().canCancel(signInUIOptions.canCancel()).isBackgroundColorFullScreen(false);
                    if (signInUIOptions.getLogo() != null) {
                        authUIConfigBuilder.logoResId(signInUIOptions.getLogo().intValue());
                    }
                    if (signInUIOptions.getBackgroundColor() != null) {
                        authUIConfigBuilder.backgroundColor(signInUIOptions.getBackgroundColor().intValue());
                    }
                    if (AWSMobileClient.this.isConfigurationKeyPresent(AWSMobileClient.USER_POOLS)) {
                        authUIConfigBuilder.userPools(true);
                    }
                    if (AWSMobileClient.this.isConfigurationKeyPresent(AWSMobileClient.FACEBOOK)) {
                        authUIConfigBuilder.signInButton(FacebookButton.class);
                    }
                    if (AWSMobileClient.this.isConfigurationKeyPresent(AWSMobileClient.GOOGLE)) {
                        authUIConfigBuilder.signInButton(GoogleButton.class);
                    }
                    Class<Object> nextActivityClass = signInUIOptions.nextActivity() == null ? callingActivity.getClass() : signInUIOptions.nextActivity();
                    SignInUI signin = (SignInUI)AWSMobileClient.this.getClient(AWSMobileClient.this.mContext, SignInUI.class);
                    signin.login(callingActivity, nextActivityClass).authUIConfiguration(authUIConfigBuilder.build()).enableFederation(false).execute();
                    AWSMobileClient.this.showSignInWaitLatch = new CountDownLatch(1);
                    try {
                        AWSMobileClient.this.showSignInWaitLatch.await();
                        callback.onResult(AWSMobileClient.this.getUserStateDetails(false));
                        Log.d((String)TAG, (String)"run: showSignIn completed");
                    }
                    catch (InterruptedException e) {
                        callback.onError(e);
                    }
                }
            }
        };
    }

    @Deprecated
    public InitializeBuilder initialize(Context context) {
        this.awsStartupHandler = new AWSStartupHandler(){

            @Override
            public void onComplete(AWSStartupResult awsStartupResult) {
                Log.d((String)TAG, (String)"AWSMobileClient Initialize succeeded.");
                Log.i((String)TAG, (String)"Welcome to AWS! You are connected successfully.");
            }
        };
        return this.initialize(context, this.awsStartupHandler);
    }

    @Deprecated
    public InitializeBuilder initialize(Context context, final AWSStartupHandler awsStartupHandler) {
        this.awsConfiguration = new AWSConfiguration(context.getApplicationContext());
        this.signInProviderConfig = null;
        this.startupAuthResultHandler = new StartupAuthResultHandler(){

            public void onComplete(StartupAuthResult startupAuthResult) {
                Log.i((String)TAG, (String)"Welcome to AWS! You are connected successfully.");
                if (startupAuthResult.isIdentityIdAvailable()) {
                    Log.i((String)TAG, (String)"Identity ID retrieved.");
                }
                awsStartupHandler.onComplete(new AWSStartupResult(IdentityManager.getDefaultIdentityManager()));
            }
        };
        this.awsStartupHandler = awsStartupHandler;
        this.mIsLegacyMode = true;
        return new InitializeBuilder(context);
    }

    private void initializeWithBuilder(InitializeBuilder initializeBuilder) {
        if (initializeBuilder.getAwsConfiguration() != null) {
            this.awsConfiguration = initializeBuilder.getAwsConfiguration();
        }
        if (initializeBuilder.getSignInProviderConfig() != null) {
            this.signInProviderConfig = initializeBuilder.getSignInProviderConfig();
        }
        try {
            this.fetchCognitoIdentity(initializeBuilder.getContext(), this.startupAuthResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error in initializing the AWSMobileClient. Check if AWS Cloud Config `awsconfiguration.json` is present in the application.");
        }
    }

    public AWSConfigurable getClient(Context context, Class<? extends AWSConfigurable> clientClass) {
        Log.d((String)TAG, (String)("Retrieving the client instance for class: " + clientClass));
        AWSConfigurable client = this.clientMap.get(clientClass);
        try {
            if (client == null) {
                client = clientClass.newInstance().initialize(context.getApplicationContext(), this.awsConfiguration);
                this.clientMap.put(clientClass, client);
                Log.d((String)TAG, (String)("Created the new client: " + client.toString()));
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Error occurred in creating and initializing client. Check the context and the clientClass passed in: " + clientClass), (Throwable)exception);
        }
        return client;
    }

    @Deprecated
    public AWSCredentialsProvider getCredentialsProvider() {
        if (!this.isLegacyMode()) {
            return this;
        }
        if (this.awsCredentialsProvider != null) {
            return this.awsCredentialsProvider;
        }
        return IdentityManager.getDefaultIdentityManager().getUnderlyingProvider();
    }

    @Deprecated
    public void setCredentialsProvider(AWSCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    private void fetchCognitoIdentity(Context context, StartupAuthResultHandler startupAuthResultHandler) {
        try {
            Log.d((String)TAG, (String)"Fetching the Cognito Identity.");
            IdentityManager identityManager = new IdentityManager(context, this.awsConfiguration);
            IdentityManager.setDefaultIdentityManager((IdentityManager)identityManager);
            if (this.signInProviderConfig == null) {
                this.registerConfigSignInProviders();
            } else {
                this.registerUserSignInProvidersWithPermissions();
            }
            this.resumeSession((Activity)context, startupAuthResultHandler);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Error occurred in fetching the Cognito Identity and resuming the auth session", (Throwable)exception);
        }
    }

    private void registerUserSignInProvidersWithPermissions() {
        Log.d((String)TAG, (String)"Using the SignInProviderConfig supplied by the user.");
        IdentityManager identityManager = IdentityManager.getDefaultIdentityManager();
        for (SignInProviderConfig config : this.signInProviderConfig) {
            identityManager.addSignInProvider(config.getSignInProviderClass());
            if (config.getProviderPermissions() == null) continue;
            if (FacebookSignInProvider.class.isInstance(config.getSignInProviderClass())) {
                FacebookSignInProvider.setPermissions((String[])config.getProviderPermissions());
            }
            if (!GoogleSignInProvider.class.isInstance(config.getSignInProviderClass())) continue;
            GoogleSignInProvider.setPermissions((String[])config.getProviderPermissions());
        }
    }

    private void registerConfigSignInProviders() {
        Log.d((String)TAG, (String)"Using the SignInProviderConfig from `awsconfiguration.json`.");
        IdentityManager identityManager = IdentityManager.getDefaultIdentityManager();
        if (this.isConfigurationKeyPresent(USER_POOLS, this.awsConfiguration) && !identityManager.getSignInProviderClasses().contains(CognitoUserPoolsSignInProvider.class)) {
            identityManager.addSignInProvider(CognitoUserPoolsSignInProvider.class);
        }
        if (this.isConfigurationKeyPresent(FACEBOOK, this.awsConfiguration) && !identityManager.getSignInProviderClasses().contains(FacebookSignInProvider.class)) {
            identityManager.addSignInProvider(FacebookSignInProvider.class);
        }
        if (this.isConfigurationKeyPresent(GOOGLE, this.awsConfiguration) && !identityManager.getSignInProviderClasses().contains(GoogleSignInProvider.class)) {
            identityManager.addSignInProvider(GoogleSignInProvider.class);
        }
    }

    private boolean isConfigurationKeyPresent(String configurationKey) {
        return this.isConfigurationKeyPresent(configurationKey, this.awsConfiguration);
    }

    private boolean isConfigurationKeyPresent(String configurationKey, AWSConfiguration awsConfig) {
        try {
            JSONObject jsonObject = awsConfig.optJsonObject(configurationKey);
            if (configurationKey.equals(GOOGLE)) {
                return jsonObject != null && jsonObject.getString(GOOGLE_WEBAPP_CONFIG_KEY) != null;
            }
            return jsonObject != null;
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)(configurationKey + " not found in `awsconfiguration.json`"));
            return false;
        }
    }

    private void resumeSession(Activity callingActivity, StartupAuthResultHandler startupAuthResultHandler) {
        IdentityManager.getDefaultIdentityManager().resumeSession(callingActivity, startupAuthResultHandler);
    }

    @Deprecated
    public class SignInProviderConfig {
        @Deprecated
        private Class<? extends SignInProvider> signInProvider;
        @Deprecated
        private String[] providerPermissions;

        @Deprecated
        public SignInProviderConfig(Class<? extends SignInProvider> signInProvider, String ... providerPermissions) {
            this.signInProvider = signInProvider;
            this.providerPermissions = providerPermissions;
        }

        @Deprecated
        public Class<? extends SignInProvider> getSignInProviderClass() {
            return this.signInProvider;
        }

        @Deprecated
        public String[] getProviderPermissions() {
            return this.providerPermissions;
        }
    }

    @Deprecated
    public class InitializeBuilder {
        private Context context;
        private AWSConfiguration awsConfiguration;
        private SignInProviderConfig[] signInProviderConfig;

        @Deprecated
        public InitializeBuilder() {
            this.context = null;
            this.awsConfiguration = null;
            this.signInProviderConfig = null;
        }

        @Deprecated
        public InitializeBuilder(Context context) {
            this.context = context;
            this.awsConfiguration = null;
            this.signInProviderConfig = null;
        }

        @Deprecated
        public InitializeBuilder awsConfiguration(AWSConfiguration awsConfiguration) {
            this.awsConfiguration = awsConfiguration;
            return this;
        }

        @Deprecated
        public InitializeBuilder signInProviders(SignInProviderConfig ... providersConfig) {
            this.signInProviderConfig = providersConfig;
            return this;
        }

        @Deprecated
        public AWSConfiguration getAwsConfiguration() {
            return this.awsConfiguration;
        }

        @Deprecated
        public SignInProviderConfig[] getSignInProviderConfig() {
            return this.signInProviderConfig;
        }

        @Deprecated
        public Context getContext() {
            return this.context;
        }

        @Deprecated
        public void execute() {
            AWSMobileClient.this.initializeWithBuilder(this);
        }
    }

    static enum SignInMode {
        SIGN_IN("0"),
        FEDERATED_SIGN_IN("1"),
        HOSTED_UI("2"),
        OAUTH2("3"),
        UNKNOWN("-1");

        String encode;

        private SignInMode(String encode) {
            this.encode = encode;
        }

        public String toString() {
            return this.encode;
        }

        static SignInMode fromString(String str) {
            if ("0".equals(str)) {
                return SIGN_IN;
            }
            if ("1".equals(str)) {
                return FEDERATED_SIGN_IN;
            }
            if ("2".equals(str)) {
                return HOSTED_UI;
            }
            if ("3".equals(str)) {
                return OAUTH2;
            }
            return UNKNOWN;
        }
    }
}

