/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.client;

import android.content.SharedPreferences;
import com.amazonaws.mobile.client.AWSMobileClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class AWSMobileClientStore {
    private final SharedPreferences mSharedPreferences;
    ReadWriteLock mReadWriteLock = new ReentrantReadWriteLock();

    AWSMobileClientStore(AWSMobileClient client) {
        this.mSharedPreferences = client.mContext.getSharedPreferences("com.amazonaws.mobile.client", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> get(String ... keys) {
        try {
            this.mReadWriteLock.readLock().lock();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (String key : keys) {
                attributes.put(key, this.mSharedPreferences.getString(key, null));
            }
            HashMap<String, String> hashMap = attributes;
            return hashMap;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    String get(String key) {
        try {
            this.mReadWriteLock.readLock().lock();
            String string = this.mSharedPreferences.getString(key, null);
            return string;
        }
        finally {
            this.mReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(Map<String, String> attributes) {
        try {
            this.mReadWriteLock.writeLock().lock();
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            for (String key : attributes.keySet()) {
                editor.putString(key, attributes.get(key));
            }
            editor.commit();
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String key, String value) {
        try {
            this.mReadWriteLock.writeLock().lock();
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.putString(key, value);
            editor.commit();
        }
        finally {
            this.mReadWriteLock.writeLock().unlock();
        }
    }

    void clear() {
        this.mSharedPreferences.edit().clear().commit();
    }
}

