/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.MultiRegionConfiguration;
import com.amazonaws.services.kms.model.MultiRegionKey;
import com.amazonaws.services.kms.model.transform.MultiRegionKeyJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class MultiRegionConfigurationJsonMarshaller {
    private static MultiRegionConfigurationJsonMarshaller instance;

    MultiRegionConfigurationJsonMarshaller() {
    }

    public void marshall(MultiRegionConfiguration multiRegionConfiguration, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (multiRegionConfiguration.getMultiRegionKeyType() != null) {
            String multiRegionKeyType = multiRegionConfiguration.getMultiRegionKeyType();
            jsonWriter.name("MultiRegionKeyType");
            jsonWriter.value(multiRegionKeyType);
        }
        if (multiRegionConfiguration.getPrimaryKey() != null) {
            MultiRegionKey primaryKey = multiRegionConfiguration.getPrimaryKey();
            jsonWriter.name("PrimaryKey");
            MultiRegionKeyJsonMarshaller.getInstance().marshall(primaryKey, jsonWriter);
        }
        if (multiRegionConfiguration.getReplicaKeys() != null) {
            List<MultiRegionKey> replicaKeys = multiRegionConfiguration.getReplicaKeys();
            jsonWriter.name("ReplicaKeys");
            jsonWriter.beginArray();
            for (MultiRegionKey replicaKeysItem : replicaKeys) {
                if (replicaKeysItem == null) continue;
                MultiRegionKeyJsonMarshaller.getInstance().marshall(replicaKeysItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public static MultiRegionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MultiRegionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

