/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UntagResourceRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String keyId;
    private List<String> tagKeys = new ArrayList<String>();

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public UntagResourceRequest withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    public void setTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
            return;
        }
        this.tagKeys = new ArrayList<String>(tagKeys);
    }

    public UntagResourceRequest withTagKeys(String ... tagKeys) {
        if (this.getTagKeys() == null) {
            this.tagKeys = new ArrayList<String>(tagKeys.length);
        }
        for (String value : tagKeys) {
            this.tagKeys.add(value);
        }
        return this;
    }

    public UntagResourceRequest withTagKeys(Collection<String> tagKeys) {
        this.setTagKeys(tagKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyId() != null) {
            sb.append("KeyId: " + this.getKeyId() + ",");
        }
        if (this.getTagKeys() != null) {
            sb.append("TagKeys: " + this.getTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getTagKeys() == null ? 0 : this.getTagKeys().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourceRequest)) {
            return false;
        }
        UntagResourceRequest other = (UntagResourceRequest)obj;
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (other.getKeyId() != null && !other.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (other.getTagKeys() == null ^ this.getTagKeys() == null) {
            return false;
        }
        return other.getTagKeys() == null || other.getTagKeys().equals(this.getTagKeys());
    }
}

