/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.RecipientInfo;
import com.amazonaws.util.json.AwsJsonWriter;
import java.nio.ByteBuffer;

class RecipientInfoJsonMarshaller {
    private static RecipientInfoJsonMarshaller instance;

    RecipientInfoJsonMarshaller() {
    }

    public void marshall(RecipientInfo recipientInfo, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (recipientInfo.getKeyEncryptionAlgorithm() != null) {
            String keyEncryptionAlgorithm = recipientInfo.getKeyEncryptionAlgorithm();
            jsonWriter.name("KeyEncryptionAlgorithm");
            jsonWriter.value(keyEncryptionAlgorithm);
        }
        if (recipientInfo.getAttestationDocument() != null) {
            ByteBuffer attestationDocument = recipientInfo.getAttestationDocument();
            jsonWriter.name("AttestationDocument");
            jsonWriter.value(attestationDocument);
        }
        jsonWriter.endObject();
    }

    public static RecipientInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecipientInfoJsonMarshaller();
        }
        return instance;
    }
}

