/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.GenerateMacRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.List;

public class GenerateMacRequestMarshaller
implements Marshaller<Request<GenerateMacRequest>, GenerateMacRequest> {
    public Request<GenerateMacRequest> marshall(GenerateMacRequest generateMacRequest) {
        if (generateMacRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GenerateMacRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)generateMacRequest, "AWSKMS");
        String target = "TrentService.GenerateMac";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (generateMacRequest.getMessage() != null) {
                ByteBuffer message = generateMacRequest.getMessage();
                jsonWriter.name("Message");
                jsonWriter.value(message);
            }
            if (generateMacRequest.getKeyId() != null) {
                String keyId = generateMacRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (generateMacRequest.getMacAlgorithm() != null) {
                String macAlgorithm = generateMacRequest.getMacAlgorithm();
                jsonWriter.name("MacAlgorithm");
                jsonWriter.value(macAlgorithm);
            }
            if (generateMacRequest.getGrantTokens() != null) {
                List<String> grantTokens = generateMacRequest.getGrantTokens();
                jsonWriter.name("GrantTokens");
                jsonWriter.beginArray();
                for (String grantTokensItem : grantTokens) {
                    if (grantTokensItem == null) continue;
                    jsonWriter.value(grantTokensItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

