/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.ImportKeyMaterialRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Date;

public class ImportKeyMaterialRequestMarshaller
implements Marshaller<Request<ImportKeyMaterialRequest>, ImportKeyMaterialRequest> {
    public Request<ImportKeyMaterialRequest> marshall(ImportKeyMaterialRequest importKeyMaterialRequest) {
        if (importKeyMaterialRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ImportKeyMaterialRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importKeyMaterialRequest, "AWSKMS");
        String target = "TrentService.ImportKeyMaterial";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (importKeyMaterialRequest.getKeyId() != null) {
                String keyId = importKeyMaterialRequest.getKeyId();
                jsonWriter.name("KeyId");
                jsonWriter.value(keyId);
            }
            if (importKeyMaterialRequest.getImportToken() != null) {
                ByteBuffer importToken = importKeyMaterialRequest.getImportToken();
                jsonWriter.name("ImportToken");
                jsonWriter.value(importToken);
            }
            if (importKeyMaterialRequest.getEncryptedKeyMaterial() != null) {
                ByteBuffer encryptedKeyMaterial = importKeyMaterialRequest.getEncryptedKeyMaterial();
                jsonWriter.name("EncryptedKeyMaterial");
                jsonWriter.value(encryptedKeyMaterial);
            }
            if (importKeyMaterialRequest.getValidTo() != null) {
                Date validTo = importKeyMaterialRequest.getValidTo();
                jsonWriter.name("ValidTo");
                jsonWriter.value(validTo);
            }
            if (importKeyMaterialRequest.getExpirationModel() != null) {
                String expirationModel = importKeyMaterialRequest.getExpirationModel();
                jsonWriter.name("ExpirationModel");
                jsonWriter.value(expirationModel);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

