/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.services.kms.model.KeyMetadata;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class KeyMetadataJsonMarshaller {
    private static KeyMetadataJsonMarshaller instance;

    KeyMetadataJsonMarshaller() {
    }

    public void marshall(KeyMetadata keyMetadata, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (keyMetadata.getAWSAccountId() != null) {
            String aWSAccountId = keyMetadata.getAWSAccountId();
            jsonWriter.name("AWSAccountId");
            jsonWriter.value(aWSAccountId);
        }
        if (keyMetadata.getKeyId() != null) {
            String keyId = keyMetadata.getKeyId();
            jsonWriter.name("KeyId");
            jsonWriter.value(keyId);
        }
        if (keyMetadata.getArn() != null) {
            String arn = keyMetadata.getArn();
            jsonWriter.name("Arn");
            jsonWriter.value(arn);
        }
        if (keyMetadata.getCreationDate() != null) {
            Date creationDate = keyMetadata.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (keyMetadata.getEnabled() != null) {
            Boolean enabled = keyMetadata.getEnabled();
            jsonWriter.name("Enabled");
            jsonWriter.value(enabled.booleanValue());
        }
        if (keyMetadata.getDescription() != null) {
            String description = keyMetadata.getDescription();
            jsonWriter.name("Description");
            jsonWriter.value(description);
        }
        if (keyMetadata.getKeyUsage() != null) {
            String keyUsage = keyMetadata.getKeyUsage();
            jsonWriter.name("KeyUsage");
            jsonWriter.value(keyUsage);
        }
        if (keyMetadata.getKeyState() != null) {
            String keyState = keyMetadata.getKeyState();
            jsonWriter.name("KeyState");
            jsonWriter.value(keyState);
        }
        if (keyMetadata.getDeletionDate() != null) {
            Date deletionDate = keyMetadata.getDeletionDate();
            jsonWriter.name("DeletionDate");
            jsonWriter.value(deletionDate);
        }
        if (keyMetadata.getValidTo() != null) {
            Date validTo = keyMetadata.getValidTo();
            jsonWriter.name("ValidTo");
            jsonWriter.value(validTo);
        }
        if (keyMetadata.getOrigin() != null) {
            String origin = keyMetadata.getOrigin();
            jsonWriter.name("Origin");
            jsonWriter.value(origin);
        }
        if (keyMetadata.getCustomKeyStoreId() != null) {
            String customKeyStoreId = keyMetadata.getCustomKeyStoreId();
            jsonWriter.name("CustomKeyStoreId");
            jsonWriter.value(customKeyStoreId);
        }
        if (keyMetadata.getCloudHsmClusterId() != null) {
            String cloudHsmClusterId = keyMetadata.getCloudHsmClusterId();
            jsonWriter.name("CloudHsmClusterId");
            jsonWriter.value(cloudHsmClusterId);
        }
        if (keyMetadata.getExpirationModel() != null) {
            String expirationModel = keyMetadata.getExpirationModel();
            jsonWriter.name("ExpirationModel");
            jsonWriter.value(expirationModel);
        }
        if (keyMetadata.getKeyManager() != null) {
            String keyManager = keyMetadata.getKeyManager();
            jsonWriter.name("KeyManager");
            jsonWriter.value(keyManager);
        }
        if (keyMetadata.getCustomerMasterKeySpec() != null) {
            String customerMasterKeySpec = keyMetadata.getCustomerMasterKeySpec();
            jsonWriter.name("CustomerMasterKeySpec");
            jsonWriter.value(customerMasterKeySpec);
        }
        if (keyMetadata.getEncryptionAlgorithms() != null) {
            List<String> encryptionAlgorithms = keyMetadata.getEncryptionAlgorithms();
            jsonWriter.name("EncryptionAlgorithms");
            jsonWriter.beginArray();
            for (String encryptionAlgorithmsItem : encryptionAlgorithms) {
                if (encryptionAlgorithmsItem == null) continue;
                jsonWriter.value(encryptionAlgorithmsItem);
            }
            jsonWriter.endArray();
        }
        if (keyMetadata.getSigningAlgorithms() != null) {
            List<String> signingAlgorithms = keyMetadata.getSigningAlgorithms();
            jsonWriter.name("SigningAlgorithms");
            jsonWriter.beginArray();
            for (String signingAlgorithmsItem : signingAlgorithms) {
                if (signingAlgorithmsItem == null) continue;
                jsonWriter.value(signingAlgorithmsItem);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public static KeyMetadataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyMetadataJsonMarshaller();
        }
        return instance;
    }
}

