/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.CreateCustomKeyStoreRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateCustomKeyStoreRequestMarshaller
implements Marshaller<Request<CreateCustomKeyStoreRequest>, CreateCustomKeyStoreRequest> {
    public Request<CreateCustomKeyStoreRequest> marshall(CreateCustomKeyStoreRequest createCustomKeyStoreRequest) {
        if (createCustomKeyStoreRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateCustomKeyStoreRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCustomKeyStoreRequest, "AWSKMS");
        String target = "TrentService.CreateCustomKeyStore";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (createCustomKeyStoreRequest.getCustomKeyStoreName() != null) {
                String customKeyStoreName = createCustomKeyStoreRequest.getCustomKeyStoreName();
                jsonWriter.name("CustomKeyStoreName");
                jsonWriter.value(customKeyStoreName);
            }
            if (createCustomKeyStoreRequest.getCloudHsmClusterId() != null) {
                String cloudHsmClusterId = createCustomKeyStoreRequest.getCloudHsmClusterId();
                jsonWriter.name("CloudHsmClusterId");
                jsonWriter.value(cloudHsmClusterId);
            }
            if (createCustomKeyStoreRequest.getTrustAnchorCertificate() != null) {
                String trustAnchorCertificate = createCustomKeyStoreRequest.getTrustAnchorCertificate();
                jsonWriter.name("TrustAnchorCertificate");
                jsonWriter.value(trustAnchorCertificate);
            }
            if (createCustomKeyStoreRequest.getKeyStorePassword() != null) {
                String keyStorePassword = createCustomKeyStoreRequest.getKeyStorePassword();
                jsonWriter.name("KeyStorePassword");
                jsonWriter.value(keyStorePassword);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

