/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.services.kms.model.CustomerMasterKeySpec;
import com.amazonaws.services.kms.model.KeyUsageType;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetPublicKeyResult
implements Serializable {
    private String keyId;
    private ByteBuffer publicKey;
    private String customerMasterKeySpec;
    private String keyUsage;
    private List<String> encryptionAlgorithms = new ArrayList<String>();
    private List<String> signingAlgorithms = new ArrayList<String>();

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public GetPublicKeyResult withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public ByteBuffer getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(ByteBuffer publicKey) {
        this.publicKey = publicKey;
    }

    public GetPublicKeyResult withPublicKey(ByteBuffer publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public String getCustomerMasterKeySpec() {
        return this.customerMasterKeySpec;
    }

    public void setCustomerMasterKeySpec(String customerMasterKeySpec) {
        this.customerMasterKeySpec = customerMasterKeySpec;
    }

    public GetPublicKeyResult withCustomerMasterKeySpec(String customerMasterKeySpec) {
        this.customerMasterKeySpec = customerMasterKeySpec;
        return this;
    }

    public void setCustomerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
        this.customerMasterKeySpec = customerMasterKeySpec.toString();
    }

    public GetPublicKeyResult withCustomerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
        this.customerMasterKeySpec = customerMasterKeySpec.toString();
        return this;
    }

    public String getKeyUsage() {
        return this.keyUsage;
    }

    public void setKeyUsage(String keyUsage) {
        this.keyUsage = keyUsage;
    }

    public GetPublicKeyResult withKeyUsage(String keyUsage) {
        this.keyUsage = keyUsage;
        return this;
    }

    public void setKeyUsage(KeyUsageType keyUsage) {
        this.keyUsage = keyUsage.toString();
    }

    public GetPublicKeyResult withKeyUsage(KeyUsageType keyUsage) {
        this.keyUsage = keyUsage.toString();
        return this;
    }

    public List<String> getEncryptionAlgorithms() {
        return this.encryptionAlgorithms;
    }

    public void setEncryptionAlgorithms(Collection<String> encryptionAlgorithms) {
        if (encryptionAlgorithms == null) {
            this.encryptionAlgorithms = null;
            return;
        }
        this.encryptionAlgorithms = new ArrayList<String>(encryptionAlgorithms);
    }

    public GetPublicKeyResult withEncryptionAlgorithms(String ... encryptionAlgorithms) {
        if (this.getEncryptionAlgorithms() == null) {
            this.encryptionAlgorithms = new ArrayList<String>(encryptionAlgorithms.length);
        }
        for (String value : encryptionAlgorithms) {
            this.encryptionAlgorithms.add(value);
        }
        return this;
    }

    public GetPublicKeyResult withEncryptionAlgorithms(Collection<String> encryptionAlgorithms) {
        this.setEncryptionAlgorithms(encryptionAlgorithms);
        return this;
    }

    public List<String> getSigningAlgorithms() {
        return this.signingAlgorithms;
    }

    public void setSigningAlgorithms(Collection<String> signingAlgorithms) {
        if (signingAlgorithms == null) {
            this.signingAlgorithms = null;
            return;
        }
        this.signingAlgorithms = new ArrayList<String>(signingAlgorithms);
    }

    public GetPublicKeyResult withSigningAlgorithms(String ... signingAlgorithms) {
        if (this.getSigningAlgorithms() == null) {
            this.signingAlgorithms = new ArrayList<String>(signingAlgorithms.length);
        }
        for (String value : signingAlgorithms) {
            this.signingAlgorithms.add(value);
        }
        return this;
    }

    public GetPublicKeyResult withSigningAlgorithms(Collection<String> signingAlgorithms) {
        this.setSigningAlgorithms(signingAlgorithms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyId() != null) {
            sb.append("KeyId: " + this.getKeyId() + ",");
        }
        if (this.getPublicKey() != null) {
            sb.append("PublicKey: " + this.getPublicKey() + ",");
        }
        if (this.getCustomerMasterKeySpec() != null) {
            sb.append("CustomerMasterKeySpec: " + this.getCustomerMasterKeySpec() + ",");
        }
        if (this.getKeyUsage() != null) {
            sb.append("KeyUsage: " + this.getKeyUsage() + ",");
        }
        if (this.getEncryptionAlgorithms() != null) {
            sb.append("EncryptionAlgorithms: " + this.getEncryptionAlgorithms() + ",");
        }
        if (this.getSigningAlgorithms() != null) {
            sb.append("SigningAlgorithms: " + this.getSigningAlgorithms());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getPublicKey() == null ? 0 : this.getPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerMasterKeySpec() == null ? 0 : this.getCustomerMasterKeySpec().hashCode());
        hashCode = 31 * hashCode + (this.getKeyUsage() == null ? 0 : this.getKeyUsage().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionAlgorithms() == null ? 0 : this.getEncryptionAlgorithms().hashCode());
        hashCode = 31 * hashCode + (this.getSigningAlgorithms() == null ? 0 : this.getSigningAlgorithms().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPublicKeyResult)) {
            return false;
        }
        GetPublicKeyResult other = (GetPublicKeyResult)obj;
        if (other.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (other.getKeyId() != null && !other.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (other.getPublicKey() == null ^ this.getPublicKey() == null) {
            return false;
        }
        if (other.getPublicKey() != null && !other.getPublicKey().equals(this.getPublicKey())) {
            return false;
        }
        if (other.getCustomerMasterKeySpec() == null ^ this.getCustomerMasterKeySpec() == null) {
            return false;
        }
        if (other.getCustomerMasterKeySpec() != null && !other.getCustomerMasterKeySpec().equals(this.getCustomerMasterKeySpec())) {
            return false;
        }
        if (other.getKeyUsage() == null ^ this.getKeyUsage() == null) {
            return false;
        }
        if (other.getKeyUsage() != null && !other.getKeyUsage().equals(this.getKeyUsage())) {
            return false;
        }
        if (other.getEncryptionAlgorithms() == null ^ this.getEncryptionAlgorithms() == null) {
            return false;
        }
        if (other.getEncryptionAlgorithms() != null && !other.getEncryptionAlgorithms().equals(this.getEncryptionAlgorithms())) {
            return false;
        }
        if (other.getSigningAlgorithms() == null ^ this.getSigningAlgorithms() == null) {
            return false;
        }
        return other.getSigningAlgorithms() == null || other.getSigningAlgorithms().equals(this.getSigningAlgorithms());
    }
}

