/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.logging;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;

public final class ConsoleLog
implements Log {
    private final String tag;
    private LogFactory.Level level = null;

    public ConsoleLog(String tag) {
        this.tag = tag;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.DEBUG.getValue();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.ERROR.getValue();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.INFO.getValue();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.TRACE.getValue();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLevel() == null || this.getLevel().getValue() <= LogFactory.Level.WARN.getValue();
    }

    @Override
    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.log(LogFactory.Level.TRACE, message, null);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.log(LogFactory.Level.TRACE, message, t);
        }
    }

    @Override
    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log(LogFactory.Level.DEBUG, message, null);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log(LogFactory.Level.DEBUG, message, t);
        }
    }

    @Override
    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log(LogFactory.Level.INFO, message, null);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log(LogFactory.Level.INFO, message, t);
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.log(LogFactory.Level.WARN, message, null);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log(LogFactory.Level.WARN, message, t);
        }
    }

    @Override
    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.log(LogFactory.Level.ERROR, message, null);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log(LogFactory.Level.ERROR, message, t);
        }
    }

    @Override
    public void setLevel(LogFactory.Level level) {
        this.level = level;
    }

    private void log(LogFactory.Level level, Object message, Throwable throwable) {
        System.out.printf("%s/%s: %s\n", this.tag, level.name(), message);
        if (throwable != null) {
            System.out.println(throwable.toString());
        }
    }

    private LogFactory.Level getLevel() {
        if (this.level != null) {
            return this.level;
        }
        return LogFactory.getLevel();
    }
}

