/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.keyvaluestore;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.KeyPairGeneratorSpec;
import androidx.annotation.RequiresApi;
import com.amazonaws.internal.keyvaluestore.KeyNotFoundException;
import com.amazonaws.internal.keyvaluestore.KeyNotGeneratedException;
import com.amazonaws.internal.keyvaluestore.KeyProvider;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.util.Base64;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

@RequiresApi(api=18)
public class KeyProvider18
implements KeyProvider {
    private static final Log logger = LogFactory.getLog(KeyProvider18.class);
    static final String KEY_ALGORITHM_AES = "AES";
    static final int CIPHER_AES_GCM_NOPADDING_KEY_LENGTH_IN_BITS = 256;
    static final String ANDROID_KEY_STORE_NAME = "AndroidKeyStore";
    static final String KEY_ALGORITHM_RSA = "RSA";
    static final String CIPHER_RSA_MODE = "RSA/ECB/PKCS1Padding";
    static final String CIPHER_PROVIDER_NAME_FOR_RSA = "AndroidOpenSSL";
    static final String ENCRYPTED_AES_KEY = "AesGcmNoPadding18-encrypted-encryption-key";
    static final String AWS_KEY_VALUE_STORE_VERSION_1_KEY_STORE_ALIAS_FOR_RSA_SUFFIX = ".rsaKeyStoreAlias";
    private SecureRandom secureRandom;
    private Context context;
    private SharedPreferences sharedPreferences;

    KeyProvider18(Context context, SharedPreferences sharedPreferences) {
        this.context = context;
        this.sharedPreferences = sharedPreferences;
    }

    private byte[] rsaEncrypt(String keyAlias, byte[] rawData) {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, null);
            Cipher encryptCipher = Cipher.getInstance(CIPHER_RSA_MODE, CIPHER_PROVIDER_NAME_FOR_RSA);
            encryptCipher.init(1, privateKeyEntry.getCertificate().getPublicKey());
            return encryptCipher.doFinal(rawData);
        }
        catch (Exception ex) {
            logger.error("Exception occurred while encrypting data. " + ex.getMessage());
            return null;
        }
    }

    private byte[] rsaDecrypt(String keyAlias, byte[] encryptedData) {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, null);
            Cipher decryptCipher = Cipher.getInstance(CIPHER_RSA_MODE, CIPHER_PROVIDER_NAME_FOR_RSA);
            decryptCipher.init(2, privateKeyEntry.getPrivateKey());
            return decryptCipher.doFinal(encryptedData);
        }
        catch (Exception ex) {
            logger.error("Exception occurred while decrypting the encrypted AES key. ", ex);
            return null;
        }
    }

    @Override
    public synchronized Key generateKey(String rsaKeyAlias) throws KeyNotGeneratedException {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            end.add(1, 30);
            KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(this.context).setAlias(rsaKeyAlias).setSubject(new X500Principal("CN=" + rsaKeyAlias)).setSerialNumber(BigInteger.TEN).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEY_ALGORITHM_RSA, ANDROID_KEY_STORE_NAME);
            kpg.initialize((AlgorithmParameterSpec)spec);
            kpg.generateKeyPair();
        }
        catch (Exception ex) {
            throw new KeyNotGeneratedException("Error in generating the RSA Encryption key for the rsaKeyAlias: " + rsaKeyAlias + " in " + ANDROID_KEY_STORE_NAME, ex);
        }
        try {
            this.secureRandom = new SecureRandom();
            KeyGenerator generator = KeyGenerator.getInstance(KEY_ALGORITHM_AES);
            generator.init(256, this.secureRandom);
            SecretKey aesEncryptionKey = generator.generateKey();
            if (aesEncryptionKey == null) {
                throw new KeyNotGeneratedException("Error in generating the AES encryption key for the alias: AesGcmNoPadding18-encrypted-encryption-key");
            }
            byte[] aesEncryptionKeyInBytes = aesEncryptionKey.getEncoded();
            if (aesEncryptionKeyInBytes == null || aesEncryptionKeyInBytes.length == 0) {
                throw new KeyNotGeneratedException("Error in generating the AES encryption key for the alias: AesGcmNoPadding18-encrypted-encryption-key");
            }
            byte[] rsaEncryptedAESKeyInBytes = this.rsaEncrypt(rsaKeyAlias, aesEncryptionKeyInBytes);
            if (rsaEncryptedAESKeyInBytes == null || rsaEncryptedAESKeyInBytes.length == 0) {
                throw new KeyNotGeneratedException("Error in RSA encrypting the AES encryption key for the AES keyAlias: AesGcmNoPadding18-encrypted-encryption-key using the rsaKeyAlias: " + rsaKeyAlias);
            }
            String base64EncodedStringOfEncryptedAESKey = Base64.encodeAsString(rsaEncryptedAESKeyInBytes);
            if (base64EncodedStringOfEncryptedAESKey == null) {
                throw new KeyNotGeneratedException("Error in Base64 encoding of the Encrypted AES key for the AES keyAlias: AesGcmNoPadding18-encrypted-encryption-key using the rsaKeyAlias: " + rsaKeyAlias);
            }
            this.sharedPreferences.edit().putString(ENCRYPTED_AES_KEY, base64EncodedStringOfEncryptedAESKey).apply();
            logger.info("Generated and saved the Encrypted AES encryption key for the AES keyAlias: AesGcmNoPadding18-encrypted-encryption-key to SharedPreferences.");
            return aesEncryptionKey;
        }
        catch (Exception ex) {
            throw new KeyNotGeneratedException("Error in generating the AES key and RSA encrypting the AES key using the rsaKeyAlias: " + rsaKeyAlias + " in " + ANDROID_KEY_STORE_NAME, ex);
        }
    }

    @Override
    public synchronized Key retrieveKey(String keyAlias) throws KeyNotFoundException {
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            if (!keyStore.containsAlias(keyAlias)) {
                throw new KeyNotFoundException("The RSA Key identified by the alias: " + keyAlias + " cannot be found in " + ANDROID_KEY_STORE_NAME);
            }
            if (this.sharedPreferences.contains(ENCRYPTED_AES_KEY)) {
                logger.debug("Loading the encryption key from SharedPreferences");
                String encryptedAesEncryptionKey = this.sharedPreferences.getString(ENCRYPTED_AES_KEY, null);
                if (encryptedAesEncryptionKey == null) {
                    throw new KeyNotFoundException("Unable to retrieve the encrypted AES Key identified by AesGcmNoPadding18-encrypted-encryption-key from the SharedPreferences.");
                }
                byte[] base64DecodedKey = Base64.decode(encryptedAesEncryptionKey);
                if (base64DecodedKey == null || base64DecodedKey.length == 0) {
                    throw new KeyNotFoundException("Unable to Base64 decode the encrypted AES key identified by: AesGcmNoPadding18-encrypted-encryption-key");
                }
                byte[] aesKey = this.rsaDecrypt(keyAlias, base64DecodedKey);
                if (aesKey == null || aesKey.length == 0) {
                    throw new KeyNotFoundException("Unable to RSA decrypt the encrypted AES key identified by: AesGcmNoPadding18-encrypted-encryption-key using the RSA key identified by keyAlias: " + keyAlias);
                }
                return new SecretKeySpec(aesKey, KEY_ALGORITHM_AES);
            }
            throw new KeyNotFoundException("SharedPreferences does not have the key for keyAlias: AesGcmNoPadding18-encrypted-encryption-key");
        }
        catch (Exception ex) {
            throw new KeyNotFoundException("Error occurred while accessing AndroidKeyStore to retrieve the key for keyAlias: " + keyAlias, ex);
        }
    }

    @Override
    public synchronized void deleteKey(String keyAlias) {
        try {
            this.sharedPreferences.edit().remove(ENCRYPTED_AES_KEY).apply();
        }
        catch (Exception ex) {
            logger.error("Error in deleting the encrypted AES key identified by AesGcmNoPadding18-encrypted-encryption-key from SharedPreferences.", ex);
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
            keyStore.load(null);
            keyStore.deleteEntry(keyAlias);
        }
        catch (Exception ex) {
            logger.error("Error in deleting the RSA Key identified by the keyAlias: " + keyAlias + " from " + ANDROID_KEY_STORE_NAME, ex);
        }
    }
}

