/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.internal.config.HostRegexToRegionMapping;
import com.amazonaws.internal.config.HttpClientConfig;
import com.amazonaws.internal.config.SignerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalConfig {
    private static final Log log = LogFactory.getLog(InternalConfig.class);
    private static final String SERVICE_REGION_DELIMITOR = "/";
    private final SignerConfig defaultSignerConfig = InternalConfig.getDefaultSigner();
    private final Map<String, SignerConfig> serviceRegionSigners;
    private final Map<String, SignerConfig> regionSigners = InternalConfig.getDefaultRegionSigners();
    private final Map<String, SignerConfig> serviceSigners = InternalConfig.getDefaultServiceSigners();
    private final Map<String, HttpClientConfig> httpClients;
    private final List<HostRegexToRegionMapping> hostRegexToRegionMappings;

    InternalConfig() {
        this.serviceRegionSigners = InternalConfig.getDefaultServiceRegionSigners();
        this.httpClients = InternalConfig.getDefaultHttpClients();
        this.hostRegexToRegionMappings = InternalConfig.getDefaultHostRegexToRegionMappings();
    }

    public SignerConfig getSignerConfig(String serviceName) {
        return this.getSignerConfig(serviceName, null);
    }

    public HttpClientConfig getHttpClientConfig(String httpClientName) {
        return this.httpClients.get(httpClientName);
    }

    public SignerConfig getSignerConfig(String serviceName, String regionName) {
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        SignerConfig signerConfig = null;
        if (regionName != null) {
            String key = serviceName + SERVICE_REGION_DELIMITOR + regionName;
            signerConfig = this.serviceRegionSigners.get(key);
            if (signerConfig != null) {
                return signerConfig;
            }
            signerConfig = this.regionSigners.get(regionName);
            if (signerConfig != null) {
                return signerConfig;
            }
        }
        return (signerConfig = this.serviceSigners.get(serviceName)) == null ? this.defaultSignerConfig : signerConfig;
    }

    public List<HostRegexToRegionMapping> getHostRegexToRegionMappings() {
        return Collections.unmodifiableList(this.hostRegexToRegionMappings);
    }

    private static Map<String, HttpClientConfig> getDefaultHttpClients() {
        HashMap<String, HttpClientConfig> ret = new HashMap<String, HttpClientConfig>();
        ret.put("AmazonCloudWatchClient", new HttpClientConfig("monitoring"));
        ret.put("AmazonCloudWatchLogsClient", new HttpClientConfig("logs"));
        ret.put("AmazonSimpleDBClient", new HttpClientConfig("sdb"));
        ret.put("AmazonSimpleEmailServiceClient", new HttpClientConfig("email"));
        ret.put("AWSSecurityTokenServiceClient", new HttpClientConfig("sts"));
        ret.put("AmazonCognitoIdentityClient", new HttpClientConfig("cognito-identity"));
        ret.put("AmazonCognitoIdentityProviderClient", new HttpClientConfig("cognito-idp"));
        ret.put("AmazonCognitoSyncClient", new HttpClientConfig("cognito-sync"));
        ret.put("AmazonKinesisFirehoseClient", new HttpClientConfig("firehose"));
        ret.put("AWSIotClient", new HttpClientConfig("execute-api"));
        ret.put("AmazonLexRuntimeClient", new HttpClientConfig("runtime.lex"));
        ret.put("AmazonPinpointClient", new HttpClientConfig("mobiletargeting"));
        ret.put("AmazonPinpointAnalyticsClient", new HttpClientConfig("mobileanalytics"));
        ret.put("AmazonTranscribeClient", new HttpClientConfig("transcribe"));
        ret.put("AmazonTranslateClient", new HttpClientConfig("translate"));
        ret.put("AmazonComprehendClient", new HttpClientConfig("comprehend"));
        return ret;
    }

    private static Map<String, SignerConfig> getDefaultRegionSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        ret.put("eu-central-1", new SignerConfig("AWS4SignerType"));
        ret.put("cn-north-1", new SignerConfig("AWS4SignerType"));
        return ret;
    }

    private static Map<String, SignerConfig> getDefaultServiceRegionSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        ret.put("s3/eu-central-1", new SignerConfig("AWSS3V4SignerType"));
        ret.put("s3/cn-north-1", new SignerConfig("AWSS3V4SignerType"));
        ret.put("s3/us-east-2", new SignerConfig("AWSS3V4SignerType"));
        ret.put("s3/ca-central-1", new SignerConfig("AWSS3V4SignerType"));
        ret.put("s3/ap-south-1", new SignerConfig("AWSS3V4SignerType"));
        ret.put("s3/ap-northeast-2", new SignerConfig("AWSS3V4SignerType"));
        ret.put("s3/eu-west-2", new SignerConfig("AWSS3V4SignerType"));
        return ret;
    }

    private static Map<String, SignerConfig> getDefaultServiceSigners() {
        HashMap<String, SignerConfig> ret = new HashMap<String, SignerConfig>();
        ret.put("ec2", new SignerConfig("QueryStringSignerType"));
        ret.put("email", new SignerConfig("AWS3SignerType"));
        ret.put("s3", new SignerConfig("S3SignerType"));
        ret.put("sdb", new SignerConfig("QueryStringSignerType"));
        ret.put("runtime.lex", new SignerConfig("AmazonLexV4Signer"));
        ret.put("polly", new SignerConfig("AmazonPollyCustomPresigner"));
        return ret;
    }

    private static SignerConfig getDefaultSigner() {
        return new SignerConfig("AWS4SignerType");
    }

    private static List<HostRegexToRegionMapping> getDefaultHostRegexToRegionMappings() {
        ArrayList<HostRegexToRegionMapping> ret = new ArrayList<HostRegexToRegionMapping>();
        ret.add(new HostRegexToRegionMapping("(.+\\.)?s3\\.amazonaws\\.com", "us-east-1"));
        ret.add(new HostRegexToRegionMapping("(.+\\.)?s3-external-1\\.amazonaws\\.com", "us-east-1"));
        ret.add(new HostRegexToRegionMapping("(.+\\.)?s3-fips-us-gov-west-1\\.amazonaws\\.com", "us-gov-west-1"));
        return ret;
    }

    void dump() {
        StringBuilder sb = new StringBuilder().append("defaultSignerConfig: ").append(this.defaultSignerConfig).append("\n").append("serviceRegionSigners: ").append(this.serviceRegionSigners).append("\n").append("regionSigners: ").append(this.regionSigners).append("\n").append("serviceSigners: ").append(this.serviceSigners).append("\n").append("hostRegexToRegionMappings: ").append(this.hostRegexToRegionMappings);
        log.debug((Object)sb.toString());
    }

    public static class Factory {
        private static final InternalConfig SINGELTON;

        public static InternalConfig getInternalConfig() {
            return SINGELTON;
        }

        static {
            InternalConfig config = null;
            try {
                config = new InternalConfig();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Fatal: Failed to load the internal config for AWS Android SDK", ex);
            }
            SINGELTON = config;
        }
    }
}

