/*
 * Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.metrics;

/**
 * Metric type.
 */
public interface MetricType {
    /**
     * Non-null name of the metric type. Used to uniquely identify the metric
     * type. Therefore, the name returned must be globally unique across all
     * metric types that implement this interface.
     * @return the non-null name of the metric type.
     */
    public String name();
}
