/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;
import java.util.List;

public class DeleteIdentitiesRequestMarshaller
implements Marshaller<Request<DeleteIdentitiesRequest>, DeleteIdentitiesRequest> {
    @Override
    public Request<DeleteIdentitiesRequest> marshall(DeleteIdentitiesRequest deleteIdentitiesRequest) {
        if (deleteIdentitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteIdentitiesRequest)");
        }
        DefaultRequest<DeleteIdentitiesRequest> request = new DefaultRequest<DeleteIdentitiesRequest>(deleteIdentitiesRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.DeleteIdentities";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (deleteIdentitiesRequest.getIdentityIdsToDelete() != null) {
                List<String> identityIdsToDelete = deleteIdentitiesRequest.getIdentityIdsToDelete();
                jsonWriter.name("IdentityIdsToDelete");
                jsonWriter.beginArray();
                for (String identityIdsToDeleteItem : identityIdsToDelete) {
                    if (identityIdsToDeleteItem == null) continue;
                    jsonWriter.value(identityIdsToDeleteItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

