/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.logging;

import com.amazonaws.logging.AndroidLog;
import com.amazonaws.logging.ConsoleLog;
import com.amazonaws.logging.Environment;
import com.amazonaws.logging.Log;
import java.util.HashMap;
import java.util.Map;

public class LogFactory {
    private static final String TAG = LogFactory.class.getSimpleName();
    private static final Map<String, Log> logMap = new HashMap<String, Log>();
    private static Level globalLogLevel = null;

    public static synchronized Log getLog(Class<?> clazz) {
        return LogFactory.getLog(LogFactory.getTruncatedLogTag(clazz.getSimpleName()));
    }

    public static synchronized Log getLog(String logTag) {
        Log log = logMap.get(logTag = LogFactory.getTruncatedLogTag(logTag));
        if (log != null) {
            return log;
        }
        log = Environment.isJUnitTest() ? new ConsoleLog(logTag) : new AndroidLog(logTag);
        logMap.put(logTag, log);
        return log;
    }

    public static void setLevel(Level level) {
        globalLogLevel = level;
    }

    public static Level getLevel() {
        return globalLogLevel;
    }

    private static String getTruncatedLogTag(String logTag) {
        if (logTag.length() > 23) {
            LogFactory.getLog(TAG).warn("Truncating log tag length as it exceed 23, the limit imposed by Android on certain API Levels");
            logTag = logTag.substring(0, 23);
        }
        return logTag;
    }

    public static enum Level {
        ALL(Integer.MIN_VALUE),
        TRACE(0),
        DEBUG(1),
        INFO(2),
        WARN(3),
        ERROR(4),
        OFF(Integer.MAX_VALUE);

        private final int value;

        public int getValue() {
            return this.value;
        }

        private Level(int value) {
            this.value = value;
        }
    }
}

