/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public HttpRequest createHttpRequest(Request<?> request, ClientConfiguration clientConfiguration, ExecutionContext context) {
        String len;
        boolean putParamsInUri;
        URI endpoint = request.getEndpoint();
        String uri = HttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = HttpUtils.encodeParameters(request);
        boolean requestHasNoPayload = request.getContent() != null;
        boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (encodedParams != null && putParamsInUri) {
            uri = uri + "?" + encodedParams;
        }
        InputStream is = request.getContent();
        String method = request.getHttpMethod().toString();
        if (method.equals("POST") && request.getContent() == null && encodedParams != null) {
            is = new ByteArrayInputStream(encodedParams.getBytes(StringUtils.UTF8));
            request.addHeader("Content-Length", String.valueOf(encodedParams.length()));
        }
        if ((method.equals("POST") || method.equals("PUT")) && ((len = request.getHeaders().get("Content-Length")) == null || len.isEmpty())) {
            if (is != null) {
                throw new AmazonClientException("Unknown content-length");
            }
            request.addHeader("Content-Length", "0");
        }
        if (request.getHeaders().get("Accept-Encoding") == null) {
            request.addHeader("Accept-Encoding", "gzip");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.configureHeaders(headers, request, context, clientConfiguration);
        return new HttpRequest(method, URI.create(uri), headers, is);
    }

    private void configureHeaders(Map<String, String> headers, Request<?> request, ExecutionContext context, ClientConfiguration clientConfiguration) {
        URI endpoint = request.getEndpoint();
        String hostHeader = endpoint.getHost();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            hostHeader = hostHeader + ":" + endpoint.getPort();
        }
        headers.put("Host", hostHeader);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            headers.put(entry.getKey(), entry.getValue());
        }
        if (headers.get("Content-Type") == null || headers.get("Content-Type").isEmpty()) {
            headers.put("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        }
        if (context != null && context.getContextUserAgent() != null) {
            headers.put("User-Agent", this.createUserAgentString(clientConfiguration, context.getContextUserAgent()));
        }
    }

    private String createUserAgentString(ClientConfiguration clientConfiguration, String contextUserAgent) {
        if (clientConfiguration.getUserAgent().contains(contextUserAgent)) {
            return clientConfiguration.getUserAgent();
        }
        return clientConfiguration.getUserAgent() + " " + contextUserAgent;
    }
}

