/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class HttpRequest {
    private final String method;
    private URI uri;
    private final Map<String, String> headers;
    private final InputStream content;

    public HttpRequest(String method, URI uri) {
        this(method, uri, null, null);
    }

    public HttpRequest(String method, URI uri, Map<String, String> headers, InputStream content) {
        this.method = StringUtils.upperCase(method);
        this.uri = uri;
        this.headers = headers == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(headers);
        this.content = content;
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    void setUri(URI uri) {
        this.uri = uri;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public InputStream getContent() {
        return this.content;
    }

    public long getContentLength() {
        if (this.headers == null) {
            return 0L;
        }
        String len = this.headers.get("Content-Length");
        if (len == null || len.isEmpty()) {
            return 0L;
        }
        return Long.valueOf(len);
    }
}

