/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetSessionTokenRequestMarshaller
implements Marshaller<Request<GetSessionTokenRequest>, GetSessionTokenRequest> {
    @Override
    public Request<GetSessionTokenRequest> marshall(GetSessionTokenRequest getSessionTokenRequest) {
        String prefix;
        if (getSessionTokenRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSessionTokenRequest)");
        }
        DefaultRequest<GetSessionTokenRequest> request = new DefaultRequest<GetSessionTokenRequest>(getSessionTokenRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "GetSessionToken");
        request.addParameter("Version", "2011-06-15");
        if (getSessionTokenRequest.getDurationSeconds() != null) {
            prefix = "DurationSeconds";
            Integer durationSeconds = getSessionTokenRequest.getDurationSeconds();
            request.addParameter(prefix, StringUtils.fromInteger(durationSeconds));
        }
        if (getSessionTokenRequest.getSerialNumber() != null) {
            prefix = "SerialNumber";
            String serialNumber = getSessionTokenRequest.getSerialNumber();
            request.addParameter(prefix, StringUtils.fromString(serialNumber));
        }
        if (getSessionTokenRequest.getTokenCode() != null) {
            prefix = "TokenCode";
            String tokenCode = getSessionTokenRequest.getTokenCode();
            request.addParameter(prefix, StringUtils.fromString(tokenCode));
        }
        return request;
    }
}

