/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;
import com.amazonaws.util.json.AwsJsonToken;
import java.util.HashMap;
import java.util.Map;

public class MapUnmarshaller<V>
implements Unmarshaller<Map<String, V>, JsonUnmarshallerContext> {
    private final Unmarshaller<V, JsonUnmarshallerContext> valueUnmarshaller;

    public MapUnmarshaller(Unmarshaller<V, JsonUnmarshallerContext> valueUnmarshaller) {
        this.valueUnmarshaller = valueUnmarshaller;
    }

    @Override
    public Map<String, V> unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (reader.peek() == AwsJsonToken.VALUE_NULL) {
            reader.skipValue();
            return null;
        }
        HashMap<String, V> map = new HashMap<String, V>();
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            V v = this.valueUnmarshaller.unmarshall(context);
            map.put(key, v);
        }
        reader.endObject();
        return map;
    }
}

