/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.CognitoIdentityProvider;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.transform.CognitoIdentityProviderJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

public class CreateIdentityPoolRequestMarshaller
implements Marshaller<Request<CreateIdentityPoolRequest>, CreateIdentityPoolRequest> {
    @Override
    public Request<CreateIdentityPoolRequest> marshall(CreateIdentityPoolRequest createIdentityPoolRequest) {
        if (createIdentityPoolRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateIdentityPoolRequest)");
        }
        DefaultRequest<CreateIdentityPoolRequest> request = new DefaultRequest<CreateIdentityPoolRequest>(createIdentityPoolRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.CreateIdentityPool";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (createIdentityPoolRequest.getIdentityPoolName() != null) {
                String identityPoolName = createIdentityPoolRequest.getIdentityPoolName();
                jsonWriter.name("IdentityPoolName");
                jsonWriter.value(identityPoolName);
            }
            if (createIdentityPoolRequest.getAllowUnauthenticatedIdentities() != null) {
                Boolean allowUnauthenticatedIdentities = createIdentityPoolRequest.getAllowUnauthenticatedIdentities();
                jsonWriter.name("AllowUnauthenticatedIdentities");
                jsonWriter.value(allowUnauthenticatedIdentities);
            }
            if (createIdentityPoolRequest.getSupportedLoginProviders() != null) {
                Map<String, String> supportedLoginProviders = createIdentityPoolRequest.getSupportedLoginProviders();
                jsonWriter.name("SupportedLoginProviders");
                jsonWriter.beginObject();
                for (Map.Entry<String, String> supportedLoginProvidersEntry : supportedLoginProviders.entrySet()) {
                    String supportedLoginProvidersValue = supportedLoginProvidersEntry.getValue();
                    if (supportedLoginProvidersValue == null) continue;
                    jsonWriter.name(supportedLoginProvidersEntry.getKey());
                    jsonWriter.value(supportedLoginProvidersValue);
                }
                jsonWriter.endObject();
            }
            if (createIdentityPoolRequest.getDeveloperProviderName() != null) {
                String developerProviderName = createIdentityPoolRequest.getDeveloperProviderName();
                jsonWriter.name("DeveloperProviderName");
                jsonWriter.value(developerProviderName);
            }
            if (createIdentityPoolRequest.getOpenIdConnectProviderARNs() != null) {
                List<String> openIdConnectProviderARNs = createIdentityPoolRequest.getOpenIdConnectProviderARNs();
                jsonWriter.name("OpenIdConnectProviderARNs");
                jsonWriter.beginArray();
                for (String openIdConnectProviderARNsItem : openIdConnectProviderARNs) {
                    if (openIdConnectProviderARNsItem == null) continue;
                    jsonWriter.value(openIdConnectProviderARNsItem);
                }
                jsonWriter.endArray();
            }
            if (createIdentityPoolRequest.getCognitoIdentityProviders() != null) {
                List<CognitoIdentityProvider> cognitoIdentityProviders = createIdentityPoolRequest.getCognitoIdentityProviders();
                jsonWriter.name("CognitoIdentityProviders");
                jsonWriter.beginArray();
                for (CognitoIdentityProvider cognitoIdentityProvidersItem : cognitoIdentityProviders) {
                    if (cognitoIdentityProvidersItem == null) continue;
                    CognitoIdentityProviderJsonMarshaller.getInstance().marshall(cognitoIdentityProvidersItem, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createIdentityPoolRequest.getSamlProviderARNs() != null) {
                List<String> samlProviderARNs = createIdentityPoolRequest.getSamlProviderARNs();
                jsonWriter.name("SamlProviderARNs");
                jsonWriter.beginArray();
                for (String samlProviderARNsItem : samlProviderARNs) {
                    if (samlProviderARNsItem == null) continue;
                    jsonWriter.value(samlProviderARNsItem);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

