/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.type;

import com.amazonaws.com.fasterxml.jackson.core.type.TypeReference;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.type.ArrayType;
import com.amazonaws.com.fasterxml.jackson.databind.type.ClassKey;
import com.amazonaws.com.fasterxml.jackson.databind.type.CollectionType;
import com.amazonaws.com.fasterxml.jackson.databind.type.HierarchicType;
import com.amazonaws.com.fasterxml.jackson.databind.type.MapType;
import com.amazonaws.com.fasterxml.jackson.databind.type.SimpleType;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeBindings;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeModifier;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeParser;
import com.amazonaws.com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TypeFactory
implements Serializable {
    private static final JavaType[] NO_TYPES = new JavaType[0];
    protected static final TypeFactory instance = new TypeFactory();
    protected static final SimpleType CORE_TYPE_STRING = new SimpleType(String.class);
    protected static final SimpleType CORE_TYPE_BOOL = new SimpleType(Boolean.TYPE);
    protected static final SimpleType CORE_TYPE_INT = new SimpleType(Integer.TYPE);
    protected static final SimpleType CORE_TYPE_LONG = new SimpleType(Long.TYPE);
    protected final LRUMap<ClassKey, JavaType> _typeCache = new LRUMap(16, 100);
    protected transient HierarchicType _cachedHashMapType;
    protected transient HierarchicType _cachedArrayListType;
    protected final TypeModifier[] _modifiers = null;
    protected final TypeParser _parser = new TypeParser(this);

    private TypeFactory() {
    }

    public static TypeFactory defaultInstance() {
        return instance;
    }

    public static JavaType unknownType() {
        return TypeFactory.defaultInstance()._unknownType();
    }

    public JavaType constructSpecializedType(JavaType baseType, Class<?> subclass) {
        if (baseType instanceof SimpleType && (subclass.isArray() || Map.class.isAssignableFrom(subclass) || Collection.class.isAssignableFrom(subclass))) {
            if (!baseType.getRawClass().isAssignableFrom(subclass)) {
                throw new IllegalArgumentException("Class " + subclass.getClass().getName() + " not subtype of " + baseType);
            }
            JavaType subtype = this._fromClass(subclass, new TypeBindings(this, baseType.getRawClass()));
            Object h = baseType.getValueHandler();
            if (h != null) {
                subtype = subtype.withValueHandler(h);
            }
            if ((h = baseType.getTypeHandler()) != null) {
                subtype = subtype.withTypeHandler(h);
            }
            return subtype;
        }
        return baseType.narrowBy(subclass);
    }

    public JavaType constructFromCanonical(String canonical) throws IllegalArgumentException {
        return this._parser.parse(canonical);
    }

    public JavaType[] findTypeParameters(JavaType type, Class<?> expType) {
        Class<?> raw = type.getRawClass();
        if (raw == expType) {
            int count = type.containedTypeCount();
            if (count == 0) {
                return null;
            }
            JavaType[] result = new JavaType[count];
            for (int i = 0; i < count; ++i) {
                result[i] = type.containedType(i);
            }
            return result;
        }
        return this.findTypeParameters(raw, expType, new TypeBindings(this, type));
    }

    public JavaType[] findTypeParameters(Class<?> clz, Class<?> expType) {
        return this.findTypeParameters(clz, expType, new TypeBindings(this, clz));
    }

    public JavaType[] findTypeParameters(Class<?> clz, Class<?> expType, TypeBindings bindings) {
        HierarchicType subType = this._findSuperTypeChain(clz, expType);
        if (subType == null) {
            throw new IllegalArgumentException("Class " + clz.getName() + " is not a subtype of " + expType.getName());
        }
        HierarchicType superType = subType;
        while (superType.getSuperType() != null) {
            superType = superType.getSuperType();
            Class<?> raw = superType.getRawClass();
            TypeBindings newBindings = new TypeBindings(this, raw);
            if (superType.isGeneric()) {
                ParameterizedType pt = superType.asGeneric();
                Type[] actualTypes = pt.getActualTypeArguments();
                TypeVariable<Class<?>>[] vars = raw.getTypeParameters();
                int len = actualTypes.length;
                for (int i = 0; i < len; ++i) {
                    String name = vars[i].getName();
                    JavaType type = this._constructType(actualTypes[i], bindings);
                    newBindings.addBinding(name, type);
                }
            }
            bindings = newBindings;
        }
        if (!superType.isGeneric()) {
            return null;
        }
        return bindings.typesAsArray();
    }

    public JavaType constructType(Type type) {
        return this._constructType(type, null);
    }

    public JavaType constructType(Type type, TypeBindings bindings) {
        return this._constructType(type, bindings);
    }

    public JavaType constructType(TypeReference<?> typeRef) {
        return this._constructType(typeRef.getType(), null);
    }

    public JavaType _constructType(Type type, TypeBindings typeBindings) {
        JavaType javaType;
        if (type instanceof Class) {
            TypeModifier[] typeModifierArray = (TypeModifier[])type;
            javaType = this._fromClass((Class<?>)typeModifierArray, typeBindings);
        } else if (type instanceof ParameterizedType) {
            javaType = this._fromParamType((ParameterizedType)type, typeBindings);
        } else if (type instanceof GenericArrayType) {
            javaType = this._fromArrayType((GenericArrayType)type, typeBindings);
        } else if (type instanceof TypeVariable) {
            javaType = this._fromVariable((TypeVariable)type, typeBindings);
        } else if (type instanceof WildcardType) {
            javaType = this._fromWildcard((WildcardType)type, typeBindings);
        } else {
            throw new IllegalArgumentException("Unrecognized Type: " + (type == null ? "[null]" : type.toString()));
        }
        if (this._modifiers != null && !javaType.isContainerType()) {
            for (TypeModifier typeModifier : this._modifiers) {
                javaType = typeModifier.modifyType(javaType, type, typeBindings, this);
            }
        }
        return javaType;
    }

    public CollectionType constructCollectionType(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        return CollectionType.construct(collectionClass, this.constructType(elementClass));
    }

    public MapType constructMapType(Class<? extends Map> mapClass, Class<?> keyClass, Class<?> valueClass) {
        return MapType.construct(mapClass, this.constructType(keyClass), this.constructType(valueClass));
    }

    public JavaType constructSimpleType(Class<?> clazz, JavaType[] javaTypeArray) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Parameter type mismatch for " + clazz.getName() + ": expected " + typeVariableArray.length + " parameters, was given " + javaTypeArray.length);
        }
        String[] stringArray = new String[typeVariableArray.length];
        int n = typeVariableArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = typeVariableArray[i].getName();
        }
        SimpleType simpleType = new SimpleType(clazz, stringArray, javaTypeArray, null, null);
        return simpleType;
    }

    public JavaType uncheckedSimpleType(Class<?> cls) {
        return new SimpleType(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaType _fromClass(Class<?> clazz, TypeBindings typeBindings) {
        JavaType javaType;
        if (clazz == String.class) {
            return CORE_TYPE_STRING;
        }
        if (clazz == Boolean.TYPE) {
            return CORE_TYPE_BOOL;
        }
        if (clazz == Integer.TYPE) {
            return CORE_TYPE_INT;
        }
        if (clazz == Long.TYPE) {
            return CORE_TYPE_LONG;
        }
        ClassKey classKey = new ClassKey(clazz);
        LRUMap<ClassKey, JavaType> lRUMap = this._typeCache;
        synchronized (lRUMap) {
            javaType = (JavaType)this._typeCache.get(classKey);
        }
        if (javaType != null) {
            return javaType;
        }
        javaType = clazz.isArray() ? ArrayType.construct(this._constructType(clazz.getComponentType(), null), null, null) : (clazz.isEnum() ? new SimpleType(clazz) : (Map.class.isAssignableFrom(clazz) ? this._mapType(clazz) : (Collection.class.isAssignableFrom(clazz) ? this._collectionType(clazz) : new SimpleType(clazz))));
        lRUMap = this._typeCache;
        synchronized (lRUMap) {
            this._typeCache.put(classKey, javaType);
        }
        return javaType;
    }

    protected JavaType _fromParameterizedClass(Class<?> clz, List<JavaType> paramTypes) {
        if (clz.isArray()) {
            return ArrayType.construct(this._constructType(clz.getComponentType(), null), null, null);
        }
        if (clz.isEnum()) {
            return new SimpleType(clz);
        }
        if (Map.class.isAssignableFrom(clz)) {
            if (paramTypes.size() > 0) {
                JavaType keyType = paramTypes.get(0);
                JavaType contentType = paramTypes.size() >= 2 ? paramTypes.get(1) : this._unknownType();
                return MapType.construct(clz, keyType, contentType);
            }
            return this._mapType(clz);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            if (paramTypes.size() >= 1) {
                return CollectionType.construct(clz, paramTypes.get(0));
            }
            return this._collectionType(clz);
        }
        if (paramTypes.size() == 0) {
            return new SimpleType(clz);
        }
        JavaType[] pt = paramTypes.toArray(new JavaType[paramTypes.size()]);
        return this.constructSimpleType(clz, pt);
    }

    protected JavaType _fromParamType(ParameterizedType parameterizedType, TypeBindings typeBindings) {
        JavaType[] javaTypeArray;
        int n;
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n2 = n = typeArray == null ? 0 : typeArray.length;
        if (n == 0) {
            javaTypeArray = NO_TYPES;
        } else {
            javaTypeArray = new JavaType[n];
            for (int i = 0; i < n; ++i) {
                javaTypeArray[i] = this._constructType(typeArray[i], typeBindings);
            }
        }
        if (Map.class.isAssignableFrom(clazz)) {
            JavaType javaType = this.constructSimpleType(clazz, javaTypeArray);
            JavaType[] javaTypeArray2 = this.findTypeParameters(javaType, Map.class);
            if (javaTypeArray2.length != 2) {
                throw new IllegalArgumentException("Could not find 2 type parameters for Map class " + clazz.getName() + " (found " + javaTypeArray2.length + ")");
            }
            return MapType.construct(clazz, javaTypeArray2[0], javaTypeArray2[1]);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            JavaType javaType = this.constructSimpleType(clazz, javaTypeArray);
            JavaType[] javaTypeArray3 = this.findTypeParameters(javaType, Collection.class);
            if (javaTypeArray3.length != 1) {
                throw new IllegalArgumentException("Could not find 1 type parameter for Collection class " + clazz.getName() + " (found " + javaTypeArray3.length + ")");
            }
            return CollectionType.construct(clazz, javaTypeArray3[0]);
        }
        if (n == 0) {
            return new SimpleType(clazz);
        }
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    protected JavaType _fromArrayType(GenericArrayType type, TypeBindings context) {
        JavaType compType = this._constructType(type.getGenericComponentType(), context);
        return ArrayType.construct(compType, null, null);
    }

    protected JavaType _fromVariable(TypeVariable<?> type, TypeBindings context) {
        if (context == null) {
            return this._unknownType();
        }
        String name = type.getName();
        JavaType actualType = context.findType(name);
        if (actualType != null) {
            return actualType;
        }
        Type[] bounds = type.getBounds();
        context._addPlaceholder(name);
        return this._constructType(bounds[0], context);
    }

    protected JavaType _fromWildcard(WildcardType type, TypeBindings context) {
        return this._constructType(type.getUpperBounds()[0], context);
    }

    private JavaType _mapType(Class<?> clazz) {
        JavaType[] javaTypeArray = this.findTypeParameters(clazz, Map.class);
        if (javaTypeArray == null) {
            return MapType.construct(clazz, this._unknownType(), this._unknownType());
        }
        if (javaTypeArray.length != 2) {
            throw new IllegalArgumentException("Strange Map type " + clazz.getName() + ": can not determine type parameters");
        }
        return MapType.construct(clazz, javaTypeArray[0], javaTypeArray[1]);
    }

    private JavaType _collectionType(Class<?> clazz) {
        JavaType[] javaTypeArray = this.findTypeParameters(clazz, Collection.class);
        if (javaTypeArray == null) {
            return CollectionType.construct(clazz, this._unknownType());
        }
        if (javaTypeArray.length != 1) {
            throw new IllegalArgumentException("Strange Collection type " + clazz.getName() + ": can not determine type parameters");
        }
        return CollectionType.construct(clazz, javaTypeArray[0]);
    }

    protected JavaType _unknownType() {
        return new SimpleType(Object.class);
    }

    protected HierarchicType _findSuperTypeChain(Class<?> subtype, Class<?> supertype) {
        if (supertype.isInterface()) {
            return this._findSuperInterfaceChain(subtype, supertype);
        }
        return this._findSuperClassChain(subtype, supertype);
    }

    protected HierarchicType _findSuperClassChain(Type currentType, Class<?> target) {
        HierarchicType sup;
        HierarchicType current = new HierarchicType(currentType);
        Class<?> raw = current.getRawClass();
        if (raw == target) {
            return current;
        }
        Type parent = raw.getGenericSuperclass();
        if (parent != null && (sup = this._findSuperClassChain(parent, target)) != null) {
            sup.setSubType(current);
            current.setSuperType(sup);
            return current;
        }
        return null;
    }

    protected HierarchicType _findSuperInterfaceChain(Type type, Class<?> clazz) {
        HierarchicType hierarchicType = new HierarchicType(type);
        Class<?> clazz2 = hierarchicType.getRawClass();
        if (clazz2 == clazz) {
            return new HierarchicType(type);
        }
        if (clazz2 == HashMap.class && clazz == Map.class) {
            return this._hashMapSuperInterfaceChain(hierarchicType);
        }
        if (clazz2 == ArrayList.class && clazz == List.class) {
            return this._arrayListSuperInterfaceChain(hierarchicType);
        }
        return this._doFindSuperInterfaceChain(hierarchicType, clazz);
    }

    protected HierarchicType _doFindSuperInterfaceChain(HierarchicType current, Class<?> target) {
        HierarchicType sup;
        Type parent;
        Class<?> raw = current.getRawClass();
        Type[] parents = raw.getGenericInterfaces();
        if (parents != null) {
            for (Type parent2 : parents) {
                HierarchicType sup2 = this._findSuperInterfaceChain(parent2, target);
                if (sup2 == null) continue;
                sup2.setSubType(current);
                current.setSuperType(sup2);
                return current;
            }
        }
        if ((parent = raw.getGenericSuperclass()) != null && (sup = this._findSuperInterfaceChain(parent, target)) != null) {
            sup.setSubType(current);
            current.setSuperType(sup);
            return current;
        }
        return null;
    }

    protected synchronized HierarchicType _hashMapSuperInterfaceChain(HierarchicType current) {
        if (this._cachedHashMapType == null) {
            HierarchicType base = current.deepCloneWithoutSubtype();
            this._doFindSuperInterfaceChain(base, Map.class);
            this._cachedHashMapType = base.getSuperType();
        }
        HierarchicType t = this._cachedHashMapType.deepCloneWithoutSubtype();
        current.setSuperType(t);
        t.setSubType(current);
        return current;
    }

    protected synchronized HierarchicType _arrayListSuperInterfaceChain(HierarchicType hierarchicType) {
        HierarchicType hierarchicType2;
        if (this._cachedArrayListType == null) {
            hierarchicType2 = hierarchicType.deepCloneWithoutSubtype();
            this._doFindSuperInterfaceChain(hierarchicType2, List.class);
            this._cachedArrayListType = hierarchicType2.getSuperType();
        }
        hierarchicType2 = this._cachedArrayListType.deepCloneWithoutSubtype();
        hierarchicType.setSuperType(hierarchicType2);
        hierarchicType2.setSubType(hierarchicType);
        return hierarchicType;
    }
}

