/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.ser.std;

import com.amazonaws.com.fasterxml.jackson.annotation.JsonFormat;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> type, boolean useTimestamp, DateFormat customFormat) {
        super(type);
        this._useTimestamp = useTimestamp;
        this._customFormat = customFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        if (property != null && (format = prov.getAnnotationIntrospector().findFormat((Annotated)property.getMember())) != null) {
            if (format.getShape().isNumeric()) {
                return this.withFormat(true, null);
            }
            TimeZone tz = format.getTimeZone();
            String pattern = format.getPattern();
            if (pattern.length() > 0) {
                Locale loc = format.getLocale();
                if (loc == null) {
                    loc = prov.getLocale();
                }
                SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
                if (tz == null) {
                    tz = prov.getTimeZone();
                }
                df.setTimeZone(tz);
                return this.withFormat(false, df);
            }
            if (tz != null) {
                DateFormat df = prov.getConfig().getDateFormat();
                if (df.getClass() == StdDateFormat.class) {
                    df = StdDateFormat.getISO8601Format(tz);
                } else {
                    df = (DateFormat)df.clone();
                    df.setTimeZone(tz);
                }
                return this.withFormat(false, df);
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty(T value) {
        return value == null || this._timestamp(value) == 0L;
    }

    protected abstract long _timestamp(T var1);
}

