/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.node;

import com.amazonaws.com.fasterxml.jackson.databind.node.ArrayNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.BinaryNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.BooleanNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.DecimalNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.DoubleNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.IntNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.LongNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.NullNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.NumericNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.ObjectNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.POJONode;
import com.amazonaws.com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory
implements Serializable {
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    protected JsonNodeFactory(boolean bigDecimalExact) {
        this._cfgBigDecimalExact = bigDecimalExact;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    public NumericNode numberNode(BigInteger v) {
        return BigIntegerNode.valueOf(v);
    }

    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    public NumericNode numberNode(BigDecimal v) {
        return DecimalNode.valueOf(this._cfgBigDecimalExact ? v : v.stripTrailingZeros());
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public POJONode POJONode(Object pojo) {
        return new POJONode(pojo);
    }
}

