/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.jsontype.impl;

import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsArrayTypeSerializer
extends TypeSerializerBase {
    public AsArrayTypeSerializer(TypeIdResolver idRes, BeanProperty property) {
        super(idRes, property);
    }

    @Override
    public AsArrayTypeSerializer forProperty(BeanProperty prop) {
        if (this._property == prop) {
            return this;
        }
        return new AsArrayTypeSerializer(this._idResolver, prop);
    }

    @Override
    public void writeTypePrefixForObject(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeStartArray();
        jgen.writeString(this.idFromValue(value));
        jgen.writeStartObject();
    }

    @Override
    public void writeTypePrefixForArray(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeStartArray();
        jgen.writeString(this.idFromValue(value));
        jgen.writeStartArray();
    }

    @Override
    public void writeTypePrefixForScalar(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeStartArray();
        jgen.writeString(this.idFromValue(value));
    }

    @Override
    public void writeTypePrefixForScalar(Object value, JsonGenerator jgen, Class<?> type) throws IOException, JsonProcessingException {
        jgen.writeStartArray();
        jgen.writeString(this.idFromValueAndType(value, type));
    }

    @Override
    public void writeTypeSuffixForObject(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeEndObject();
        jgen.writeEndArray();
    }

    @Override
    public void writeTypeSuffixForArray(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeEndArray();
        jgen.writeEndArray();
    }

    @Override
    public void writeTypeSuffixForScalar(Object value, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeEndArray();
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value, JsonGenerator jgen, String typeId) throws IOException, JsonProcessingException {
        jgen.writeStartArray();
        jgen.writeString(typeId);
        jgen.writeStartObject();
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value, JsonGenerator jgen, String typeId) throws IOException, JsonProcessingException {
        this.writeTypeSuffixForObject(value, jgen);
    }
}

