/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser;

import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.MapperFeature;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BuilderBasedDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.util.Annotations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BeanDeserializerBuilder {
    protected final BeanDescription _beanDesc;
    protected final boolean _defaultViewInclusion;
    protected final Map<String, SettableBeanProperty> _properties = new LinkedHashMap<String, SettableBeanProperty>();
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder.Value _builderConfig;

    public BeanDeserializerBuilder(BeanDescription beanDesc, DeserializationConfig config) {
        this._beanDesc = beanDesc;
        this._defaultViewInclusion = config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
    }

    public void addOrReplaceProperty(SettableBeanProperty prop, boolean allowOverride) {
        this._properties.put(prop.getName(), prop);
    }

    public void addProperty(SettableBeanProperty prop) {
        SettableBeanProperty old = this._properties.put(prop.getName(), prop);
        if (old != null && old != prop) {
            throw new IllegalArgumentException("Duplicate property '" + prop.getName() + "' for " + this._beanDesc.getType());
        }
    }

    public void addBackReferenceProperty(String referenceName, SettableBeanProperty prop) {
        if (this._backRefProperties == null) {
            this._backRefProperties = new HashMap(4);
        }
        this._backRefProperties.put(referenceName, prop);
        if (this._properties != null) {
            this._properties.remove(prop.getName());
        }
    }

    public void addInjectable(String propertyName, JavaType propertyType, Annotations contextAnnotations, AnnotatedMember member, Object valueId) {
        if (this._injectables == null) {
            this._injectables = new ArrayList<ValueInjector>();
        }
        this._injectables.add(new ValueInjector(propertyName, propertyType, contextAnnotations, member, valueId));
    }

    public void addIgnorable(String propName) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(propName);
    }

    public void addCreatorProperty(SettableBeanProperty prop) {
        this.addProperty(prop);
    }

    public void setAnySetter(SettableAnyProperty s) {
        if (this._anySetter != null && s != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = s;
    }

    public void setIgnoreUnknownProperties(boolean ignore) {
        this._ignoreAllUnknown = ignore;
    }

    public void setValueInstantiator(ValueInstantiator inst) {
        this._valueInstantiator = inst;
    }

    public void setObjectIdReader(ObjectIdReader r) {
        this._objectIdReader = r;
    }

    public void setPOJOBuilder(AnnotatedMethod buildMethod, JsonPOJOBuilder.Value config) {
        this._buildMethod = buildMethod;
        this._builderConfig = config;
    }

    public SettableBeanProperty findProperty(String propertyName) {
        return this._properties.get(propertyName);
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public BeanDeserializer build() {
        boolean anyViews;
        Collection<SettableBeanProperty> props = this._properties.values();
        BeanPropertyMap propertyMap = new BeanPropertyMap(props);
        propertyMap.assignIndexes();
        boolean bl = anyViews = !this._defaultViewInclusion;
        if (!anyViews) {
            for (SettableBeanProperty prop : props) {
                if (!prop.hasViews()) continue;
                anyViews = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty prop = new ObjectIdValueProperty(this._objectIdReader);
            propertyMap = propertyMap.withProperty(prop);
        }
        return new BeanDeserializer(this, this._beanDesc, propertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, anyViews);
    }

    public AbstractDeserializer buildAbstract() {
        return new AbstractDeserializer(this, this._beanDesc, this._backRefProperties);
    }

    public JsonDeserializer<?> buildBuilderBased(JavaType javaType, String string) {
        boolean bl;
        if (this._buildMethod == null) {
            throw new IllegalArgumentException("Builder class " + this._beanDesc.getBeanClass().getName() + " does not have build method '" + string + "()'");
        }
        Class<?> clazz = this._buildMethod.getRawReturnType();
        if (!javaType.getRawClass().isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Build method '" + this._buildMethod.getFullName() + " has bad return type (" + clazz.getName() + "), not compatible with POJO type (" + javaType.getRawClass().getName() + ")");
        }
        Collection<SettableBeanProperty> collection = this._properties.values();
        BeanPropertyMap beanPropertyMap = new BeanPropertyMap(collection);
        beanPropertyMap.assignIndexes();
        boolean bl2 = bl = !this._defaultViewInclusion;
        if (!bl) {
            for (SettableBeanProperty settableBeanProperty : collection) {
                if (!settableBeanProperty.hasViews()) continue;
                bl = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty objectIdValueProperty = new ObjectIdValueProperty(this._objectIdReader);
            beanPropertyMap = beanPropertyMap.withProperty(objectIdValueProperty);
        }
        return new BuilderBasedDeserializer(this, this._beanDesc, beanPropertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, bl);
    }
}

