/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser;

import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.BeanAsArrayDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.amazonaws.com.fasterxml.jackson.databind.util.NameTransformer;
import com.amazonaws.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;

public class BeanDeserializer
extends BeanDeserializerBase
implements Serializable {
    public BeanDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, HashSet<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        super(builder, beanDesc, properties, backRefs, ignorableProps, ignoreAllUnknown, hasViews);
    }

    protected BeanDeserializer(BeanDeserializerBase src) {
        super(src, src._ignoreAllUnknown);
    }

    protected BeanDeserializer(BeanDeserializerBase src, boolean ignoreAllUnknown) {
        super(src, ignoreAllUnknown);
    }

    protected BeanDeserializer(BeanDeserializerBase src, NameTransformer unwrapper) {
        super(src, unwrapper);
    }

    public BeanDeserializer(BeanDeserializerBase src, ObjectIdReader oir) {
        super(src, oir);
    }

    public BeanDeserializer(BeanDeserializerBase src, HashSet<String> ignorableProps) {
        super(src, ignorableProps);
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        if (this.getClass() != BeanDeserializer.class) {
            return this;
        }
        return new BeanDeserializer((BeanDeserializerBase)this, unwrapper);
    }

    @Override
    public BeanDeserializer withObjectIdReader(ObjectIdReader oir) {
        return new BeanDeserializer((BeanDeserializerBase)this, oir);
    }

    @Override
    public BeanDeserializer withIgnorableProperties(HashSet<String> ignorableProps) {
        return new BeanDeserializer((BeanDeserializerBase)this, ignorableProps);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] props = this._beanProperties.getPropertiesInInsertionOrder();
        return new BeanAsArrayDeserializer((BeanDeserializerBase)this, props);
    }

    @Override
    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
            if (this._vanillaProcessing) {
                return this.vanillaDeserialize(jp, ctxt, t);
            }
            if (this._objectIdReader != null) {
                return this.deserializeWithObjectId(jp, ctxt);
            }
            return this.deserializeFromObject(jp, ctxt);
        }
        if (t == null) {
            return this._missingToken(jp, ctxt);
        }
        switch (t) {
            case VALUE_STRING: {
                return this.deserializeFromString(jp, ctxt);
            }
            case VALUE_NUMBER_INT: {
                return this.deserializeFromNumber(jp, ctxt);
            }
            case VALUE_NUMBER_FLOAT: {
                return this.deserializeFromDouble(jp, ctxt);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return jp.getEmbeddedObject();
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return this.deserializeFromBoolean(jp, ctxt);
            }
            case START_ARRAY: {
                return this.deserializeFromArray(jp, ctxt);
            }
            case FIELD_NAME: 
            case END_OBJECT: {
                if (this._vanillaProcessing) {
                    return this.vanillaDeserialize(jp, ctxt, t);
                }
                if (this._objectIdReader != null) {
                    return this.deserializeWithObjectId(jp, ctxt);
                }
                return this.deserializeFromObject(jp, ctxt);
            }
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    private Object _missingToken(JsonParser jp, DeserializationContext ctxt) throws JsonProcessingException {
        throw ctxt.endOfInputException(this.getBeanClass());
    }

    @Override
    public Object deserialize(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        Class<?> view;
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(jp, ctxt, bean);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jp, ctxt, bean);
        }
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(jp, ctxt, bean, view);
        }
        while (t == JsonToken.FIELD_NAME) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    prop.deserializeAndSet(jp, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, propName, ctxt);
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                jp.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
            } else {
                this.handleUnknownProperty(jp, ctxt, bean, propName);
            }
            t = jp.nextToken();
        }
        return bean;
    }

    private final Object vanillaDeserialize(JsonParser jp, DeserializationContext ctxt, JsonToken t) throws IOException, JsonProcessingException {
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    prop.deserializeAndSet(jp, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, propName, ctxt);
                }
            } else {
                this._vanillaDeserializeHandleUnknown(jp, ctxt, bean, propName);
            }
            jp.nextToken();
        }
        return bean;
    }

    private final void _vanillaDeserializeHandleUnknown(JsonParser jp, DeserializationContext ctxt, Object bean, String propName) throws IOException, JsonProcessingException {
        if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
            jp.skipChildren();
        } else if (this._anySetter != null) {
            try {
                this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, propName, ctxt);
            }
        } else {
            this.handleUnknownProperty(jp, ctxt, bean, propName);
        }
    }

    public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Class<?> view;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jp, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jp, ctxt);
            }
            return this.deserializeFromObjectUsingNonDefault(jp, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(jp, ctxt, bean, view);
        }
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    prop.deserializeAndSet(jp, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, propName, ctxt);
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                jp.skipChildren();
            } else if (this._anySetter != null) {
                try {
                    this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, bean, propName, ctxt);
                }
            } else {
                this.handleUnknownProperty(jp, ctxt, bean, propName);
            }
            jp.nextToken();
        }
        return bean;
    }

    protected Object deserializeWithObjectId(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String idPropName = this._objectIdReader.propertyName;
        if (idPropName.equals(jp.getCurrentName())) {
            return this.deserializeFromObject(jp, ctxt);
        }
        TokenBuffer tmpBuffer = new TokenBuffer(jp.getCodec());
        TokenBuffer mergedBuffer = null;
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            if (mergedBuffer == null) {
                if (idPropName.equals(propName)) {
                    mergedBuffer = new TokenBuffer(jp.getCodec());
                    mergedBuffer.writeFieldName(propName);
                    jp.nextToken();
                    mergedBuffer.copyCurrentStructure(jp);
                    mergedBuffer.append(tmpBuffer);
                    tmpBuffer = null;
                } else {
                    tmpBuffer.writeFieldName(propName);
                    jp.nextToken();
                    tmpBuffer.copyCurrentStructure(jp);
                }
            } else {
                mergedBuffer.writeFieldName(propName);
                jp.nextToken();
                mergedBuffer.copyCurrentStructure(jp);
            }
            jp.nextToken();
        }
        TokenBuffer buffer = mergedBuffer == null ? tmpBuffer : mergedBuffer;
        buffer.writeEndObject();
        JsonParser mergedParser = buffer.asParser();
        mergedParser.nextToken();
        return this.deserializeFromObject(mergedParser, ctxt);
    }

    protected Object deserializeFromObjectUsingNonDefault(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(jsonParser, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        throw JsonMappingException.from(jsonParser, "No suitable constructor found for type " + this._beanType + ": can not instantiate from JSON object (need to add/enable type information?)");
    }

    public Object deserializeFromString(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId(jp, ctxt);
        }
        if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromString()) {
            Object bean = this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(jp, ctxt));
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        return this._valueInstantiator.createFromString(ctxt, jp.getText());
    }

    public Object deserializeFromNumber(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        switch (jsonParser.getNumberType()) {
            case INT: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromInt(deserializationContext, jsonParser.getIntValue());
            }
            case LONG: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromLong(deserializationContext, jsonParser.getLongValue());
            }
        }
        if (this._delegateDeserializer != null) {
            Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        throw deserializationContext.instantiationException(this.getBeanClass(), "no suitable creator method found to deserialize from JSON integer number");
    }

    public Object deserializeFromDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        switch (jsonParser.getNumberType()) {
            case FLOAT: 
            case DOUBLE: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromDouble()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromDouble(deserializationContext, jsonParser.getDoubleValue());
            }
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        throw deserializationContext.instantiationException(this.getBeanClass(), "no suitable creator method found to deserialize from JSON floating-point number");
    }

    public Object deserializeFromBoolean(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromBoolean()) {
            Object bean = this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(jp, ctxt));
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        boolean value = jp.getCurrentToken() == JsonToken.VALUE_TRUE;
        return this._valueInstantiator.createFromBoolean(ctxt, value);
    }

    public Object deserializeFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null) {
            try {
                Object bean = this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(jp, ctxt));
                if (this._injectables != null) {
                    this.injectValues(ctxt, bean);
                }
                return bean;
            }
            catch (Exception e) {
                this.wrapInstantiationProblem(e, ctxt);
            }
        }
        throw ctxt.mappingException(this.getBeanClass());
    }

    protected final Object _deserializeUsingPropertyBased(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object bean;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer = creator.startBuilding(jp, ctxt, this._objectIdReader);
        TokenBuffer unknown = null;
        JsonToken t = jp.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (creatorProp != null) {
                Object value = creatorProp.deserialize(jp, ctxt);
                if (buffer.assignParameter(creatorProp.getCreatorIndex(), value)) {
                    Object bean2;
                    jp.nextToken();
                    try {
                        bean2 = creator.build(ctxt, buffer);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, this._beanType.getRawClass(), propName, ctxt);
                        bean2 = null;
                    }
                    if (bean2.getClass() != this._beanType.getRawClass()) {
                        return this.handlePolymorphic(jp, ctxt, bean2, unknown);
                    }
                    if (unknown != null) {
                        bean2 = this.handleUnknownProperties(ctxt, bean2, unknown);
                    }
                    return this.deserialize(jp, ctxt, bean2);
                }
            } else if (!buffer.readIdProperty(propName)) {
                SettableBeanProperty prop = this._beanProperties.find(propName);
                if (prop != null) {
                    buffer.bufferProperty(prop, prop.deserialize(jp, ctxt));
                } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    jp.skipChildren();
                } else if (this._anySetter != null) {
                    buffer.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(jp, ctxt));
                } else {
                    if (unknown == null) {
                        unknown = new TokenBuffer(jp.getCodec());
                    }
                    unknown.writeFieldName(propName);
                    unknown.copyCurrentStructure(jp);
                }
            }
            t = jp.nextToken();
        }
        try {
            bean = creator.build(ctxt, buffer);
        }
        catch (Exception e) {
            this.wrapInstantiationProblem(e, ctxt);
            bean = null;
        }
        if (unknown != null) {
            if (bean.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, bean, unknown);
            }
            return this.handleUnknownProperties(ctxt, bean, unknown);
        }
        return bean;
    }

    protected Object handlePolymorphic(JsonParser jp, DeserializationContext ctxt, Object bean, TokenBuffer unknownTokens) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> subDeser = this._findSubclassDeserializer(ctxt, bean, unknownTokens);
        if (subDeser != null) {
            if (unknownTokens != null) {
                unknownTokens.writeEndObject();
                JsonParser p2 = unknownTokens.asParser();
                p2.nextToken();
                bean = subDeser.deserialize(p2, ctxt, bean);
            }
            if (jp != null) {
                bean = subDeser.deserialize(jp, ctxt, bean);
            }
            return bean;
        }
        if (unknownTokens != null) {
            bean = this.handleUnknownProperties(ctxt, bean, unknownTokens);
        }
        if (jp != null) {
            bean = this.deserialize(jp, ctxt, bean);
        }
        return bean;
    }

    protected final Object deserializeWithView(JsonParser jp, DeserializationContext ctxt, Object bean, Class<?> activeView) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (!prop.visibleInView(activeView)) {
                    jp.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(jp, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                jp.skipChildren();
            } else if (this._anySetter != null) {
                this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
            } else {
                this.handleUnknownProperty(jp, ctxt, bean, propName);
            }
            t = jp.nextToken();
        }
        return bean;
    }

    protected Object deserializeWithUnwrapped(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Class<?> activeView;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(jp, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(jp, ctxt);
        }
        TokenBuffer tokens = new TokenBuffer(jp.getCodec());
        tokens.writeStartObject();
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    jp.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(jp, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                jp.skipChildren();
            } else {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(jp);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            }
            jp.nextToken();
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jp, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeWithUnwrapped(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        Class<?> activeView;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        TokenBuffer tokens = new TokenBuffer(jp.getCodec());
        tokens.writeStartObject();
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (t == JsonToken.FIELD_NAME) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            jp.nextToken();
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    jp.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(jp, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                jp.skipChildren();
            } else {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(jp);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                }
            }
            t = jp.nextToken();
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(jp, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block16: {
                Object object2;
                object = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
                if (settableBeanProperty != null) {
                    object2 = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                    if (propertyValueBuffer.assignParameter(settableBeanProperty.getCreatorIndex(), object2)) {
                        Object object3;
                        jsonToken = jsonParser.nextToken();
                        try {
                            object3 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            this.wrapAndThrow(exception, this._beanType.getRawClass(), (String)object, deserializationContext);
                            break block16;
                        }
                        while (jsonToken == JsonToken.FIELD_NAME) {
                            jsonParser.nextToken();
                            tokenBuffer.copyCurrentStructure(jsonParser);
                            jsonToken = jsonParser.nextToken();
                        }
                        tokenBuffer.writeEndObject();
                        if (object3.getClass() != this._beanType.getRawClass()) {
                            tokenBuffer.close();
                            throw deserializationContext.mappingException("Can not create polymorphic instances with unwrapped values");
                        }
                        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object3, tokenBuffer);
                    }
                } else if (!propertyValueBuffer.readIdProperty((String)object)) {
                    object2 = this._beanProperties.find((String)object);
                    if (object2 != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object2, ((SettableBeanProperty)object2).deserialize(jsonParser, deserializationContext));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(object)) {
                        jsonParser.skipChildren();
                    } else {
                        tokenBuffer.writeFieldName((String)object);
                        tokenBuffer.copyCurrentStructure(jsonParser);
                        if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, (String)object, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
        return this._unwrappedPropertyHandler.processUnwrapped(jsonParser, deserializationContext, object, tokenBuffer);
    }

    protected Object deserializeWithExternalTypeId(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(jp, ctxt);
        }
        return this.deserializeWithExternalTypeId(jp, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (jp.getCurrentToken().isScalarValue()) {
                    ext.handleTypePropertyValue(jp, ctxt, propName, bean);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    jp.skipChildren();
                } else {
                    try {
                        prop.deserializeAndSet(jp, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                jp.skipChildren();
            } else if (!ext.handlePropertyValue(jp, ctxt, propName, bean)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(jp, ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, bean, propName, ctxt);
                    }
                } else {
                    this.handleUnknownProperty(jp, ctxt, bean, propName);
                }
            }
            jp.nextToken();
        }
        return ext.complete(jp, ctxt, bean);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ExternalTypeHandler externalTypeHandler = this._externalTypeIdHandler.start();
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartObject();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        while (jsonToken == JsonToken.FIELD_NAME) {
            block18: {
                Object object;
                String string = jsonParser.getCurrentName();
                jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                if (settableBeanProperty != null) {
                    if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, propertyValueBuffer)) {
                        object = settableBeanProperty.deserialize(jsonParser, deserializationContext);
                        if (propertyValueBuffer.assignParameter(settableBeanProperty.getCreatorIndex(), object)) {
                            Object object2;
                            jsonToken = jsonParser.nextToken();
                            try {
                                object2 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow(exception, this._beanType.getRawClass(), string, deserializationContext);
                                break block18;
                            }
                            while (jsonToken == JsonToken.FIELD_NAME) {
                                jsonParser.nextToken();
                                tokenBuffer.copyCurrentStructure(jsonParser);
                                jsonToken = jsonParser.nextToken();
                            }
                            if (object2.getClass() != this._beanType.getRawClass()) {
                                throw deserializationContext.mappingException("Can not create polymorphic instances with unwrapped values");
                            }
                            return externalTypeHandler.complete(jsonParser, deserializationContext, object2);
                        }
                    }
                } else if (!propertyValueBuffer.readIdProperty(string)) {
                    object = this._beanProperties.find(string);
                    if (object != null) {
                        propertyValueBuffer.bufferProperty((SettableBeanProperty)object, ((SettableBeanProperty)object).deserialize(jsonParser, deserializationContext));
                    } else if (!externalTypeHandler.handlePropertyValue(jsonParser, deserializationContext, string, null)) {
                        if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
                            jsonParser.skipChildren();
                        } else if (this._anySetter != null) {
                            propertyValueBuffer.bufferAnyProperty(this._anySetter, string, this._anySetter.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            jsonToken = jsonParser.nextToken();
        }
        try {
            return externalTypeHandler.complete(jsonParser, deserializationContext, propertyValueBuffer, propertyBasedCreator);
        }
        catch (Exception exception) {
            this.wrapInstantiationProblem(exception, deserializationContext);
            return null;
        }
    }
}

