/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthCheckInputStream
extends SdkFilterInputStream {
    public static final boolean INCLUDE_SKIPPED_BYTES = true;
    public static final boolean EXCLUDE_SKIPPED_BYTES = false;
    private final long expectedLength;
    private final boolean includeSkipped;
    private long dataLength;
    private long marked;

    public LengthCheckInputStream(InputStream inputStream, long l, boolean bl) {
        super(inputStream);
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        this.expectedLength = l;
        this.includeSkipped = bl;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n >= 0) {
            ++this.dataLength;
        }
        this.checkLength(n == -1);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        this.dataLength += n3 >= 0 ? (long)n3 : 0L;
        this.checkLength(n3 == -1);
        return n3;
    }

    @Override
    public void mark(int n) {
        super.mark(n);
        this.marked = this.dataLength;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        if (super.markSupported()) {
            this.dataLength = this.marked;
        }
    }

    private void checkLength(boolean bl) {
        if (bl) {
            if (this.dataLength != this.expectedLength) {
                throw new AmazonClientException("Data read (" + this.dataLength + ") has a different length than the expected (" + this.expectedLength + ")");
            }
        } else if (this.dataLength > this.expectedLength) {
            throw new AmazonClientException("More data read (" + this.dataLength + ") than expected (" + this.expectedLength + ")");
        }
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (this.includeSkipped && l2 > 0L) {
            this.dataLength += l2;
            this.checkLength(false);
        }
        return l2;
    }
}

