/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.org.apache.commons.logging.LogFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AwsHostNameUtils {
    private static final Pattern S3_ENDPOINT_PATTERN = Pattern.compile("^(?:.+\\.)?s3[.-]([a-z0-9-]+)$");

    @Deprecated
    public static String parseRegionName(URI uRI) {
        return AwsHostNameUtils.parseRegionName(uRI.getHost(), null);
    }

    public static String parseRegionName(String string, String string2) {
        Pattern pattern;
        Matcher matcher;
        if (string.endsWith(".amazonaws.com")) {
            int n = string.length() - ".amazonaws.com".length();
            return AwsHostNameUtils.parseStandardRegionName(string.substring(0, n));
        }
        if (string2 != null && (matcher = (pattern = Pattern.compile("^(?:.+\\.)?" + Pattern.quote(string2) + "[.-]([a-z0-9-]+)\\.")).matcher(string)).find()) {
            return matcher.group(1);
        }
        return "us-east-1";
    }

    private static String parseStandardRegionName(String string) {
        if (string.endsWith(".s3") || string.endsWith(".s3-external-1")) {
            return "us-east-1";
        }
        Matcher matcher = S3_ENDPOINT_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "us-east-1";
        }
        String string2 = string.substring(n + 1);
        if ("us-gov".equals(string2)) {
            string2 = "us-gov-west-1";
        }
        return string2;
    }

    @Deprecated
    public static String parseServiceName(URI uRI) {
        String string = uRI.getHost();
        if (!string.endsWith(".amazonaws.com")) {
            throw new IllegalArgumentException("Cannot parse a service name from an unrecognized endpoint (" + string + ").");
        }
        String string2 = string.substring(0, string.indexOf(".amazonaws.com"));
        if (string2.endsWith(".s3") || S3_ENDPOINT_PATTERN.matcher(string2).matches()) {
            return "s3";
        }
        int n = 46;
        if (string2.indexOf(n) == -1) {
            return string2;
        }
        String string3 = string2.substring(0, string2.indexOf(n));
        return string3;
    }

    public static String localHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (Exception exception) {
            LogFactory.getLog(AwsHostNameUtils.class).debug("Failed to determine the local hostname; fall back to use \"localhost\".", exception);
            return "localhost";
        }
    }
}

