/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;

public class SimpleTypeStaxUnmarshallers {
    private static Log log = LogFactory.getLog(SimpleTypeStaxUnmarshallers.class);

    public static class ByteBufferStaxUnmarshaller
    implements Unmarshaller<ByteBuffer, StaxUnmarshallerContext> {
        private static ByteBufferStaxUnmarshaller instance;

        @Override
        public ByteBuffer unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            byte[] byArray = Base64.decode(string);
            return ByteBuffer.wrap(byArray);
        }

        public static ByteBufferStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new ByteBufferStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class DateStaxUnmarshaller
    implements Unmarshaller<Date, StaxUnmarshallerContext> {
        private static DateStaxUnmarshaller instance;

        @Override
        public Date unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            if (string == null) {
                return null;
            }
            try {
                return DateUtils.parseISO8601Date(string);
            }
            catch (Exception exception) {
                log.warn("Unable to parse date '" + string + "':  " + exception.getMessage(), exception);
                return null;
            }
        }

        public static DateStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new DateStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class ByteStaxUnmarshaller
    implements Unmarshaller<Byte, StaxUnmarshallerContext> {
        private static ByteStaxUnmarshaller instance;

        @Override
        public Byte unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Byte.valueOf(string);
        }

        public static ByteStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new ByteStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class LongStaxUnmarshaller
    implements Unmarshaller<Long, StaxUnmarshallerContext> {
        private static LongStaxUnmarshaller instance;

        @Override
        public Long unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Long.valueOf(Long.parseLong(string));
        }

        public static LongStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new LongStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class FloatStaxUnmarshaller
    implements Unmarshaller<Float, StaxUnmarshallerContext> {
        private static FloatStaxUnmarshaller instance;

        @Override
        public Float unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Float.valueOf(string);
        }

        public static FloatStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new FloatStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class BooleanStaxUnmarshaller
    implements Unmarshaller<Boolean, StaxUnmarshallerContext> {
        private static BooleanStaxUnmarshaller instance;

        @Override
        public Boolean unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Boolean.valueOf(Boolean.parseBoolean(string));
        }

        public static BooleanStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new BooleanStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class IntegerStaxUnmarshaller
    implements Unmarshaller<Integer, StaxUnmarshallerContext> {
        private static IntegerStaxUnmarshaller instance;

        @Override
        public Integer unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Integer.valueOf(Integer.parseInt(string));
        }

        public static IntegerStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new IntegerStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class DoubleStaxUnmarshaller
    implements Unmarshaller<Double, StaxUnmarshallerContext> {
        private static DoubleStaxUnmarshaller instance;

        @Override
        public Double unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Double.valueOf(Double.parseDouble(string));
        }

        public static DoubleStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new DoubleStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class BigIntegerStaxUnmarshaller
    implements Unmarshaller<BigInteger, StaxUnmarshallerContext> {
        private static BigIntegerStaxUnmarshaller instance;

        @Override
        public BigInteger unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : new BigInteger(string);
        }

        public static BigIntegerStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new BigIntegerStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class BigDecimalStaxUnmarshaller
    implements Unmarshaller<BigDecimal, StaxUnmarshallerContext> {
        private static BigDecimalStaxUnmarshaller instance;

        @Override
        public BigDecimal unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : new BigDecimal(string);
        }

        public static BigDecimalStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new BigDecimalStaxUnmarshaller();
            }
            return instance;
        }
    }

    public static class StringStaxUnmarshaller
    implements Unmarshaller<String, StaxUnmarshallerContext> {
        private static StringStaxUnmarshaller instance;

        @Override
        public String unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            return staxUnmarshallerContext.readText();
        }

        public static StringStaxUnmarshaller getInstance() {
            if (instance == null) {
                instance = new StringStaxUnmarshaller();
            }
            return instance;
        }
    }
}

