/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;

public class ListUnmarshaller<T>
implements Unmarshaller<List<T>, JsonUnmarshallerContext> {
    private final Unmarshaller<T, JsonUnmarshallerContext> itemUnmarshaller;

    public ListUnmarshaller(Unmarshaller<T, JsonUnmarshallerContext> unmarshaller) {
        this.itemUnmarshaller = unmarshaller;
    }

    @Override
    public List<T> unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
        ArrayList<T> arrayList = new ArrayList<T>();
        int n = jsonUnmarshallerContext.getCurrentDepth();
        if (jsonUnmarshallerContext.currentToken == JsonToken.VALUE_NULL) {
            return null;
        }
        JsonToken jsonToken;
        while ((jsonToken = jsonUnmarshallerContext.nextToken()) != null) {
            if (jsonToken == JsonToken.START_ARRAY) continue;
            if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                if (jsonUnmarshallerContext.getCurrentDepth() >= n) continue;
                return arrayList;
            }
            arrayList.add(this.itemUnmarshaller.unmarshall(jsonUnmarshallerContext));
        }
        return arrayList;
    }
}

