/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitoidentity.model.IdentityDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIdentitiesResult
implements Serializable {
    private String identityPoolId;
    private ListWithAutoConstructFlag<IdentityDescription> identities;
    private String nextToken;

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public void setIdentityPoolId(String string) {
        this.identityPoolId = string;
    }

    public ListIdentitiesResult withIdentityPoolId(String string) {
        this.identityPoolId = string;
        return this;
    }

    public List<IdentityDescription> getIdentities() {
        if (this.identities == null) {
            this.identities = new ListWithAutoConstructFlag();
            this.identities.setAutoConstruct(true);
        }
        return this.identities;
    }

    public void setIdentities(Collection<IdentityDescription> collection) {
        if (collection == null) {
            this.identities = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.identities = listWithAutoConstructFlag;
    }

    public ListIdentitiesResult withIdentities(IdentityDescription ... identityDescriptionArray) {
        if (this.getIdentities() == null) {
            this.setIdentities(new ArrayList<IdentityDescription>(identityDescriptionArray.length));
        }
        for (IdentityDescription identityDescription : identityDescriptionArray) {
            this.getIdentities().add(identityDescription);
        }
        return this;
    }

    public ListIdentitiesResult withIdentities(Collection<IdentityDescription> collection) {
        if (collection == null) {
            this.identities = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.identities = listWithAutoConstructFlag;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String string) {
        this.nextToken = string;
    }

    public ListIdentitiesResult withNextToken(String string) {
        this.nextToken = string;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIdentityPoolId() != null) {
            stringBuilder.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentities() != null) {
            stringBuilder.append("Identities: " + this.getIdentities() + ",");
        }
        if (this.getNextToken() != null) {
            stringBuilder.append("NextToken: " + this.getNextToken());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        n = 31 * n + (this.getIdentities() == null ? 0 : ((Object)this.getIdentities()).hashCode());
        n = 31 * n + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ListIdentitiesResult)) {
            return false;
        }
        ListIdentitiesResult listIdentitiesResult = (ListIdentitiesResult)object;
        if (listIdentitiesResult.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (listIdentitiesResult.getIdentityPoolId() != null && !listIdentitiesResult.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (listIdentitiesResult.getIdentities() == null ^ this.getIdentities() == null) {
            return false;
        }
        if (listIdentitiesResult.getIdentities() != null && !((Object)listIdentitiesResult.getIdentities()).equals(this.getIdentities())) {
            return false;
        }
        if (listIdentitiesResult.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return listIdentitiesResult.getNextToken() == null || listIdentitiesResult.getNextToken().equals(this.getNextToken());
    }
}

