/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.impl.client;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.FormattedHeader;
import com.amazonaws.org.apache.http.Header;
import com.amazonaws.org.apache.http.HttpHost;
import com.amazonaws.org.apache.http.HttpResponse;
import com.amazonaws.org.apache.http.auth.AuthOption;
import com.amazonaws.org.apache.http.auth.AuthScheme;
import com.amazonaws.org.apache.http.auth.AuthSchemeRegistry;
import com.amazonaws.org.apache.http.auth.AuthScope;
import com.amazonaws.org.apache.http.auth.Credentials;
import com.amazonaws.org.apache.http.auth.MalformedChallengeException;
import com.amazonaws.org.apache.http.client.AuthCache;
import com.amazonaws.org.apache.http.client.AuthenticationStrategy;
import com.amazonaws.org.apache.http.client.CredentialsProvider;
import com.amazonaws.org.apache.http.impl.client.BasicAuthCache;
import com.amazonaws.org.apache.http.protocol.HTTP;
import com.amazonaws.org.apache.http.protocol.HttpContext;
import com.amazonaws.org.apache.http.util.CharArrayBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthenticationStrategyImpl
implements AuthenticationStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("negotiate", "Kerberos", "NTLM", "Digest", "Basic"));
    private final int challengeCode;
    private final String headerName;
    private final String prefParamName;

    AuthenticationStrategyImpl(int challengeCode, String headerName, String prefParamName) {
        this.challengeCode = challengeCode;
        this.headerName = headerName;
        this.prefParamName = prefParamName;
    }

    @Override
    public boolean isAuthenticationRequested(HttpHost authhost, HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int status = response.getStatusLine().getStatusCode();
        return status == this.challengeCode;
    }

    @Override
    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header[] headers = response.getHeaders(this.headerName);
        HashMap<String, Header> map = new HashMap<String, Header>(headers.length);
        for (Header header : headers) {
            int pos;
            CharArrayBuffer buffer;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s = buffer.substring(beginIndex, endIndex);
            map.put(s.toLowerCase(Locale.US), header);
        }
        return map;
    }

    @Override
    public Queue<AuthOption> select(Map<String, Header> map, HttpHost httpHost, HttpResponse httpResponse, HttpContext httpContext) throws MalformedChallengeException {
        if (map == null) {
            throw new IllegalArgumentException("Map of auth challenges may not be null");
        }
        if (httpHost == null) {
            throw new IllegalArgumentException("Host may not be null");
        }
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        LinkedList<AuthOption> linkedList = new LinkedList<AuthOption>();
        AuthSchemeRegistry authSchemeRegistry = (AuthSchemeRegistry)httpContext.getAttribute("http.authscheme-registry");
        if (authSchemeRegistry == null) {
            this.log.debug("Auth scheme registry not set in the context");
            return linkedList;
        }
        CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
        if (credentialsProvider == null) {
            this.log.debug("Credentials provider not set in the context");
            return linkedList;
        }
        List<String> list = (List<String>)httpResponse.getParams().getParameter(this.prefParamName);
        if (list == null) {
            list = DEFAULT_SCHEME_PRIORITY;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Authentication schemes in the order of preference: " + list);
        }
        for (String string : list) {
            Header header = map.get(string.toLowerCase(Locale.US));
            if (header != null) {
                try {
                    AuthScheme authScheme = authSchemeRegistry.getAuthScheme(string, httpResponse.getParams());
                    authScheme.processChallenge(header);
                    AuthScope authScope = new AuthScope(httpHost.getHostName(), httpHost.getPort(), authScheme.getRealm(), authScheme.getSchemeName());
                    Credentials credentials = credentialsProvider.getCredentials(authScope);
                    if (credentials == null) continue;
                    linkedList.add(new AuthOption(authScheme, credentials));
                }
                catch (IllegalStateException illegalStateException) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("Authentication scheme " + string + " not supported");
                }
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Challenge for " + string + " authentication scheme not available");
        }
        return linkedList;
    }

    @Override
    public void authSucceeded(HttpHost httpHost, AuthScheme authScheme, HttpContext httpContext) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Host may not be null");
        }
        if (authScheme == null) {
            throw new IllegalArgumentException("Auth scheme may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        if (this.isCachable(authScheme)) {
            AuthCache authCache = (AuthCache)httpContext.getAttribute("http.auth.auth-cache");
            if (authCache == null) {
                authCache = new BasicAuthCache();
                httpContext.setAttribute("http.auth.auth-cache", authCache);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caching '" + authScheme.getSchemeName() + "' auth scheme for " + httpHost);
            }
            authCache.put(httpHost, authScheme);
        }
    }

    protected boolean isCachable(AuthScheme authScheme) {
        if (authScheme == null || !authScheme.isComplete()) {
            return false;
        }
        String string = authScheme.getSchemeName();
        return string.equalsIgnoreCase("Basic") || string.equalsIgnoreCase("Digest");
    }

    @Override
    public void authFailed(HttpHost httpHost, AuthScheme authScheme, HttpContext httpContext) {
        if (httpHost == null) {
            throw new IllegalArgumentException("Host may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        AuthCache authCache = (AuthCache)httpContext.getAttribute("http.auth.auth-cache");
        if (authCache != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Clearing cached auth scheme for " + httpHost);
            }
            authCache.remove(httpHost);
        }
    }
}

