/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.impl;

import com.amazonaws.org.apache.http.HttpResponse;
import com.amazonaws.org.apache.http.HttpResponseFactory;
import com.amazonaws.org.apache.http.ReasonPhraseCatalog;
import com.amazonaws.org.apache.http.StatusLine;
import com.amazonaws.org.apache.http.impl.EnglishReasonPhraseCatalog;
import com.amazonaws.org.apache.http.message.BasicHttpResponse;
import com.amazonaws.org.apache.http.protocol.HttpContext;
import java.util.Locale;

public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        if (catalog == null) {
            throw new IllegalArgumentException("Reason phrase catalog must not be null.");
        }
        this.reasonCatalog = catalog;
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        Locale loc = this.determineLocale(context);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

