/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.auth;

import com.amazonaws.org.apache.http.auth.BasicUserPrincipal;
import com.amazonaws.org.apache.http.auth.Credentials;
import com.amazonaws.org.apache.http.util.LangUtils;
import java.io.Serializable;
import java.security.Principal;

public class UsernamePasswordCredentials
implements Credentials,
Serializable {
    private final BasicUserPrincipal principal;
    private final String password;

    public UsernamePasswordCredentials(String usernamePassword) {
        if (usernamePassword == null) {
            throw new IllegalArgumentException("Username:password string may not be null");
        }
        int atColon = usernamePassword.indexOf(58);
        if (atColon >= 0) {
            this.principal = new BasicUserPrincipal(usernamePassword.substring(0, atColon));
            this.password = usernamePassword.substring(atColon + 1);
        } else {
            this.principal = new BasicUserPrincipal(usernamePassword);
            this.password = null;
        }
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials that = (UsernamePasswordCredentials)o;
            if (LangUtils.equals(this.principal, that.principal)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.principal.toString();
    }
}

