/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.metrics.MetricCollector;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.regions.Regions;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.AWSServiceMetrics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum AwsSdkMetrics {

    public static final String DEFAULT_METRIC_NAMESPACE = "AWSSDK/Java";
    private static final String MBEAN_OBJECT_NAME = "com.amazonaws.management:type=" + AwsSdkMetrics.class.getSimpleName();
    public static final String USE_SINGLE_METRIC_NAMESPACE = "useSingleMetricNamespace";
    public static final String EXCLUDE_MACHINE_METRICS = "excludeMachineMetrics";
    public static final String INCLUDE_PER_HOST_METRICS = "includePerHostMetrics";
    public static final String AWS_CREDENTAIL_PROPERTIES_FILE = "credentialFile";
    public static final String CLOUDWATCH_REGION = "cloudwatchRegion";
    public static final String METRIC_QUEUE_SIZE = "metricQueueSize";
    public static final String QUEUE_POLL_TIMEOUT_MILLI = "getQueuePollTimeoutMilli";
    public static final String METRIC_NAME_SPACE = "metricNameSpace";
    public static final String JVM_METRIC_NAME = "jvmMetricName";
    public static final String HOST_METRIC_NAME = "hostMetricName";
    private static final String DEFAULT_METRIC_COLLECTOR_FACTORY = "com.amazonaws.metrics.internal.cloudwatch.DefaultMetricCollectorFactory";
    private static final boolean defaultMetricsEnabled;
    private static volatile AWSCredentialsProvider credentialProvider;
    private static volatile boolean machineMetricsExcluded;
    private static volatile boolean perHostMetricsIncluded;
    private static volatile Regions region;
    private static volatile Integer metricQueueSize;
    private static volatile Long queuePollTimeoutMilli;
    private static volatile String metricNameSpace;
    private static volatile String credentialFile;
    private static volatile String jvmMetricName;
    private static volatile String hostMetricName;
    private static volatile boolean singleMetricNamespace;
    private static final MetricRegistry registry;
    private static volatile MetricCollector mc;
    private static boolean dirtyEnabling;

    public static <T extends RequestMetricCollector> T getRequestMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        RequestMetricCollector requestMetricCollector = mc == null ? RequestMetricCollector.NONE : mc.getRequestMetricCollector();
        return (T)requestMetricCollector;
    }

    public static <T extends ServiceMetricCollector> T getServiceMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        ServiceMetricCollector serviceMetricCollector = mc == null ? ServiceMetricCollector.NONE : mc.getServiceMetricCollector();
        return (T)serviceMetricCollector;
    }

    static MetricCollector getInternalMetricCollector() {
        return mc;
    }

    public static <T extends MetricCollector> T getMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        MetricCollector metricCollector = mc == null ? MetricCollector.NONE : mc;
        return (T)metricCollector;
    }

    public static synchronized void setMetricCollector(MetricCollector metricCollector) {
        MetricCollector metricCollector2 = mc;
        mc = metricCollector;
        if (metricCollector2 != null) {
            metricCollector2.stop();
        }
    }

    public static void setMachineMetricsExcluded(boolean bl) {
        machineMetricsExcluded = bl;
    }

    public static void setPerHostMetricsIncluded(boolean bl) {
        perHostMetricsIncluded = bl;
    }

    public static boolean isDefaultMetricsEnabled() {
        return defaultMetricsEnabled;
    }

    public static boolean isSingleMetricNamespace() {
        return singleMetricNamespace;
    }

    public static void setSingleMetricNamespace(boolean bl) {
        singleMetricNamespace = bl;
    }

    public static boolean isMetricsEnabled() {
        MetricCollector metricCollector = mc;
        return metricCollector != null && metricCollector.isEnabled();
    }

    public static boolean isMachineMetricExcluded() {
        return machineMetricsExcluded;
    }

    public static boolean isPerHostMetricIncluded() {
        return perHostMetricsIncluded;
    }

    public static boolean isPerHostMetricEnabled() {
        if (perHostMetricsIncluded) {
            return true;
        }
        String string = hostMetricName;
        string = string == null ? "" : string.trim();
        return string.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean enableDefaultMetrics() {
        if (mc == null || !mc.isEnabled()) {
            if (dirtyEnabling) {
                throw new IllegalStateException("Reentrancy is not allowed");
            }
            dirtyEnabling = true;
            try {
                Class<?> clazz = Class.forName(DEFAULT_METRIC_COLLECTOR_FACTORY);
                MetricCollector.Factory factory = (MetricCollector.Factory)clazz.newInstance();
                MetricCollector metricCollector = factory.getInstance();
                if (metricCollector != null) {
                    AwsSdkMetrics.setMetricCollector(metricCollector);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                LogFactory.getLog(AwsSdkMetrics.class).warn("Failed to enable the default metrics", exception);
            }
            finally {
                dirtyEnabling = false;
            }
        }
        return false;
    }

    public static void disableMetrics() {
        AwsSdkMetrics.setMetricCollector(MetricCollector.NONE);
    }

    public static boolean add(MetricType metricType) {
        return metricType == null ? false : registry.addMetricType(metricType);
    }

    public static <T extends MetricType> boolean addAll(Collection<T> collection) {
        return collection == null || collection.size() == 0 ? false : registry.addMetricTypes(collection);
    }

    public static <T extends MetricType> void set(Collection<T> collection) {
        registry.setMetricTypes(collection);
    }

    public static boolean remove(MetricType metricType) {
        return metricType == null ? false : registry.removeMetricType(metricType);
    }

    public static Set<MetricType> getPredefinedMetrics() {
        return registry.predefinedMetrics();
    }

    public static AWSCredentialsProvider getCredentialProvider() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!stackTraceElementArray[i].getClassName().equals(DEFAULT_METRIC_COLLECTOR_FACTORY)) continue;
            return credentialProvider;
        }
        SecurityException securityException = new SecurityException();
        LogFactory.getLog(AwsSdkMetrics.class).warn("Illegal attempt to access the credential provider", securityException);
        throw securityException;
    }

    public static synchronized void setCredentialProvider(AWSCredentialsProvider aWSCredentialsProvider) {
        credentialProvider = aWSCredentialsProvider;
    }

    public static Regions getRegion() {
        return region;
    }

    public static void setRegion(Regions regions) {
        region = regions;
    }

    public static String getCredentailFile() {
        return credentialFile;
    }

    public static void setCredentialFile(String string) throws FileNotFoundException, IOException {
        AwsSdkMetrics.setCredentialFile0(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCredentialFile0(String string) throws FileNotFoundException, IOException {
        final PropertiesCredentials propertiesCredentials = new PropertiesCredentials(new File(string));
        Class<AwsSdkMetrics> clazz = AwsSdkMetrics.class;
        synchronized (AwsSdkMetrics.class) {
            credentialProvider = new AWSCredentialsProvider(){

                @Override
                public void refresh() {
                }

                @Override
                public AWSCredentials getCredentials() {
                    return propertiesCredentials;
                }
            };
            credentialFile = string;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Integer getMetricQueueSize() {
        return metricQueueSize;
    }

    public static void setMetricQueueSize(Integer n) {
        metricQueueSize = n;
    }

    public static Long getQueuePollTimeoutMilli() {
        return queuePollTimeoutMilli;
    }

    public static void setQueuePollTimeoutMilli(Long l) {
        queuePollTimeoutMilli = l;
    }

    public static String getMetricNameSpace() {
        return metricNameSpace;
    }

    public static void setMetricNameSpace(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        metricNameSpace = string;
    }

    public static String getJvmMetricName() {
        return jvmMetricName;
    }

    public static void setJvmMetricName(String string) {
        jvmMetricName = string;
    }

    public static String getHostMetricName() {
        return hostMetricName;
    }

    public static void setHostMetricName(String string) {
        hostMetricName = string;
    }

    static {
        metricNameSpace = DEFAULT_METRIC_NAMESPACE;
        String string = System.getProperty("com.amazonaws.sdk.enableDefaultMetrics");
        boolean bl = defaultMetricsEnabled = string != null;
        if (defaultMetricsEnabled) {
            String[] stringArray = string.split(",");
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            for (String string2 : stringArray) {
                String string3 = string2.trim();
                if (!bl2 && EXCLUDE_MACHINE_METRICS.equals(string3)) {
                    bl2 = true;
                    continue;
                }
                if (!bl3 && INCLUDE_PER_HOST_METRICS.equals(string3)) {
                    bl3 = true;
                    continue;
                }
                if (!bl4 && USE_SINGLE_METRIC_NAMESPACE.equals(string3)) {
                    bl4 = true;
                    continue;
                }
                String[] stringArray2 = string3.split("=");
                if (stringArray2.length != 2) continue;
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2[1].trim();
                try {
                    Number number;
                    if (AWS_CREDENTAIL_PROPERTIES_FILE.equals(string4)) {
                        AwsSdkMetrics.setCredentialFile0(string5);
                        continue;
                    }
                    if (CLOUDWATCH_REGION.equals(string4)) {
                        region = Regions.fromName(string5);
                        continue;
                    }
                    if (METRIC_QUEUE_SIZE.equals(string4)) {
                        number = new Integer(string5);
                        if ((Integer)number < 1) {
                            throw new IllegalArgumentException("metricQueueSize must be at least 1");
                        }
                        metricQueueSize = number;
                        continue;
                    }
                    if (QUEUE_POLL_TIMEOUT_MILLI.equals(string4)) {
                        number = new Long(string5);
                        if (((Long)number).intValue() < 1000) {
                            throw new IllegalArgumentException("getQueuePollTimeoutMilli must be at least 1000");
                        }
                        queuePollTimeoutMilli = number;
                        continue;
                    }
                    if (METRIC_NAME_SPACE.equals(string4)) {
                        metricNameSpace = string5;
                        continue;
                    }
                    if (JVM_METRIC_NAME.equals(string4)) {
                        jvmMetricName = string5;
                        continue;
                    }
                    if (HOST_METRIC_NAME.equals(string4)) {
                        hostMetricName = string5;
                        continue;
                    }
                    LogFactory.getLog(AwsSdkMetrics.class).debug("Ignoring unrecognized parameter: " + string3);
                }
                catch (Exception exception) {
                    LogFactory.getLog(AwsSdkMetrics.class).debug("Ignoring failure", exception);
                }
            }
            machineMetricsExcluded = bl2;
            perHostMetricsIncluded = bl3;
            singleMetricNamespace = bl4;
        }
        registry = new MetricRegistry();
    }

    private static class MetricRegistry {
        private final Set<MetricType> metricTypes = new HashSet<MetricType>();
        private volatile Set<MetricType> readOnly;

        MetricRegistry() {
            this.metricTypes.add(AWSRequestMetrics.Field.ClientExecuteTime);
            this.metricTypes.add(AWSRequestMetrics.Field.Exception);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientRetryCount);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpRequestTime);
            this.metricTypes.add(AWSRequestMetrics.Field.RequestCount);
            this.metricTypes.add(AWSRequestMetrics.Field.RetryCount);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientSendRequestTime);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientReceiveResponseTime);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientPoolAvailableCount);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientPoolLeasedCount);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpClientPoolPendingCount);
            this.metricTypes.add(AWSServiceMetrics.HttpClientGetConnectionTime);
            this.syncReadOnly();
        }

        private void syncReadOnly() {
            this.readOnly = Collections.unmodifiableSet(new HashSet<MetricType>(this.metricTypes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addMetricType(MetricType metricType) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean bl = this.metricTypes.add(metricType);
                if (bl) {
                    this.syncReadOnly();
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends MetricType> boolean addMetricTypes(Collection<T> collection) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean bl = this.metricTypes.addAll(collection);
                if (bl) {
                    this.syncReadOnly();
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends MetricType> void setMetricTypes(Collection<T> collection) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                if (collection == null || collection.size() == 0) {
                    if (this.metricTypes.size() == 0) {
                        return;
                    }
                    if (collection == null) {
                        collection = Collections.emptyList();
                    }
                }
                this.metricTypes.clear();
                if (!this.addMetricTypes(collection)) {
                    this.syncReadOnly();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeMetricType(MetricType metricType) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean bl = this.metricTypes.remove(metricType);
                if (bl) {
                    this.syncReadOnly();
                }
                return bl;
            }
        }

        public Set<MetricType> predefinedMetrics() {
            return this.readOnly;
        }
    }
}

