/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream;

import com.amazonaws.javax.xml.stream.Entity;
import com.amazonaws.javax.xml.stream.PropertyManager;
import com.amazonaws.javax.xml.stream.XMLEntityManager;
import com.amazonaws.javax.xml.stream.XMLErrorReporter;
import com.amazonaws.javax.xml.stream.xerces.util.URI;
import com.amazonaws.javax.xml.stream.xerces.util.XMLResourceIdentifierImpl;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class XMLEntityStorage {
    protected boolean fWarnDuplicateEntityDef;
    protected Hashtable fEntities = new Hashtable();
    protected Entity.ScannedEntity fCurrentEntity;
    private XMLEntityManager fEntityManager;
    protected XMLErrorReporter fErrorReporter;
    private static String gUserDir;
    private static String gEscapedUserDir;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    public XMLEntityStorage(XMLEntityManager entityManager) {
        this.fEntityManager = entityManager;
    }

    public void reset(PropertyManager propertyManager) {
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty("http://apache.org/xml/properties/internal/error-reporter");
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    public void reset() {
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    public Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    public void addInternalEntity(String name, String text) {
        if (!this.fEntities.containsKey(name)) {
            this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
            Entity.InternalEntity entity = new Entity.InternalEntity(name, text, false);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public void addExternalEntity(String name, String publicId, String literalSystemId, String baseSystemId) {
        if (!this.fEntities.containsKey(name)) {
            if (baseSystemId == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null) {
                baseSystemId = this.fCurrentEntity.entityLocation.getExpandedSystemId();
            }
            this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
            Entity.ExternalEntity entity = new Entity.ExternalEntity(name, new XMLResourceIdentifierImpl(publicId, literalSystemId, baseSystemId, XMLEntityStorage.expandSystemId(literalSystemId, baseSystemId)), null, true);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public boolean isExternalEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public boolean isEntityDeclInExternalSubset(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isEntityDeclInExternalSubset();
    }

    public void addUnparsedEntity(String name, String publicId, String systemId, String baseSystemId, String notation) {
        this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
        if (!this.fEntities.containsKey(name)) {
            Entity.ExternalEntity entity = new Entity.ExternalEntity(name, new XMLResourceIdentifierImpl(publicId, systemId, baseSystemId, null), notation, false);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public boolean isUnparsedEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public boolean isDeclaredEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        return entity != null;
    }

    private static synchronized String getUserDir() {
        int n;
        int n2;
        String string = "";
        try {
            string = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.equals(gUserDir)) {
            return gEscapedUserDir;
        }
        gUserDir = string;
        char c = File.separatorChar;
        string = string.replace(c, '/');
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 * 3);
        if (n3 >= 2 && string.charAt(1) == ':' && (n2 = Character.toUpperCase(string.charAt(0))) >= 65 && n2 <= 90) {
            stringBuffer.append('/');
        }
        for (n = 0; n < n3 && (n2 = string.charAt(n)) < 128; ++n) {
            if (gNeedEscaping[n2]) {
                stringBuffer.append('%');
                stringBuffer.append(gAfterEscaping1[n2]);
                stringBuffer.append(gAfterEscaping2[n2]);
                continue;
            }
            stringBuffer.append((char)n2);
        }
        if (n < n3) {
            byte[] byArray = null;
            try {
                byArray = string.substring(n).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
            n3 = byArray.length;
            for (n = 0; n < n3; ++n) {
                byte by = byArray[n];
                if (by < 0) {
                    n2 = by + 256;
                    stringBuffer.append('%');
                    stringBuffer.append(gHexChs[n2 >> 4]);
                    stringBuffer.append(gHexChs[n2 & 0xF]);
                    continue;
                }
                if (gNeedEscaping[by]) {
                    stringBuffer.append('%');
                    stringBuffer.append(gAfterEscaping1[by]);
                    stringBuffer.append(gAfterEscaping2[by]);
                    continue;
                }
                stringBuffer.append((char)by);
            }
        }
        if (!string.endsWith("/")) {
            stringBuffer.append('/');
        }
        gEscapedUserDir = stringBuffer.toString();
        return gEscapedUserDir;
    }

    public static String expandSystemId(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            object = new URI(string);
            if (object != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        object = XMLEntityStorage.fixURI(string);
        URI uRI = null;
        URI uRI2 = null;
        try {
            if (string2 == null || string2.length() == 0 || string2.equals(string)) {
                String string3 = XMLEntityStorage.getUserDir();
                uRI = new URI("file", "", string3, null, null);
            } else {
                try {
                    uRI = new URI(XMLEntityStorage.fixURI(string2));
                }
                catch (URI.MalformedURIException malformedURIException) {
                    if (string2.indexOf(58) != -1) {
                        uRI = new URI("file", "", XMLEntityStorage.fixURI(string2), null, null);
                    }
                    String string4 = XMLEntityStorage.getUserDir();
                    string4 = string4 + XMLEntityStorage.fixURI(string2);
                    uRI = new URI("file", "", string4, null, null);
                }
            }
            uRI2 = new URI(uRI, (String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRI2 == null) {
            return string;
        }
        return uRI2.toString();
    }

    protected static String fixURI(String string) {
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2) {
            char c = string.charAt(1);
            if (c == ':') {
                char c2 = Character.toUpperCase(string.charAt(0));
                if (c2 >= 'A' && c2 <= 'Z') {
                    string = "/" + string;
                }
            } else if (c == '/' && string.charAt(0) == '/') {
                string = "file:" + string;
            }
        }
        return string;
    }

    static {
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i <= 31; ++i) {
            XMLEntityStorage.gNeedEscaping[i] = true;
            XMLEntityStorage.gAfterEscaping1[i] = gHexChs[i >> 4];
            XMLEntityStorage.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        XMLEntityStorage.gNeedEscaping[127] = true;
        XMLEntityStorage.gAfterEscaping1[127] = 55;
        XMLEntityStorage.gAfterEscaping2[127] = 70;
        char[] escChs = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        for (int i = 0; i < len; ++i) {
            char ch = escChs[i];
            XMLEntityStorage.gNeedEscaping[ch] = true;
            XMLEntityStorage.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            XMLEntityStorage.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

