/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream;

import com.amazonaws.javax.xml.stream.util.BufferAllocator;
import com.amazonaws.javax.xml.stream.util.ThreadLocalBufferAllocator;
import com.amazonaws.javax.xml.stream.xerces.xni.XMLResourceIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class Entity {
    public String name;
    public boolean inExternalSubset;

    public Entity() {
        this.clear();
    }

    public Entity(String name, boolean inExternalSubset) {
        this.name = name;
        this.inExternalSubset = inExternalSubset;
    }

    public boolean isEntityDeclInExternalSubset() {
        return this.inExternalSubset;
    }

    public abstract boolean isExternal();

    public abstract boolean isUnparsed();

    public void clear() {
        this.name = null;
        this.inExternalSubset = false;
    }

    public static class ScannedEntity
    extends Entity {
        public int fBufferSize = 8192;
        public InputStream stream;
        public Reader reader;
        public XMLResourceIdentifier entityLocation;
        public String encoding;
        public boolean literal;
        public boolean isExternal;
        public String version;
        public char[] ch = null;
        public int position;
        public int count;
        public int lineNumber = 1;
        public int columnNumber = 1;
        public int fTotalCountTillLastLoad;
        public int fLastCount;
        public boolean mayReadChunks;

        public ScannedEntity(String name, XMLResourceIdentifier entityLocation, InputStream stream, Reader reader, String encoding, boolean literal, boolean mayReadChunks, boolean isExternal) {
            this.name = name;
            this.entityLocation = entityLocation;
            this.stream = stream;
            this.reader = reader;
            this.encoding = encoding;
            this.literal = literal;
            this.mayReadChunks = mayReadChunks;
            this.isExternal = isExternal;
            int size = isExternal ? this.fBufferSize : 1024;
            BufferAllocator ba = ThreadLocalBufferAllocator.getBufferAllocator();
            this.ch = ba.getCharBuffer(size);
            if (this.ch == null) {
                this.ch = new char[size];
            }
        }

        public void close() throws IOException {
            BufferAllocator ba = ThreadLocalBufferAllocator.getBufferAllocator();
            ba.returnCharBuffer(this.ch);
            this.ch = null;
            this.reader.close();
        }

        public final boolean isExternal() {
            return this.isExternal;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("name=\"" + this.name + '\"');
            str.append(",ch=" + new String(this.ch));
            str.append(",position=" + this.position);
            str.append(",count=" + this.count);
            return str.toString();
        }
    }

    public static class ExternalEntity
    extends Entity {
        public XMLResourceIdentifier entityLocation;
        public String notation;

        public ExternalEntity() {
            this.clear();
        }

        public ExternalEntity(String name, XMLResourceIdentifier entityLocation, String notation, boolean inExternalSubset) {
            super(name, inExternalSubset);
            this.entityLocation = entityLocation;
            this.notation = notation;
        }

        public final boolean isExternal() {
            return true;
        }

        public final boolean isUnparsed() {
            return this.notation != null;
        }

        public void clear() {
            super.clear();
            this.entityLocation = null;
            this.notation = null;
        }
    }

    public static class InternalEntity
    extends Entity {
        public String text;

        public InternalEntity() {
            this.clear();
        }

        public InternalEntity(String name, String text, boolean inExternalSubset) {
            super(name, inExternalSubset);
            this.text = text;
        }

        public final boolean isExternal() {
            return false;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void clear() {
            super.clear();
            this.text = null;
        }
    }
}

