/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn;

import com.amazonaws.http.conn.ClientConnectionRequestFactory;
import com.amazonaws.http.conn.Wrapped;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.conn.ClientConnectionManager;
import com.amazonaws.org.apache.http.conn.ClientConnectionRequest;
import com.amazonaws.org.apache.http.pool.ConnPoolControl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ClientConnectionManagerFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionManagerFactory.class);

    public static ClientConnectionManager wrap(ClientConnectionManager clientConnectionManager) {
        if (clientConnectionManager instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        Class[] classArray = clientConnectionManager instanceof ConnPoolControl ? new Class[]{ClientConnectionManager.class, ConnPoolControl.class, Wrapped.class} : new Class[]{ClientConnectionManager.class, Wrapped.class};
        return (ClientConnectionManager)Proxy.newProxyInstance(ClientConnectionManagerFactory.class.getClassLoader(), classArray, (InvocationHandler)new Handler(clientConnectionManager));
    }

    private static class Handler
    implements InvocationHandler {
        private final ClientConnectionManager orig;

        Handler(ClientConnectionManager clientConnectionManager) {
            this.orig = clientConnectionManager;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                Object object2 = method.invoke((Object)this.orig, objectArray);
                return object2 instanceof ClientConnectionRequest ? ClientConnectionRequestFactory.wrap((ClientConnectionRequest)object2) : object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                log.debug("", invocationTargetException);
                throw invocationTargetException.getCause();
            }
        }
    }
}

