/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.ser;

import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerationException;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.SerializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.SerializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.NoClass;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.amazonaws.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.amazonaws.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public abstract class DefaultSerializerProvider
extends SerializerProvider
implements Serializable {
    protected transient IdentityHashMap<Object, WritableObjectId> _seenObjectIds;
    protected transient ArrayList<ObjectIdGenerator<?>> _objectIdGenerators;

    protected DefaultSerializerProvider() {
    }

    protected DefaultSerializerProvider(SerializerProvider src, SerializationConfig config, SerializerFactory f) {
        super(src, config, f);
    }

    public abstract DefaultSerializerProvider createInstance(SerializationConfig var1, SerializerFactory var2);

    public void serializeValue(JsonGenerator jgen, Object value) throws IOException, JsonGenerationException {
        boolean wrap;
        JsonSerializer<Object> ser;
        if (value == null) {
            ser = this.getDefaultNullValueSerializer();
            wrap = false;
        } else {
            Class<?> cls = value.getClass();
            ser = this.findTypedValueSerializer(cls, true, null);
            String rootName = this._config.getRootName();
            if (rootName == null) {
                wrap = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
                if (wrap) {
                    jgen.writeStartObject();
                    jgen.writeFieldName(this._rootNames.findRootName(value.getClass(), this._config));
                }
            } else if (rootName.length() == 0) {
                wrap = false;
            } else {
                wrap = true;
                jgen.writeStartObject();
                jgen.writeFieldName(rootName);
            }
        }
        try {
            ser.serialize(value, jgen, this);
            if (wrap) {
                jgen.writeEndObject();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "[no message for " + e.getClass().getName() + "]";
            }
            throw new JsonMappingException(msg, e);
        }
    }

    public void serializeValue(JsonGenerator jgen, Object value, JavaType rootType, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        boolean wrap;
        if (value == null) {
            ser = this.getDefaultNullValueSerializer();
            wrap = false;
        } else {
            if (rootType != null && !rootType.getRawClass().isAssignableFrom(value.getClass())) {
                this._reportIncompatibleRootType(value, rootType);
            }
            if (ser == null) {
                ser = this.findTypedValueSerializer(rootType, true, null);
            }
            if (wrap = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                jgen.writeStartObject();
                jgen.writeFieldName(this._rootNames.findRootName(rootType, this._config));
            }
        }
        try {
            ser.serialize(value, jgen, this);
            if (wrap) {
                jgen.writeEndObject();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "[no message for " + e.getClass().getName() + "]";
            }
            throw new JsonMappingException(msg, e);
        }
    }

    @Override
    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) throws JsonMappingException {
        Class<? extends ObjectIdGenerator<?>> implClass = objectIdInfo.getGeneratorType();
        HandlerInstantiator hi = this._config.getHandlerInstantiator();
        ObjectIdGenerator<?> gen = hi != null ? hi.objectIdGeneratorInstance(this._config, annotated, implClass) : ClassUtil.createInstance(implClass, this._config.canOverrideAccessModifiers());
        return gen.forScope(objectIdInfo.getScope());
    }

    @Override
    public WritableObjectId findObjectId(Object forPojo, ObjectIdGenerator<?> generatorType) {
        if (this._seenObjectIds == null) {
            this._seenObjectIds = new IdentityHashMap();
        } else {
            WritableObjectId oid = this._seenObjectIds.get(forPojo);
            if (oid != null) {
                return oid;
            }
        }
        ObjectIdGenerator<?> generator = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int len = this._objectIdGenerators.size();
            for (int i = 0; i < len; ++i) {
                ObjectIdGenerator<?> gen = this._objectIdGenerators.get(i);
                if (!gen.canUseFor(generatorType)) continue;
                generator = gen;
                break;
            }
        }
        if (generator == null) {
            generator = generatorType.newForSerialization(this);
            this._objectIdGenerators.add(generator);
        }
        WritableObjectId oid = new WritableObjectId(generator);
        this._seenObjectIds.put(forPojo, oid);
        return oid;
    }

    @Override
    public JsonSerializer<Object> serializerInstance(Annotated annotated, Object object) throws JsonMappingException {
        JsonSerializer jsonSerializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonSerializer) {
            jsonSerializer = (JsonSerializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned serializer definition of type " + object.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == JsonSerializer.None.class || clazz == NoClass.class) {
                return null;
            }
            if (!JsonSerializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonSerializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            jsonSerializer = handlerInstantiator != null ? handlerInstantiator.serializerInstance(this._config, annotated, clazz) : (JsonSerializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return this._handleResolvable(jsonSerializer);
    }

    public static final class Impl
    extends DefaultSerializerProvider {
        public Impl() {
        }

        protected Impl(SerializerProvider src, SerializationConfig config, SerializerFactory f) {
            super(src, config, f);
        }

        @Override
        public Impl createInstance(SerializationConfig config, SerializerFactory jsf) {
            return new Impl(this, config, jsf);
        }
    }
}

