/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.Date;

public class WebIdentityFederationSessionCredentialsProvider
implements AWSCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    public static final int DEFAULT_THRESHOLD_SECONDS = 500;
    private final AWSSecurityTokenService securityTokenService;
    private AWSSessionCredentials sessionCredentials;
    private Date sessionCredentialsExpiration;
    private final String wifToken;
    private final String wifProvider;
    private final String roleArn;
    private int sessionDuration;
    private int refreshThreshold;
    private String subjectFromWIF;

    public WebIdentityFederationSessionCredentialsProvider(String string, String string2, String string3) {
        this(string, string2, string3, new ClientConfiguration());
    }

    public WebIdentityFederationSessionCredentialsProvider(String string, String string2, String string3, ClientConfiguration clientConfiguration) {
        this(string, string2, string3, new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), clientConfiguration));
    }

    public WebIdentityFederationSessionCredentialsProvider(String string, String string2, String string3, AWSSecurityTokenService aWSSecurityTokenService) {
        this.securityTokenService = aWSSecurityTokenService;
        this.wifProvider = string2;
        this.wifToken = string;
        this.roleArn = string3;
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    @Override
    public void refresh() {
        this.startSession();
    }

    public void setSessionDuration(int n) {
        this.sessionDuration = n;
    }

    public WebIdentityFederationSessionCredentialsProvider withSessionDuration(int n) {
        this.setSessionDuration(n);
        return this;
    }

    public int getSessionDuration() {
        return this.sessionDuration;
    }

    public void setRefreshThreshold(int n) {
        this.refreshThreshold = n;
    }

    public WebIdentityFederationSessionCredentialsProvider withRefreshThreshold(int n) {
        this.setRefreshThreshold(n);
        return this;
    }

    public int getRefreshThreshold() {
        return this.refreshThreshold;
    }

    public String getSubjectFromWIF() {
        return this.subjectFromWIF;
    }

    private void startSession() {
        AssumeRoleWithWebIdentityResult assumeRoleWithWebIdentityResult = this.securityTokenService.assumeRoleWithWebIdentity(new AssumeRoleWithWebIdentityRequest().withWebIdentityToken(this.wifToken).withProviderId(this.wifProvider).withRoleArn(this.roleArn).withRoleSessionName("ProviderSession").withDurationSeconds(this.sessionDuration));
        Credentials credentials = assumeRoleWithWebIdentityResult.getCredentials();
        this.subjectFromWIF = assumeRoleWithWebIdentityResult.getSubjectFromWebIdentityToken();
        this.sessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        this.sessionCredentialsExpiration = credentials.getExpiration();
    }

    private boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long l = this.sessionCredentialsExpiration.getTime() - System.currentTimeMillis();
        return l < (long)(this.refreshThreshold * 1000);
    }
}

