/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.ChunkContentIterator;
import com.amazonaws.auth.DecodedStreamBuffer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.internal.SdkInputStream;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public final class AwsChunkedEncodingInputStream
extends SdkInputStream {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private static final int DEFAULT_CHUNK_SIZE = 131072;
    private static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final String CLRF = "\r\n";
    private static final String CHUNK_STRING_TO_SIGN_PREFIX = "AWS4-HMAC-SHA256-PAYLOAD";
    private static final String CHUNK_SIGNATURE_HEADER = ";chunk-signature=";
    private static final int SIGNATURE_LENGTH = 64;
    private static final byte[] FINAL_CHUNK = new byte[0];
    private InputStream is = null;
    private final int maxBufferSize;
    private final byte[] kSigning;
    private final String dateTime;
    private final String keyPath;
    private final String headerSignature;
    private String priorChunkSignature;
    private final AWS4Signer aws4Signer;
    private ChunkContentIterator currentChunkIterator;
    private DecodedStreamBuffer decodedStreamBuffer;
    private boolean isAtStart = true;
    private boolean isTerminating = false;
    private static final Log log = LogFactory.getLog(AwsChunkedEncodingInputStream.class);

    public AwsChunkedEncodingInputStream(InputStream inputStream, byte[] byArray, String string, String string2, String string3, AWS4Signer aWS4Signer) {
        this(inputStream, 262144, byArray, string, string2, string3, aWS4Signer);
    }

    public AwsChunkedEncodingInputStream(InputStream inputStream, int n, byte[] byArray, String string, String string2, String string3, AWS4Signer aWS4Signer) {
        if (inputStream instanceof AwsChunkedEncodingInputStream) {
            AwsChunkedEncodingInputStream awsChunkedEncodingInputStream = (AwsChunkedEncodingInputStream)inputStream;
            n = Math.max(awsChunkedEncodingInputStream.maxBufferSize, n);
            this.is = awsChunkedEncodingInputStream.is;
            this.decodedStreamBuffer = awsChunkedEncodingInputStream.decodedStreamBuffer;
        } else {
            this.is = inputStream;
            this.decodedStreamBuffer = null;
        }
        if (n < 131072) {
            throw new IllegalArgumentException("Max buffer size should not be less than chunk size");
        }
        this.maxBufferSize = n;
        this.kSigning = byArray;
        this.dateTime = string;
        this.keyPath = string2;
        this.headerSignature = string3;
        this.priorChunkSignature = string3;
        this.aws4Signer = aWS4Signer;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n != -1) {
            if (log.isDebugEnabled()) {
                log.debug("One byte read from the stream.");
            }
            int n2 = byArray[0] & 0xFF;
            return n2;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.abortIfNeeded();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (null == this.currentChunkIterator || !this.currentChunkIterator.hasNext()) {
            if (this.isTerminating) {
                return -1;
            }
            this.isTerminating = this.setUpNextChunk();
        }
        if ((n3 = this.currentChunkIterator.read(byArray, n, n2)) > 0) {
            this.isAtStart = false;
            if (log.isDebugEnabled()) {
                log.debug(n3 + " byte read from the stream.");
            }
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        int n;
        if (l <= 0L) {
            return 0L;
        }
        int n2 = (int)Math.min(262144L, l);
        byte[] byArray = new byte[n2];
        for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, n2)) >= 0; l2 -= (long)n) {
        }
        return l - l2;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int n) {
        this.abortIfNeeded();
        if (!this.isAtStart) {
            throw new UnsupportedOperationException("Chunk-encoded stream only supports mark() at the start of the stream.");
        }
        if (this.is.markSupported()) {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream marked at the start of the stream (will directly mark the wrapped stream since it's mark-supported).");
            }
            this.is.mark(n);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream marked at the start of the stream (initializing the buffer since the wrapped stream is not mark-supported).");
            }
            this.decodedStreamBuffer = new DecodedStreamBuffer(this.maxBufferSize);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abortIfNeeded();
        this.currentChunkIterator = null;
        this.priorChunkSignature = this.headerSignature;
        if (this.is.markSupported()) {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream reset (will reset the wrapped stream because it is mark-supported).");
            }
            this.is.reset();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("AwsChunkedEncodingInputStream reset (will use the buffer of the decoded stream).");
            }
            if (null == this.decodedStreamBuffer) {
                throw new IOException("Cannot reset the stream because the mark is not set.");
            }
            this.decodedStreamBuffer.startReadBuffer();
        }
        this.currentChunkIterator = null;
        this.isAtStart = true;
        this.isTerminating = false;
    }

    public static long calculateStreamContentLength(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Nonnegative content length expected.");
        }
        long l2 = l / 131072L;
        long l3 = l % 131072L;
        return l2 * AwsChunkedEncodingInputStream.calculateSignedChunkLength(131072L) + (l3 > 0L ? AwsChunkedEncodingInputStream.calculateSignedChunkLength(l3) : 0L) + AwsChunkedEncodingInputStream.calculateSignedChunkLength(0L);
    }

    private static long calculateSignedChunkLength(long l) {
        return (long)(Long.toHexString(l).length() + CHUNK_SIGNATURE_HEADER.length() + 64 + CLRF.length()) + l + (long)CLRF.length();
    }

    private boolean setUpNextChunk() throws IOException {
        byte[] byArray = new byte[131072];
        int n = 0;
        while (n < 131072) {
            if (null != this.decodedStreamBuffer && this.decodedStreamBuffer.hasNext()) {
                byArray[n++] = this.decodedStreamBuffer.next();
                continue;
            }
            int n2 = 131072 - n;
            int n3 = this.is.read(byArray, n, n2);
            if (n3 == -1) break;
            if (null != this.decodedStreamBuffer) {
                this.decodedStreamBuffer.buffer(byArray, n, n3);
            }
            n += n3;
        }
        if (n == 0) {
            byte[] byArray2 = this.createSignedChunk(FINAL_CHUNK);
            this.currentChunkIterator = new ChunkContentIterator(byArray2);
            return true;
        }
        if (n < byArray.length) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            byArray = byArray3;
        }
        byte[] byArray4 = this.createSignedChunk(byArray);
        this.currentChunkIterator = new ChunkContentIterator(byArray4);
        return false;
    }

    private byte[] createSignedChunk(byte[] byArray) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Integer.toHexString(byArray.length));
        String string2 = "";
        String string3 = "AWS4-HMAC-SHA256-PAYLOAD\n" + this.dateTime + "\n" + this.keyPath + "\n" + this.priorChunkSignature + "\n" + BinaryUtils.toHex(this.aws4Signer.hash(string2)) + "\n" + BinaryUtils.toHex(this.aws4Signer.hash(byArray));
        this.priorChunkSignature = string = BinaryUtils.toHex(this.aws4Signer.sign(string3, this.kSigning, SigningAlgorithm.HmacSHA256));
        stringBuilder.append(string2 + CHUNK_SIGNATURE_HEADER + string);
        stringBuilder.append(CLRF);
        try {
            byte[] byArray2 = stringBuilder.toString().getBytes(StringUtils.UTF8);
            byte[] byArray3 = CLRF.getBytes(StringUtils.UTF8);
            byte[] byArray4 = new byte[byArray2.length + byArray.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray4, byArray2.length, byArray.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length + byArray.length, byArray3.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new AmazonClientException("Unable to sign the chunked data. " + exception.getMessage(), exception);
        }
    }

    @Override
    protected InputStream getWrappedInputStream() {
        return this.is;
    }
}

