/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util.json;

import com.amazonaws.AmazonClientException;
import com.amazonaws.util.json.JSONArray;
import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;

public class JSONUtils {
    public static <T> T toObject(Class<T> clazz, String string) throws JSONException {
        JSONObject jSONObject = new JSONObject(string);
        try {
            return JSONUtils.toObject(clazz, jSONObject);
        }
        catch (Exception exception) {
            throw new JSONException(exception);
        }
    }

    private static <T> T toObject(Class<T> clazz, JSONObject jSONObject) throws JSONException, IllegalArgumentException, IllegalAccessException {
        T t;
        try {
            t = JSONUtils.createInstance(clazz);
        }
        catch (Exception exception) {
            throw new AmazonClientException("Failed to instantiate class", exception);
        }
        for (Field field : clazz.getFields()) {
            Object object;
            String string = field.getName();
            Class<?> clazz2 = field.getType();
            try {
                object = JSONUtils.parseField(jSONObject, clazz2, string);
            }
            catch (Exception exception) {
                object = JSONUtils.parseField(jSONObject, clazz2, string.substring(0, 1).toUpperCase() + string.substring(1));
            }
            field.set(t, object);
        }
        return t;
    }

    private static Object parseField(JSONObject jSONObject, Class<?> clazz, String string) throws JSONException, IllegalArgumentException, IllegalAccessException {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return jSONObject.getBoolean(string);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return jSONObject.getDouble(string);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return jSONObject.getInt(string);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return jSONObject.getLong(string);
        }
        if (clazz.equals(String.class)) {
            return jSONObject.getString(string);
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Character.valueOf(jSONObject.getString(string).charAt(0));
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            JSONArray jSONArray = jSONObject.getJSONArray(string);
            Object object = Array.newInstance(clazz2, jSONArray.length());
            for (int i = 0; i < jSONArray.length(); ++i) {
                Array.set(object, i, JSONUtils.parseField(jSONArray, clazz2, i));
            }
            return object;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject(string);
        return JSONUtils.toObject(clazz, jSONObject2);
    }

    private static Object parseField(JSONArray jSONArray, Class<?> clazz, int n) throws JSONException, IllegalArgumentException, IllegalAccessException {
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return jSONArray.getBoolean(n);
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return jSONArray.getDouble(n);
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return jSONArray.getInt(n);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return jSONArray.getLong(n);
        }
        if (clazz.equals(String.class)) {
            return jSONArray.getString(n);
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Character.valueOf(jSONArray.getString(n).charAt(0));
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            JSONArray jSONArray2 = jSONArray.getJSONArray(n);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                linkedList.add(JSONUtils.parseField(jSONArray2, clazz2, i));
            }
            return linkedList.toArray();
        }
        JSONObject jSONObject = jSONArray.getJSONObject(n);
        return JSONUtils.toObject(clazz, jSONObject);
    }

    private static <T> T createInstance(Class<T> clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        T t = null;
        Class<?> clazz2 = clazz.getEnclosingClass();
        if (clazz2 != null) {
            Object obj = JSONUtils.createInstance(clazz2);
            Constructor<T> constructor = clazz.getConstructor(clazz2);
            if (constructor != null) {
                t = constructor.newInstance(obj);
            }
        } else {
            t = clazz.newInstance();
        }
        return t;
    }
}

