/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.ClassLoaderHelper;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/com/amazonaws/sdk/versionInfo.properties";
    private static volatile String version;
    private static volatile String platform;
    private static volatile String userAgent;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (version != null) return version;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlatform() {
        if (platform != null) return platform;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (platform != null) return platform;
            VersionInfoUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return platform;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            VersionInfoUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeVersion() {
        InputStream inputStream = ClassLoaderHelper.getResourceAsStream(VERSION_INFO_FILE, true, VersionInfoUtils.class);
        Properties properties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("/com/amazonaws/sdk/versionInfo.properties not found on classpath");
            }
            properties.load(inputStream);
            version = properties.getProperty("version");
            platform = properties.getProperty("platform");
        }
        catch (Exception exception) {
            log.info("Unable to load version information for the running SDK: " + exception.getMessage());
            version = "unknown-version";
            platform = "java";
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void initializeUserAgent() {
        userAgent = VersionInfoUtils.userAgent();
    }

    static String userAgent() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("aws-sdk-");
        stringBuilder.append(VersionInfoUtils.getPlatform().toLowerCase());
        stringBuilder.append("/");
        stringBuilder.append(VersionInfoUtils.getVersion());
        stringBuilder.append(" ");
        stringBuilder.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.name")));
        stringBuilder.append("/");
        stringBuilder.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.version")));
        stringBuilder.append(" ");
        stringBuilder.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.name")));
        stringBuilder.append("/");
        stringBuilder.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.version")));
        stringBuilder.append("/");
        stringBuilder.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.version")));
        String string = System.getProperty("user.language");
        String string2 = System.getProperty("user.region");
        if (string != null && string2 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(VersionInfoUtils.replaceSpaces(string));
            stringBuilder.append("_");
            stringBuilder.append(VersionInfoUtils.replaceSpaces(string2));
        }
        return stringBuilder.toString();
    }

    private static String replaceSpaces(String string) {
        return string.replace(' ', '_');
    }

    static {
        log = LogFactory.getLog(VersionInfoUtils.class);
    }
}

