/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.regions.Region;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RegionMetadata {
    private final List<Region> regions;

    public RegionMetadata(List<Region> list) {
        if (list == null) {
            throw new IllegalArgumentException("regions cannot be null");
        }
        this.regions = Collections.unmodifiableList(new ArrayList<Region>(list));
    }

    public List<Region> getRegions() {
        return this.regions;
    }

    public Region getRegion(String string) {
        for (Region region : this.regions) {
            if (!region.getName().equals(string)) continue;
            return region;
        }
        return null;
    }

    public List<Region> getRegionsForService(String string) {
        LinkedList<Region> linkedList = new LinkedList<Region>();
        for (Region region : this.regions) {
            if (!region.isServiceSupported(string)) continue;
            linkedList.add(region);
        }
        return linkedList;
    }

    public Region getRegionByEndpoint(String string) {
        String string2 = RegionMetadata.getHost(string);
        for (Region region : this.regions) {
            for (String string3 : region.getServiceEndpoints().values()) {
                if (!string2.equals(RegionMetadata.getHost(string3))) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + string);
    }

    private static String getHost(String string) {
        String string2 = URI.create(string).getHost();
        if (string2 == null) {
            string2 = URI.create("http://" + string).getHost();
        }
        return string2;
    }

    public String toString() {
        return this.regions.toString();
    }
}

