/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.field;

import com.amazonaws.org.joda.time.DateTimeField;
import com.amazonaws.org.joda.time.DateTimeFieldType;
import com.amazonaws.org.joda.time.DurationField;
import com.amazonaws.org.joda.time.IllegalFieldValueException;
import java.util.Locale;

public abstract class BaseDateTimeField
extends DateTimeField {
    private final DateTimeFieldType iType;

    protected BaseDateTimeField(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = dateTimeFieldType;
    }

    public final DateTimeFieldType getType() {
        return this.iType;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public final boolean isSupported() {
        return true;
    }

    public abstract int get(long var1);

    public String getAsText(long l, Locale locale) {
        return this.getAsText(this.get(l), locale);
    }

    public String getAsText(int n, Locale locale) {
        return Integer.toString(n);
    }

    public String getAsShortText(long l, Locale locale) {
        return this.getAsShortText(this.get(l), locale);
    }

    public String getAsShortText(int n, Locale locale) {
        return this.getAsText(n, locale);
    }

    public long add(long l, int n) {
        return this.getDurationField().add(l, n);
    }

    public long add(long l, long l2) {
        return this.getDurationField().add(l, l2);
    }

    public abstract long set(long var1, int var3);

    public long set(long l, String string, Locale locale) {
        int n = this.convertText(string, locale);
        return this.set(l, n);
    }

    protected int convertText(String string, Locale locale) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalFieldValueException(this.getType(), string);
        }
    }

    public abstract DurationField getDurationField();

    public boolean isLeap(long l) {
        return false;
    }

    public DurationField getLeapDurationField() {
        return null;
    }

    public abstract int getMaximumValue();

    public int getMaximumValue(long l) {
        return this.getMaximumValue();
    }

    public int getMaximumTextLength(Locale locale) {
        int n = this.getMaximumValue();
        if (n >= 0) {
            if (n < 10) {
                return 1;
            }
            if (n < 100) {
                return 2;
            }
            if (n < 1000) {
                return 3;
            }
        }
        return Integer.toString(n).length();
    }

    public abstract long roundFloor(long var1);

    public long roundCeiling(long l) {
        long l2 = this.roundFloor(l);
        if (l2 != l) {
            l = this.add(l2, 1);
        }
        return l;
    }

    public long roundHalfFloor(long l) {
        long l2;
        long l3;
        long l4 = this.roundFloor(l);
        long l5 = l - l4;
        if (l5 <= (l3 = (l2 = this.roundCeiling(l)) - l)) {
            return l4;
        }
        return l2;
    }

    public long roundHalfCeiling(long l) {
        long l2;
        long l3 = this.roundFloor(l);
        long l4 = this.roundCeiling(l);
        long l5 = l4 - l;
        if (l5 <= (l2 = l - l3)) {
            return l4;
        }
        return l3;
    }

    public long roundHalfEven(long l) {
        long l2;
        long l3;
        long l4 = this.roundFloor(l);
        long l5 = l - l4;
        if (l5 < (l3 = (l2 = this.roundCeiling(l)) - l)) {
            return l4;
        }
        if (l3 < l5) {
            return l2;
        }
        if ((this.get(l2) & 1) == 0) {
            return l2;
        }
        return l4;
    }

    public long remainder(long l) {
        return l - this.roundFloor(l);
    }

    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }
}

